/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;

public class JFileChooserOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    private static final long WAIT_LIST_PAINTED_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private ComponentSearcher innerSearcher;
    static /* synthetic */ Class class$javax$swing$JFileChooser;

    public JFileChooserOperator(JFileChooser jFileChooser) {
        super(jFileChooser);
        this.innerSearcher = new ComponentSearcher(jFileChooser);
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
    }

    public JFileChooserOperator(Operator operator) {
        this((JFileChooser)JFileChooserOperator.waitComponent(JDialogOperator.waitJDialog(new JFileChooserJDialogFinder(operator.getOutput()), 0, operator.getTimeouts(), operator.getOutput()), new JFileChooserFinder(), 0, operator.getTimeouts(), operator.getOutput()));
        this.copyEnvironment(operator);
    }

    public JFileChooserOperator() {
        this(JFileChooserOperator.getEnvironmentOperator());
    }

    public static JDialog findJFileChooserDialog() {
        return JDialogOperator.findJDialog(new JFileChooserJDialogFinder(JemmyProperties.getCurrentOutput()));
    }

    public static JDialog waitJFileChooserDialog() {
        return JDialogOperator.waitJDialog(new JFileChooserJDialogFinder(JemmyProperties.getCurrentOutput()));
    }

    public static JFileChooser findJFileChooser(Container container) {
        return (JFileChooser)JFileChooserOperator.findComponent(container, new JFileChooserFinder());
    }

    public static JFileChooser waitJFileChooser(Container container) {
        return (JFileChooser)JFileChooserOperator.waitComponent(container, new JFileChooserFinder());
    }

    public static JFileChooser findJFileChooser() {
        return JFileChooserOperator.findJFileChooser(JFileChooserOperator.findJFileChooserDialog());
    }

    public static JFileChooser waitJFileChooser() {
        return JFileChooserOperator.waitJFileChooser(JFileChooserOperator.waitJFileChooserDialog());
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
        if (this.innerSearcher != null) {
            this.innerSearcher.setOutput(this.output.createErrorOutput());
        }
    }

    public TestOut getOutput() {
        return this.output;
    }

    public JComboBox getPathCombo() {
        return this.getCombo(0);
    }

    public JComboBox getFileTypesCombo() {
        return this.getCombo(1);
    }

    public JButton getApproveButton() {
        String string = this.getApproveButtonText();
        if (string == null) {
            string = this.getUI().getApproveButtonText((JFileChooser)this.getSource());
        }
        if (string != null) {
            return (JButton)this.innerSearcher.findComponent(new ButtonFinder(string));
        }
        throw new JemmyException("JFileChooser.getApproveButtonText() and getUI().getApproveButtonText return null");
    }

    public JButton getCancelButton() {
        return (JButton)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component != null && component instanceof JButton && component.getParent() != null && !(component.getParent() instanceof JComboBox) && ((JButton)component).getText() != null && ((JButton)component).getText().length() != 0;
            }

            public String getDescription() {
                return "JButton";
            }
        }, 1);
    }

    public JButton getHomeButton() {
        return this.getNoTextButton(1);
    }

    public JButton getUpLevelButton() {
        return this.getNoTextButton(0);
    }

    public JToggleButton getListToggleButton() {
        return this.getToggleButton(0);
    }

    public JToggleButton getDetailsToggleButton() {
        return this.getToggleButton(1);
    }

    public JTextField getPathField() {
        return (JTextField)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component != null && component instanceof JTextField;
            }

            public String getDescription() {
                return "JTextField";
            }
        });
    }

    public JList getFileList() {
        return (JList)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component != null && component instanceof JList;
            }

            public String getDescription() {
                return "JList";
            }
        });
    }

    public void approve() {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Push approve button in JFileChooser\n    : " + this.toStringSource());
        JButtonOperator jButtonOperator = new JButtonOperator(this.getApproveButton());
        jButtonOperator.copyEnvironment(this);
        jButtonOperator.setOutput(this.output.createErrorOutput());
        jButtonOperator.push();
    }

    public void cancel() {
        this.output.printTrace("Push cancel button in JFileChooser\n    : " + this.toStringSource());
        JButtonOperator jButtonOperator = new JButtonOperator(this.getCancelButton());
        jButtonOperator.copyEnvironment(this);
        jButtonOperator.setOutput(this.output.createErrorOutput());
        jButtonOperator.push();
    }

    public void chooseFile(String string) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Choose file by JFileChooser\n    : " + string + "\n    : " + this.toStringSource());
        JTextFieldOperator jTextFieldOperator = new JTextFieldOperator(this.getPathField());
        jTextFieldOperator.copyEnvironment(this);
        jTextFieldOperator.setOutput(this.output.createErrorOutput());
        jTextFieldOperator.setText(string);
        this.approve();
    }

    public File goUpLevel() {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Go up level in JFileChooser\n    : " + this.toStringSource());
        this.setCurrentDirectory(this.getCurrentDirectory().getParentFile());
        this.waitPainted(-1);
        return this.getCurrentDirectory();
    }

    public File goHome() {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Go home in JFileChooser\n    : " + this.toStringSource());
        JButtonOperator jButtonOperator = new JButtonOperator(this.getHomeButton());
        jButtonOperator.copyEnvironment(this);
        jButtonOperator.setOutput(this.output.createErrorOutput());
        jButtonOperator.push();
        this.waitPainted(-1);
        return this.getCurrentDirectory();
    }

    public void clickOnFile(int n, int n2) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Click " + Integer.toString(n2) + "times on " + Integer.toString(n) + "`th file in JFileChooser\n    : " + this.toStringSource());
        JListOperator jListOperator = new JListOperator(this.getFileList());
        this.waitPainted(n);
        jListOperator.copyEnvironment(this);
        jListOperator.setOutput(this.output.createErrorOutput());
        jListOperator.clickOnItem(n, n2);
    }

    public void clickOnFile(String string, Operator.StringComparator stringComparator, int n) {
        this.output.printTrace("Click " + Integer.toString(n) + "times on \"" + string + "\" file in JFileChooser\n    : " + this.toStringSource());
        this.clickOnFile(this.findFileIndex(string, stringComparator), n);
    }

    public void clickOnFile(String string, boolean bl, boolean bl2, int n) {
        this.clickOnFile(string, new Operator.DefaultStringComparator(bl, bl2), n);
    }

    public void clickOnFile(String string, int n) {
        this.clickOnFile(string, this.getComparator(), n);
    }

    public void clickOnFile(String string, Operator.StringComparator stringComparator) {
        this.clickOnFile(string, stringComparator, 1);
    }

    public void clickOnFile(String string, boolean bl, boolean bl2) {
        this.clickOnFile(string, bl, bl2, 1);
    }

    public void clickOnFile(String string) {
        this.clickOnFile(string, 1);
    }

    public File enterSubDir(String string, Operator.StringComparator stringComparator) {
        this.getQueueTool().waitEmpty();
        this.selectFile(string, stringComparator);
        int n = this.findFileIndex(string, stringComparator);
        this.waitPainted(n);
        this.setCurrentDirectory(this.getSelectedFile());
        return this.getCurrentDirectory();
    }

    public File enterSubDir(String string, boolean bl, boolean bl2) {
        return this.enterSubDir(string, new Operator.DefaultStringComparator(bl, bl2));
    }

    public File enterSubDir(String string) {
        return this.enterSubDir(string, this.getComparator());
    }

    public void selectFile(String string, Operator.StringComparator stringComparator) {
        this.getQueueTool().waitEmpty();
        int n = this.findFileIndex(string, stringComparator);
        JListOperator jListOperator = new JListOperator(this.getFileList());
        this.waitPainted(n);
        jListOperator.copyEnvironment(this);
        jListOperator.setOutput(this.output.createErrorOutput());
        jListOperator.setSelectedIndex(n);
    }

    public void selectFile(String string, boolean bl, boolean bl2) {
        this.clickOnFile(string, bl, bl2);
    }

    public void selectFile(String string) {
        this.clickOnFile(string);
    }

    public void selectPathDirectory(String string, Operator.StringComparator stringComparator) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Select \"" + string + "\" directory in JFileChooser\n    : " + this.toStringSource());
        JComboBoxOperator jComboBoxOperator = new JComboBoxOperator(this.getPathCombo());
        jComboBoxOperator.copyEnvironment(this);
        jComboBoxOperator.setOutput(this.output.createErrorOutput());
        jComboBoxOperator.setSelectedIndex(this.findDirIndex(string, stringComparator));
        this.waitPainted(-1);
    }

    public void selectPathDirectory(String string, boolean bl, boolean bl2) {
        this.selectPathDirectory(string, new Operator.DefaultStringComparator(bl, bl2));
    }

    public void selectPathDirectory(String string) {
        this.selectPathDirectory(string, this.getComparator());
    }

    public void selectFileType(String string, Operator.StringComparator stringComparator) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Select \"" + string + "\" file type in JFileChooser\n    : " + this.toStringSource());
        JComboBoxOperator jComboBoxOperator = new JComboBoxOperator(this.getFileTypesCombo());
        jComboBoxOperator.copyEnvironment(this);
        jComboBoxOperator.setOutput(this.output.createErrorOutput());
        jComboBoxOperator.setSelectedIndex(this.findFileTypeIndex(string, stringComparator));
        this.waitPainted(-1);
    }

    public void selectFileType(String string, boolean bl, boolean bl2) {
        this.selectFileType(string, new Operator.DefaultStringComparator(bl, bl2));
    }

    public void selectFileType(String string) {
        this.selectFileType(string, this.getComparator());
    }

    public boolean checkFileDisplayed(String string, Operator.StringComparator stringComparator) {
        this.waitPainted(-1);
        return this.findFileIndex(string, stringComparator) != -1;
    }

    public boolean checkFileDisplayed(String string, boolean bl, boolean bl2) {
        return this.checkFileDisplayed(string, new Operator.DefaultStringComparator(bl, bl2));
    }

    public boolean checkFileDisplayed(String string) {
        return this.checkFileDisplayed(string, this.getComparator());
    }

    public int getFileCount() {
        this.waitPainted(-1);
        return this.getFileList().getModel().getSize();
    }

    public File[] getFiles() {
        this.waitPainted(-1);
        ListModel listModel = this.getFileList().getModel();
        File[] fileArray = new File[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            fileArray[i] = (File)listModel.getElementAt(i);
        }
        return fileArray;
    }

    public void waitFileCount(final int n) {
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JFileChooserOperator.this.getFileCount() == n;
            }

            public String getDescription() {
                return "Count of files to be equal " + Integer.toString(n);
            }
        });
    }

    public void waitFileDisplayed(final String string) {
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JFileChooserOperator.this.checkFileDisplayed(string);
            }

            public String getDescription() {
                return "\"" + string + "\"file to be displayed";
            }
        });
    }

    public boolean accept(final File file) {
        return this.runMapping(new Operator.MapBooleanAction("accept"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).accept(file);
            }
        });
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addChoosableFileFilter(final FileFilter fileFilter) {
        this.runMapping(new Operator.MapVoidAction("addChoosableFileFilter"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).addChoosableFileFilter(fileFilter);
            }
        });
    }

    public void approveSelection() {
        this.runMapping(new Operator.MapVoidAction("approveSelection"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).approveSelection();
            }
        });
    }

    public void cancelSelection() {
        this.runMapping(new Operator.MapVoidAction("cancelSelection"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).cancelSelection();
            }
        });
    }

    public void changeToParentDirectory() {
        this.runMapping(new Operator.MapVoidAction("changeToParentDirectory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).changeToParentDirectory();
            }
        });
    }

    public void ensureFileIsVisible(final File file) {
        this.runMapping(new Operator.MapVoidAction("ensureFileIsVisible"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).ensureFileIsVisible(file);
            }
        });
    }

    public FileFilter getAcceptAllFileFilter() {
        return (FileFilter)this.runMapping(new Operator.MapAction("getAcceptAllFileFilter"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getAcceptAllFileFilter();
            }
        });
    }

    public JComponent getAccessory() {
        return (JComponent)this.runMapping(new Operator.MapAction("getAccessory"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getAccessory();
            }
        });
    }

    public int getApproveButtonMnemonic() {
        return this.runMapping(new Operator.MapIntegerAction("getApproveButtonMnemonic"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getApproveButtonMnemonic();
            }
        });
    }

    public String getApproveButtonText() {
        return (String)this.runMapping(new Operator.MapAction("getApproveButtonText"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getApproveButtonText();
            }
        });
    }

    public String getApproveButtonToolTipText() {
        return (String)this.runMapping(new Operator.MapAction("getApproveButtonToolTipText"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getApproveButtonToolTipText();
            }
        });
    }

    public FileFilter[] getChoosableFileFilters() {
        return (FileFilter[])this.runMapping(new Operator.MapAction("getChoosableFileFilters"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getChoosableFileFilters();
            }
        });
    }

    public File getCurrentDirectory() {
        return (File)this.runMapping(new Operator.MapAction("getCurrentDirectory"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getCurrentDirectory();
            }
        });
    }

    public String getDescription(final File file) {
        return (String)this.runMapping(new Operator.MapAction("getDescription"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getDescription(file);
            }
        });
    }

    public String getDialogTitle() {
        return (String)this.runMapping(new Operator.MapAction("getDialogTitle"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getDialogTitle();
            }
        });
    }

    public int getDialogType() {
        return this.runMapping(new Operator.MapIntegerAction("getDialogType"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getDialogType();
            }
        });
    }

    public FileFilter getFileFilter() {
        return (FileFilter)this.runMapping(new Operator.MapAction("getFileFilter"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileFilter();
            }
        });
    }

    public int getFileSelectionMode() {
        return this.runMapping(new Operator.MapIntegerAction("getFileSelectionMode"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileSelectionMode();
            }
        });
    }

    public FileSystemView getFileSystemView() {
        return (FileSystemView)this.runMapping(new Operator.MapAction("getFileSystemView"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileSystemView();
            }
        });
    }

    public FileView getFileView() {
        return (FileView)this.runMapping(new Operator.MapAction("getFileView"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileView();
            }
        });
    }

    public Icon getIcon(final File file) {
        return (Icon)this.runMapping(new Operator.MapAction("getIcon"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getIcon(file);
            }
        });
    }

    public String getName(final File file) {
        return (String)this.runMapping(new Operator.MapAction("getName"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getName(file);
            }
        });
    }

    public File getSelectedFile() {
        return (File)this.runMapping(new Operator.MapAction("getSelectedFile"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getSelectedFile();
            }
        });
    }

    public File[] getSelectedFiles() {
        return (File[])this.runMapping(new Operator.MapAction("getSelectedFiles"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getSelectedFiles();
            }
        });
    }

    public String getTypeDescription(final File file) {
        return (String)this.runMapping(new Operator.MapAction("getTypeDescription"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getTypeDescription(file);
            }
        });
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isDirectorySelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isDirectorySelectionEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isDirectorySelectionEnabled();
            }
        });
    }

    public boolean isFileHidingEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isFileHidingEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isFileHidingEnabled();
            }
        });
    }

    public boolean isFileSelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isFileSelectionEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isFileSelectionEnabled();
            }
        });
    }

    public boolean isMultiSelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isMultiSelectionEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isMultiSelectionEnabled();
            }
        });
    }

    public boolean isTraversable(final File file) {
        return this.runMapping(new Operator.MapBooleanAction("isTraversable"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isTraversable(file);
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public boolean removeChoosableFileFilter(final FileFilter fileFilter) {
        return this.runMapping(new Operator.MapBooleanAction("removeChoosableFileFilter"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).removeChoosableFileFilter(fileFilter);
            }
        });
    }

    public void rescanCurrentDirectory() {
        this.runMapping(new Operator.MapVoidAction("rescanCurrentDirectory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).rescanCurrentDirectory();
            }
        });
    }

    public void resetChoosableFileFilters() {
        this.runMapping(new Operator.MapVoidAction("resetChoosableFileFilters"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).resetChoosableFileFilters();
            }
        });
    }

    public void setAccessory(final JComponent jComponent) {
        this.runMapping(new Operator.MapVoidAction("setAccessory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setAccessory(jComponent);
            }
        });
    }

    public void setApproveButtonMnemonic(final char c) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonMnemonic"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonMnemonic(c);
            }
        });
    }

    public void setApproveButtonMnemonic(final int n) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonMnemonic"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonMnemonic(n);
            }
        });
    }

    public void setApproveButtonText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonText"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonText(string);
            }
        });
    }

    public void setApproveButtonToolTipText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonToolTipText"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonToolTipText(string);
            }
        });
    }

    public void setCurrentDirectory(final File file) {
        this.runMapping(new Operator.MapVoidAction("setCurrentDirectory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setCurrentDirectory(file);
            }
        });
    }

    public void setDialogTitle(final String string) {
        this.runMapping(new Operator.MapVoidAction("setDialogTitle"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setDialogTitle(string);
            }
        });
    }

    public void setDialogType(final int n) {
        this.runMapping(new Operator.MapVoidAction("setDialogType"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setDialogType(n);
            }
        });
    }

    public void setFileFilter(final FileFilter fileFilter) {
        this.runMapping(new Operator.MapVoidAction("setFileFilter"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileFilter(fileFilter);
            }
        });
    }

    public void setFileHidingEnabled(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setFileHidingEnabled"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileHidingEnabled(bl);
            }
        });
    }

    public void setFileSelectionMode(final int n) {
        this.runMapping(new Operator.MapVoidAction("setFileSelectionMode"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileSelectionMode(n);
            }
        });
    }

    public void setFileSystemView(final FileSystemView fileSystemView) {
        this.runMapping(new Operator.MapVoidAction("setFileSystemView"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileSystemView(fileSystemView);
            }
        });
    }

    public void setFileView(final FileView fileView) {
        this.runMapping(new Operator.MapVoidAction("setFileView"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileView(fileView);
            }
        });
    }

    public void setMultiSelectionEnabled(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setMultiSelectionEnabled"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setMultiSelectionEnabled(bl);
            }
        });
    }

    public void setSelectedFile(final File file) {
        this.runMapping(new Operator.MapVoidAction("setSelectedFile"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setSelectedFile(file);
            }
        });
    }

    public void setSelectedFiles(final File[] fileArray) {
        this.runMapping(new Operator.MapVoidAction("setSelectedFiles"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setSelectedFiles(fileArray);
            }
        });
    }

    public int showDialog(final Component component, final String string) {
        return this.runMapping(new Operator.MapIntegerAction("showDialog"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).showDialog(component, string);
            }
        });
    }

    public int showOpenDialog(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("showOpenDialog"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).showOpenDialog(component);
            }
        });
    }

    public int showSaveDialog(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("showSaveDialog"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).showSaveDialog(component);
            }
        });
    }

    private void waitPainted(int n) {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                JList jList = JFileChooserOperator.this.getFileList();
                int n = jList.getModel().getSize() - 1;
                if (n == -1) {
                    return "";
                }
                int n2 = object != null ? (Integer)object : 0;
                try {
                    if (jList.getCellBounds(n2, n2) != null) {
                        return jList.getCellBounds(n, n);
                    }
                    return null;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }

            public String getDescription() {
                return "List drawed";
            }
        });
        waiter.setTimeouts(this.getTimeouts().cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JFileChooserOperator.WaitListPaintedTimeout"));
        waiter.setOutput(this.getOutput().createErrorOutput());
        try {
            waiter.waitAction(n != -1 ? new Integer(n) : null);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
        }
    }

    private JComboBox getCombo(int n) {
        return (JComboBox)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component != null && component instanceof JComboBox;
            }

            public String getDescription() {
                return "JComboBox";
            }
        }, n);
    }

    private JButton getNoTextButton(int n) {
        return (JButton)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component != null && component instanceof JButton && !(component.getParent() instanceof JComboBox) && (((JButton)component).getText() == null || ((JButton)component).getText().length() == 0);
            }

            public String getDescription() {
                return "JButton";
            }
        }, n);
    }

    private JToggleButton getToggleButton(int n) {
        return (JToggleButton)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component != null && component instanceof JToggleButton;
            }

            public String getDescription() {
                return "JToggleButton";
            }
        }, n);
    }

    private int findFileIndex(final String string, final Operator.StringComparator stringComparator) {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                File[] fileArray = JFileChooserOperator.this.getFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!stringComparator.equals(fileArray[i].getName(), string)) continue;
                    return new Integer(i);
                }
                return null;
            }

            public String getDescription() {
                return "\"" + string + "\" file to be displayed";
            }
        });
        waiter.setOutput(this.getOutput().createErrorOutput());
        waiter.setTimeouts(this.getTimeouts().cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JFileChooserOperator.WaitListPaintedTimeout"));
        try {
            return (Integer)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting has been interrupted!");
        }
    }

    private int findDirIndex(String string, Operator.StringComparator stringComparator) {
        ComboBoxModel comboBoxModel = this.getPathCombo().getModel();
        for (int i = comboBoxModel.getSize() - 1; i >= 0; --i) {
            if (!stringComparator.equals(((File)comboBoxModel.getElementAt(i)).getName(), string)) continue;
            return i;
        }
        return -1;
    }

    private int findFileTypeIndex(String string, Operator.StringComparator stringComparator) {
        ComboBoxModel comboBoxModel = this.getFileTypesCombo().getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!stringComparator.equals(((FileFilter)comboBoxModel.getElementAt(i)).getDescription(), string)) continue;
            return i;
        }
        return -1;
    }

    static {
        Timeouts.initDefault("JFileChooserOperator.WaitListPaintedTimeout", 60000L);
    }

    private class ButtonFinder
    implements ComponentChooser {
        String text;

        public ButtonFinder(String string) {
            this.text = string;
        }

        public boolean checkComponent(Component component) {
            return component != null && component instanceof JButton && ((JButton)component).getText() != null && ((JButton)component).getText().equals(this.text);
        }

        public String getDescription() {
            return "\"" + this.text + "\" button";
        }
    }

    public static class JFileChooserFinder
    extends Operator.Finder {
        public JFileChooserFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = JFileChooserOperator.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser, componentChooser);
        }

        public JFileChooserFinder() {
            super(class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = JFileChooserOperator.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser);
        }
    }

    public static class JFileChooserJDialogFinder
    implements ComponentChooser {
        TestOut output;
        ComponentChooser subChooser;

        public JFileChooserJDialogFinder(TestOut testOut) {
            this.output = testOut;
            this.subChooser = new JFileChooserFinder();
        }

        public boolean checkComponent(Component component) {
            if (component != null && component instanceof Window && ((Window)component).isVisible()) {
                ComponentSearcher componentSearcher = new ComponentSearcher((Container)component);
                componentSearcher.setOutput(this.output);
                return componentSearcher.findComponent(this.subChooser) != null;
            }
            return false;
        }

        public String getDescription() {
            return "JFileChooser's window";
        }
    }
}

