/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.FrameWaiter;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.FrameDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;

public class FrameOperator
extends WindowOperator
implements Outputable {
    public static final String TITLE_DPROP = "Title";
    public static final String STATE_DPROP = "State";
    public static final String STATE_NORMAL_DPROP_VALUE = "NORMAL";
    public static final String STATE_ICONIFIED_DPROP_VALUE = "ICONIFIED";
    public static final String IS_RESIZABLE_DPROP = "Resizable";
    TestOut output;
    FrameDriver driver = DriverManager.getFrameDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Frame;

    public FrameOperator(Frame frame) {
        super(frame);
    }

    public FrameOperator(ComponentChooser componentChooser, int n, Operator operator) {
        this(FrameOperator.waitFrame(new FrameFinder(componentChooser), n, operator.getTimeouts(), operator.getOutput()));
        this.copyEnvironment(operator);
    }

    public FrameOperator(ComponentChooser componentChooser, int n) {
        this(componentChooser, n, Operator.getEnvironmentOperator());
    }

    public FrameOperator(ComponentChooser componentChooser) {
        this(componentChooser, 0);
    }

    public FrameOperator(String string, int n, Operator operator) {
        this(FrameOperator.waitFrame(new FrameByTitleFinder(string, operator.getComparator()), n, operator.getTimeouts(), operator.getOutput()));
        this.copyEnvironment(operator);
    }

    public FrameOperator(String string, int n) {
        this(string, n, ComponentOperator.getEnvironmentOperator());
    }

    public FrameOperator(String string) {
        this(string, 0);
    }

    public FrameOperator(int n) {
        this(FrameOperator.waitFrame(new FrameFinder(), n, ComponentOperator.getEnvironmentOperator().getTimeouts(), ComponentOperator.getEnvironmentOperator().getOutput()));
        this.copyEnvironment(ComponentOperator.getEnvironmentOperator());
    }

    public FrameOperator() {
        this(0);
    }

    public void setOutput(TestOut testOut) {
        super.setOutput(testOut);
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (FrameDriver)DriverManager.getDriver("drivers.frame", this.getClass(), operator.getProperties());
    }

    public void waitTitle(String string) {
        this.getOutput().printLine("Wait \"" + string + "\" title of frame \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + "\" title");
        this.waitState(new FrameByTitleFinder(string, this.getComparator()));
    }

    public void iconify() {
        this.output.printLine("Iconifying frame\n    " + this.toStringSource());
        this.output.printGolden("Iconifying frame");
        this.driver.iconify(this);
        if (this.getVerification()) {
            this.waitState(1);
        }
    }

    public void deiconify() {
        this.output.printLine("Deiconifying frame\n    " + this.toStringSource());
        this.output.printGolden("Deiconifying frame");
        this.driver.deiconify(this);
        if (this.getVerification()) {
            this.waitState(0);
        }
    }

    public void maximize() {
        this.output.printLine("Maximizing frame\n    " + this.toStringSource());
        this.output.printGolden("Maximizing frame");
        this.driver.maximize(this);
        if (this.getVerification()) {
            this.waitState(0);
        }
    }

    public void demaximize() {
        this.output.printLine("Demaximizing frame\n    " + this.toStringSource());
        this.output.printGolden("Demaximizing frame");
        this.driver.demaximize(this);
        if (this.getVerification()) {
            this.waitState(0);
        }
    }

    public void waitState(final int n) {
        this.getOutput().printLine("Wait frame to have " + Integer.toString(n) + " state \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait frame to have " + Integer.toString(n) + " state");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return ((Frame)component).getState() == n;
            }

            public String getDescription() {
                return Integer.toString(n) + " state";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (((Frame)this.getSource()).getTitle() != null) {
            hashtable.put(TITLE_DPROP, ((Frame)this.getSource()).getTitle());
        }
        hashtable.put(STATE_DPROP, ((Frame)this.getSource()).getState() == 1 ? STATE_ICONIFIED_DPROP_VALUE : STATE_NORMAL_DPROP_VALUE);
        hashtable.put(IS_RESIZABLE_DPROP, ((Frame)this.getSource()).isResizable() ? "true" : "false");
        return hashtable;
    }

    public Image getIconImage() {
        return (Image)this.runMapping(new Operator.MapAction("getIconImage"){

            public Object map() {
                return ((Frame)FrameOperator.this.getSource()).getIconImage();
            }
        });
    }

    public MenuBar getMenuBar() {
        return (MenuBar)this.runMapping(new Operator.MapAction("getMenuBar"){

            public Object map() {
                return ((Frame)FrameOperator.this.getSource()).getMenuBar();
            }
        });
    }

    public int getState() {
        return this.runMapping(new Operator.MapIntegerAction("getState"){

            public int map() {
                return ((Frame)FrameOperator.this.getSource()).getState();
            }
        });
    }

    public String getTitle() {
        return (String)this.runMapping(new Operator.MapAction("getTitle"){

            public Object map() {
                return ((Frame)FrameOperator.this.getSource()).getTitle();
            }
        });
    }

    public boolean isResizable() {
        return this.runMapping(new Operator.MapBooleanAction("isResizable"){

            public boolean map() {
                return ((Frame)FrameOperator.this.getSource()).isResizable();
            }
        });
    }

    public void setIconImage(final Image image) {
        this.runMapping(new Operator.MapVoidAction("setIconImage"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setIconImage(image);
            }
        });
    }

    public void setMenuBar(final MenuBar menuBar) {
        this.runMapping(new Operator.MapVoidAction("setMenuBar"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setMenuBar(menuBar);
            }
        });
    }

    public void setResizable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setResizable"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setResizable(bl);
            }
        });
    }

    public void setState(final int n) {
        this.runMapping(new Operator.MapVoidAction("setState"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setState(n);
            }
        });
    }

    public void setTitle(final String string) {
        this.runMapping(new Operator.MapVoidAction("setTitle"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setTitle(string);
            }
        });
    }

    protected static Frame waitFrame(ComponentChooser componentChooser, int n, Timeouts timeouts, TestOut testOut) {
        try {
            FrameWaiter frameWaiter = new FrameWaiter();
            frameWaiter.setTimeouts(timeouts);
            frameWaiter.setOutput(testOut);
            return frameWaiter.waitFrame(new FrameFinder(componentChooser), n);
        }
        catch (InterruptedException interruptedException) {
            testOut.printStackTrace(interruptedException);
            return null;
        }
    }

    public static class FrameByTitleFinder
    implements ComponentChooser {
        String title;
        Operator.StringComparator comparator;

        public FrameByTitleFinder(String string, Operator.StringComparator stringComparator) {
            this.title = string;
            this.comparator = stringComparator;
        }

        public FrameByTitleFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Frame && ((Frame)component).isShowing() && ((Frame)component).getTitle() != null) {
                return this.comparator.equals(((Frame)component).getTitle(), this.title);
            }
            return false;
        }

        public String getDescription() {
            return "Frame with title \"" + this.title + "\"";
        }
    }

    public static class FrameFinder
    extends Operator.Finder {
        public FrameFinder(ComponentChooser componentChooser) {
            super(class$java$awt$Frame == null ? (class$java$awt$Frame = FrameOperator.class$("java.awt.Frame")) : class$java$awt$Frame, componentChooser);
        }

        public FrameFinder() {
            super(class$java$awt$Frame == null ? (class$java$awt$Frame = FrameOperator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
    }
}

