/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.netbeans.jemmy.JemmyException;

public class ImageTool {
    public static BufferedImage getImage(Rectangle rectangle) {
        try {
            return new Robot().createScreenCapture(rectangle);
        }
        catch (AWTException aWTException) {
            throw new JemmyException("Exception during screen capturing", aWTException);
        }
    }

    public static BufferedImage getImage(Component component) {
        return ImageTool.getImage(new Rectangle(component.getLocationOnScreen(), component.getSize()));
    }

    public static BufferedImage getImage() {
        return ImageTool.getImage(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
    }

    public static BufferedImage enlargeImage(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n2 * n, n3 * n, bufferedImage.getType());
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = bufferedImage.getRGB(i, j);
                for (int k = 0; k < n; ++k) {
                    for (int i2 = 0; i2 < n; ++i2) {
                        bufferedImage2.setRGB(i * n + k, j * n + i2, n4);
                    }
                }
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage substractImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return ImageTool.subtractImage(bufferedImage, bufferedImage2);
    }

    public static BufferedImage subtractImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return ImageTool.subtractImage(bufferedImage, bufferedImage2, 0, 0);
    }

    public static BufferedImage substractImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        return ImageTool.subtractImage(bufferedImage, bufferedImage2, n, n2);
    }

    public static BufferedImage subtractImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage2.getWidth();
        int n6 = bufferedImage2.getHeight();
        int n7 = n3 > n + n5 ? n3 : n + n5;
        int n8 = n4 > n2 + n6 ? n4 : n2 + n6;
        BufferedImage bufferedImage3 = new BufferedImage(n7, n8, 1);
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n8; ++j) {
                int n9 = i >= n3 || j >= n4 ? 0 : bufferedImage.getRGB(i, j);
                int n10 = i >= n5 + n || j >= n6 + n2 || i < n || j < n2 ? 0 : bufferedImage2.getRGB(i - n, j - n2);
                bufferedImage3.setRGB(i, j, ImageTool.subtractColors(n9, n10));
            }
        }
        return bufferedImage3;
    }

    private static int subtractColors(int n, int n2) {
        Color color = new Color(n);
        Color color2 = new Color(n2);
        int n3 = ImageTool.subtractColor(color.getRed(), color2.getRed());
        int n4 = ImageTool.subtractColor(color.getGreen(), color2.getGreen());
        int n5 = ImageTool.subtractColor(color.getBlue(), color2.getBlue());
        return new Color(n3, n4, n5).getRGB();
    }

    private static int subtractColor(int n, int n2) {
        if (n >= n2) {
            return n - n2;
        }
        return n - n2 + 255;
    }
}

