/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.trees;

import java.awt.Point;
import javax.swing.text.JTextComponent;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.drivers.TreeDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;

public class JTreeMouseDriver
extends LightSupportiveDriver
implements TreeDriver {
    QueueTool queueTool = new QueueTool();

    public JTreeMouseDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JTreeOperator"});
    }

    public void selectItem(ComponentOperator componentOperator, int n) {
        this.selectItems(componentOperator, new int[]{n});
    }

    public void selectItems(final ComponentOperator componentOperator, int[] nArray) {
        ((JTreeOperator)componentOperator).clearSelection();
        this.checkSupported(componentOperator);
        final MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        JTreeOperator jTreeOperator = (JTreeOperator)componentOperator;
        final Timeout timeout = componentOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout");
        QueueTool queueTool = new QueueTool();
        for (int i = 0; i < nArray.length; ++i) {
            final int n = i;
            JTreeMouseDriver jTreeMouseDriver = this;
            if (!jTreeMouseDriver.queueTool.isDispatchThread()) {
                jTreeOperator.scrollToRow(nArray[i]);
            }
            final Point point = jTreeOperator.getPointToClick(nArray[n]);
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                public Object launch() {
                    mouseDriver.clickMouse(componentOperator, point.x, point.y, 1, Operator.getDefaultMouseButton(), n == 0 ? 0 : 2, timeout);
                    return null;
                }
            });
        }
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0 && !QueueTool.isDispatchThread()) {
            this.queueTool.setOutput(componentOperator.getOutput().createErrorOutput());
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
        }
    }

    public void expandItem(ComponentOperator componentOperator, final int n) {
        this.checkSupported(componentOperator);
        final JTreeOperator jTreeOperator = (JTreeOperator)componentOperator;
        final MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        if (!jTreeOperator.isExpanded(n)) {
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                public Object launch() {
                    Point point = jTreeOperator.getPointToClick(n);
                    mouseDriver.clickMouse(jTreeOperator, point.x, point.y, 2, Operator.getDefaultMouseButton(), 0, jTreeOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                    return null;
                }
            });
        }
    }

    public void collapseItem(ComponentOperator componentOperator, final int n) {
        this.checkSupported(componentOperator);
        final JTreeOperator jTreeOperator = (JTreeOperator)componentOperator;
        final MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        if (jTreeOperator.isExpanded(n)) {
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                public Object launch() {
                    Point point = jTreeOperator.getPointToClick(n);
                    mouseDriver.clickMouse(jTreeOperator, point.x, point.y, 2, Operator.getDefaultMouseButton(), 0, jTreeOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                    return null;
                }
            });
        }
    }

    public void editItem(ComponentOperator componentOperator, int n, Object object, Timeout timeout) {
        JTextComponentOperator jTextComponentOperator = this.startEditingAndReturnEditor(componentOperator, n, timeout);
        TextDriver textDriver = DriverManager.getTextDriver(JTextComponentOperator.class);
        textDriver.clearText(jTextComponentOperator);
        textDriver.typeText(jTextComponentOperator, object.toString(), 0);
        DriverManager.getKeyDriver(componentOperator).pushKey(jTextComponentOperator, 10, 0, componentOperator.getTimeouts().create("ComponentOperator.PushKeyTimeout"));
    }

    public void startEditing(ComponentOperator componentOperator, int n, Timeout timeout) {
        this.startEditingAndReturnEditor(componentOperator, n, timeout);
    }

    private JTextComponentOperator startEditingAndReturnEditor(ComponentOperator componentOperator, final int n, Timeout timeout) {
        this.checkSupported(componentOperator);
        final JTreeOperator jTreeOperator = (JTreeOperator)componentOperator;
        final MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                Point point = jTreeOperator.getPointToClick(n);
                mouseDriver.clickMouse(jTreeOperator, point.x, point.y, 1, Operator.getDefaultMouseButton(), 0, jTreeOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                return null;
            }
        });
        componentOperator.getTimeouts().sleep("JTreeOperator.BeforeEditTimeout");
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                Point point = jTreeOperator.getPointToClick(n);
                mouseDriver.clickMouse(jTreeOperator, point.x, point.y, 1, Operator.getDefaultMouseButton(), 0, jTreeOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                return null;
            }
        });
        jTreeOperator.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", timeout.getValue());
        return new JTextComponentOperator((JTextComponent)jTreeOperator.waitSubComponent(new JTextComponentOperator.JTextComponentFinder()));
    }
}

