/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JScrollBarOperator;

public class JScrollBarDriver
extends AbstractScrollDriver {
    private static final int SMALL_INCREMENT = 1;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private static final int RELATIVE_DRAG_STEP_LENGTH = 20;
    private QueueTool queueTool = new QueueTool();

    public JScrollBarDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JScrollBarOperator"});
    }

    public void scrollToMinimum(ComponentOperator componentOperator, int n) {
        this.startDragging(componentOperator);
        Point point = new Point(0, 0);
        this.drag(componentOperator, point);
        Timeout timeout = componentOperator.getTimeouts().create("Waiter.TimeDelta");
        while (((JScrollBarOperator)componentOperator).getValue() > ((JScrollBarOperator)componentOperator).getMinimum()) {
            timeout.sleep();
        }
        this.drop(componentOperator, point);
    }

    public void scrollToMaximum(ComponentOperator componentOperator, int n) {
        this.startDragging(componentOperator);
        Point point = new Point(componentOperator.getWidth() - 1, componentOperator.getHeight() - 1);
        this.drag(componentOperator, point);
        Timeout timeout = componentOperator.getTimeouts().create("Waiter.TimeDelta");
        while (((JScrollBarOperator)componentOperator).getValue() > ((JScrollBarOperator)componentOperator).getMaximum() - ((JScrollBarOperator)componentOperator).getVisibleAmount()) {
            timeout.sleep();
        }
        this.drop(componentOperator, point);
    }

    protected void step(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        JButtonOperator jButtonOperator = this.findAButton(componentOperator, scrollAdjuster.getScrollDirection());
        DriverManager.getButtonDriver(jButtonOperator).push(jButtonOperator);
    }

    protected void jump(final ComponentOperator componentOperator, final ScrollAdjuster scrollAdjuster) {
        final JButtonOperator jButtonOperator = this.findAButton(componentOperator, -1);
        final JButtonOperator jButtonOperator2 = this.findAButton(componentOperator, 1);
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

            public Object launch() {
                if (scrollAdjuster.getScrollDirection() != 0) {
                    int n;
                    int n2;
                    if (((JScrollBarOperator)componentOperator).getOrientation() == 0) {
                        if (scrollAdjuster.getScrollDirection() == 1) {
                            n2 = jButtonOperator2.getX() - 1;
                        } else if (scrollAdjuster.getScrollDirection() == -1) {
                            n2 = jButtonOperator.getX() + jButtonOperator.getWidth();
                        } else {
                            return null;
                        }
                        n = jButtonOperator.getHeight() / 2;
                    } else if (((JScrollBarOperator)componentOperator).getOrientation() == 1) {
                        if (scrollAdjuster.getScrollDirection() == 1) {
                            n = jButtonOperator2.getY() - 1;
                        } else if (scrollAdjuster.getScrollDirection() == -1) {
                            n = jButtonOperator.getY() + jButtonOperator.getHeight();
                        } else {
                            return null;
                        }
                        n2 = jButtonOperator.getWidth() / 2;
                    } else {
                        return null;
                    }
                    1 v0 = this;
                    DriverManager.getMouseDriver(componentOperator).clickMouse(componentOperator, n2, n, 1, v0.componentOperator.getDefaultMouseButton(), 0, new Timeout("", 0L));
                }
                return null;
            }
        });
    }

    protected void startPushAndWait(ComponentOperator componentOperator, int n, int n2) {
        JButtonOperator jButtonOperator = this.findAButton(componentOperator, n);
        DriverManager.getButtonDriver(jButtonOperator).press(jButtonOperator);
    }

    protected void stopPushAndWait(ComponentOperator componentOperator, int n, int n2) {
        JButtonOperator jButtonOperator = this.findAButton(componentOperator, n);
        DriverManager.getButtonDriver(jButtonOperator).release(jButtonOperator);
    }

    protected Point startDragging(ComponentOperator componentOperator) {
        JButtonOperator jButtonOperator = this.findAButton(componentOperator, -1);
        JButtonOperator jButtonOperator2 = this.findAButton(componentOperator, 1);
        Point point = this.getClickPoint((JScrollBarOperator)componentOperator, jButtonOperator, jButtonOperator2, ((JScrollBarOperator)componentOperator).getValue());
        MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        mouseDriver.moveMouse(componentOperator, point.x, point.y);
        mouseDriver.pressMouse(componentOperator, point.x, point.y, componentOperator.getDefaultMouseButton(), 0);
        return point;
    }

    protected void drop(ComponentOperator componentOperator, Point point) {
        DriverManager.getMouseDriver(componentOperator).releaseMouse(componentOperator, point.x, point.y, componentOperator.getDefaultMouseButton(), 0);
    }

    protected void drag(ComponentOperator componentOperator, Point point) {
        DriverManager.getMouseDriver(componentOperator).dragMouse(componentOperator, point.x, point.y, componentOperator.getDefaultMouseButton(), 0);
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator componentOperator) {
        return componentOperator.getTimeouts().create("ScrollbarOperator.DragAndDropScrollingDelta");
    }

    protected boolean canDragAndDrop(ComponentOperator componentOperator) {
        if (!this.isSmallIncrement((JScrollBarOperator)componentOperator)) {
            return false;
        }
        boolean bl = false;
        MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        JButtonOperator jButtonOperator = this.findAButton(componentOperator, -1);
        JButtonOperator jButtonOperator2 = this.findAButton(componentOperator, 1);
        Point point = this.getClickPoint((JScrollBarOperator)componentOperator, jButtonOperator, jButtonOperator2, ((JScrollBarOperator)componentOperator).getValue());
        mouseDriver.moveMouse(componentOperator, point.x, point.y);
        mouseDriver.pressMouse(componentOperator, point.x, point.y, componentOperator.getDefaultMouseButton(), 0);
        bl = ((JScrollBarOperator)componentOperator).getValueIsAdjusting();
        mouseDriver.releaseMouse(componentOperator, point.x, point.y, componentOperator.getDefaultMouseButton(), 0);
        return bl && this.isSmallIncrement((JScrollBarOperator)componentOperator);
    }

    protected boolean canJump(ComponentOperator componentOperator) {
        return this.isSmallIncrement((JScrollBarOperator)componentOperator);
    }

    protected boolean canPushAndWait(ComponentOperator componentOperator) {
        return this.isSmallIncrement((JScrollBarOperator)componentOperator);
    }

    protected int getDragAndDropStepLength(ComponentOperator componentOperator) {
        int n;
        int n2;
        JButtonOperator jButtonOperator = this.findAButton(componentOperator, -1);
        JButtonOperator jButtonOperator2 = this.findAButton(componentOperator, 1);
        int n3 = componentOperator.getWidth() - jButtonOperator.getWidth() - jButtonOperator2.getWidth();
        int n4 = n2 = n3 > (n = componentOperator.getHeight() - jButtonOperator.getHeight() - jButtonOperator2.getHeight()) ? n3 : n;
        if (n2 >= 40) {
            return n2 / 20;
        }
        return 1;
    }

    private boolean isSmallIncrement(JScrollBarOperator jScrollBarOperator) {
        return jScrollBarOperator.getUnitIncrement(-1) <= 1 && jScrollBarOperator.getUnitIncrement(1) <= 1;
    }

    private Point getClickPoint(JScrollBarOperator jScrollBarOperator, JButtonOperator jButtonOperator, JButtonOperator jButtonOperator2, int n) {
        int n2 = jScrollBarOperator.getOrientation() == 0 ? jScrollBarOperator.getWidth() - jButtonOperator.getWidth() - jButtonOperator2.getWidth() : jScrollBarOperator.getHeight() - jButtonOperator.getHeight() - jButtonOperator2.getHeight();
        int n3 = (int)((float)n2 / (float)(jScrollBarOperator.getMaximum() - jScrollBarOperator.getMinimum()) * (float)n);
        n3 = jScrollBarOperator.getOrientation() == 0 ? (n3 += jButtonOperator.getWidth()) : (n3 += jButtonOperator.getHeight());
        n3 = n3 + 2 + 1;
        return jScrollBarOperator.getOrientation() == 0 ? new Point(n3, jScrollBarOperator.getHeight() / 2) : new Point(jScrollBarOperator.getWidth() / 2, n3);
    }

    private JButtonOperator findAButton(ComponentOperator componentOperator, int n) {
        return n == -1 ? ((JScrollBarOperator)componentOperator).getDecreaseButton() : ((JScrollBarOperator)componentOperator).getIncreaseButton();
    }
}

