/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;

public class WindowWaiter
extends Waiter
implements Timeoutable {
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private ComponentChooser chooser;
    private Window owner = null;
    private int index = 0;
    private Timeouts timeouts;

    public WindowWaiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static Window getWindow(Window window, ComponentChooser componentChooser, int n) {
        return WindowWaiter.getAWindow(window, new IndexChooser(componentChooser, n));
    }

    public static Window getWindow(Window window, ComponentChooser componentChooser) {
        return WindowWaiter.getWindow(window, componentChooser, 0);
    }

    public static Window getWindow(ComponentChooser componentChooser, int n) {
        return WindowWaiter.getAWindow(new IndexChooser(componentChooser, n));
    }

    public static Window getWindow(ComponentChooser componentChooser) {
        return WindowWaiter.getWindow(componentChooser, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts timeouts2 = timeouts.cloneThis();
        timeouts2.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("WindowWaiter.WaitWindowTimeout"));
        timeouts2.setTimeout("Waiter.AfterWaitingTime", timeouts.getTimeout("WindowWaiter.AfterWindowTimeout"));
        super.setTimeouts(timeouts2);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public Object actionProduced(Object object) {
        return WindowWaiter.getWindow(this.owner, this.chooser, this.index);
    }

    public Window waitWindow(ComponentChooser componentChooser, int n) throws InterruptedException {
        this.chooser = componentChooser;
        this.owner = null;
        this.index = n;
        return this.waitWindow();
    }

    public Window waitWindow(ComponentChooser componentChooser) throws InterruptedException {
        return this.waitWindow(componentChooser, 0);
    }

    public Window waitWindow(Window window, ComponentChooser componentChooser, int n) throws InterruptedException {
        this.owner = window;
        this.chooser = componentChooser;
        this.index = n;
        return (Window)this.waitAction(null);
    }

    public Window waitWindow(Window window, ComponentChooser componentChooser) throws InterruptedException {
        return this.waitWindow(window, componentChooser, 0);
    }

    public String getDescription() {
        return this.chooser.getDescription();
    }

    protected void setComponentChooser(ComponentChooser componentChooser) {
        this.chooser = componentChooser;
    }

    protected ComponentChooser getComponentChooser() {
        return this.chooser;
    }

    protected void setOwner(Window window) {
        this.owner = window;
    }

    protected Window getOwner() {
        return this.owner;
    }

    protected String getWaitingStartedMessage() {
        return "Start to wait window \"" + this.chooser.getDescription() + "\" opened";
    }

    protected String getTimeoutExpiredMessage(long l) {
        return "Window \"" + this.chooser.getDescription() + "\" has not been opened in " + new Long(l).toString() + " milliseconds";
    }

    protected String getActionProducedMessage(long l, final Object object) {
        String string = object instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            public Object launch() {
                return object.toString();
            }
        }) : object.toString();
        return "Window \"" + this.chooser.getDescription() + "\" has been opened in " + new Long(l).toString() + " milliseconds" + "\n    " + string;
    }

    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait window \"" + this.chooser.getDescription() + "\" opened";
    }

    protected String getGoldenTimeoutExpiredMessage() {
        return "Window \"" + this.chooser.getDescription() + "\" has not been opened";
    }

    protected String getGoldenActionProducedMessage() {
        return "Window \"" + this.chooser.getDescription() + "\" has been opened";
    }

    private static Window getAWindow(Window window, ComponentChooser componentChooser) {
        if (window == null) {
            return WindowWaiter.getAWindow(componentChooser);
        }
        Window window2 = null;
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (componentChooser.checkComponent(windowArray[i])) {
                return windowArray[i];
            }
            window2 = WindowWaiter.getWindow(windowArray[i], componentChooser);
            if (window2 == null) continue;
            return window2;
        }
        return null;
    }

    private static Window getAWindow(ComponentChooser componentChooser) {
        Window window = null;
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (componentChooser.checkComponent(frameArray[i])) {
                return frameArray[i];
            }
            window = WindowWaiter.getWindow(frameArray[i], componentChooser);
            if (window == null) continue;
            return window;
        }
        return null;
    }

    private Window waitWindow() throws InterruptedException {
        return (Window)this.waitAction(null);
    }

    private Window waitWindow(Window window) throws InterruptedException {
        this.owner = window;
        return (Window)this.waitAction(null);
    }

    static {
        Timeouts.initDefault("WindowWaiter.WaitWindowTimeout", 60000L);
        Timeouts.initDefault("WindowWaiter.AfterWindowTimeout", 0L);
    }

    private static class IndexChooser
    implements ComponentChooser {
        private int curIndex = 0;
        private int index;
        private ComponentChooser chooser;

        public IndexChooser(ComponentChooser componentChooser, int n) {
            this.index = n;
            this.chooser = componentChooser;
            this.curIndex = 0;
        }

        public boolean checkComponent(Component component) {
            if (component.isShowing() && component.isVisible() && this.chooser.checkComponent(component)) {
                if (this.curIndex == this.index) {
                    return true;
                }
                ++this.curIndex;
            }
            return false;
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }
}

