/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TestOut {
    private InputStream input;
    private PrintWriter output;
    private PrintWriter errput;
    private PrintWriter golden_output;
    private BufferedReader buffInput;
    private boolean autoFlushMode = true;

    public TestOut(InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        this(inputStream, printStream, printStream2, null);
    }

    public TestOut(InputStream inputStream, PrintStream printStream, PrintStream printStream2, PrintStream printStream3) {
        PrintWriter printWriter = null;
        if (printStream != null) {
            printWriter = new PrintWriter(printStream);
        }
        PrintWriter printWriter2 = null;
        if (printStream2 != null) {
            printWriter2 = new PrintWriter(printStream2);
        }
        PrintWriter printWriter3 = null;
        if (printStream3 != null) {
            printWriter3 = new PrintWriter(printStream3);
        }
        this.initStreams(inputStream, printWriter, printWriter2, printWriter3);
    }

    public TestOut(InputStream inputStream, PrintWriter printWriter, PrintWriter printWriter2) {
        this(inputStream, printWriter, printWriter2, null);
    }

    public TestOut(InputStream inputStream, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        this.initStreams(inputStream, printWriter, printWriter2, printWriter3);
        this.autoFlushMode = true;
    }

    public TestOut() {
        this(System.in, new PrintWriter(System.out), new PrintWriter(System.err), null);
    }

    public static TestOut getNullOutput() {
        return new TestOut((InputStream)null, (PrintWriter)null, (PrintWriter)null);
    }

    public boolean setAutoFlushMode(boolean bl) {
        boolean bl2 = this.getAutoFlushMode();
        this.autoFlushMode = bl;
        return bl2;
    }

    public boolean getAutoFlushMode() {
        return this.autoFlushMode;
    }

    public int read() throws IOException {
        if (this.input != null) {
            return this.input.read();
        }
        return -1;
    }

    public String readLine() throws IOException {
        if (this.buffInput != null) {
            return this.buffInput.readLine();
        }
        return null;
    }

    public void print(String string) {
        if (this.output != null) {
            this.output.print(string);
        }
    }

    public void printLine(String string) {
        if (this.output != null) {
            this.output.println(string);
            if (this.autoFlushMode) {
                this.output.flush();
            }
        }
    }

    public void printGolden(String string) {
        if (this.golden_output != null) {
            this.golden_output.println(string);
            if (this.autoFlushMode) {
                this.golden_output.flush();
            }
        }
    }

    public void printErrLine(String string) {
        if (this.errput != null) {
            this.errput.println(string);
            if (this.autoFlushMode) {
                this.errput.flush();
            }
        }
    }

    public void printLine(boolean bl, String string) {
        if (bl) {
            this.printLine(string);
        } else {
            this.printErrLine(string);
        }
    }

    public void printTrace(String string) {
        this.printLine("Trace:");
        this.printLine(string);
    }

    public void printError(String string) {
        this.printErrLine("Error:");
        this.printErrLine(string);
    }

    public void printStackTrace(Throwable throwable) {
        if (this.errput != null) {
            throwable.printStackTrace(this.errput);
            if (this.autoFlushMode) {
                this.errput.flush();
            }
        }
    }

    public InputStream getInput() {
        return this.input;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public PrintWriter getErrput() {
        return this.errput;
    }

    public PrintWriter getGolden() {
        return this.golden_output;
    }

    public TestOut createErrorOutput() {
        return new TestOut(null, null, this.getErrput());
    }

    public void flush() {
        if (this.output != null) {
            this.output.flush();
        }
        if (this.errput != null) {
            this.errput.flush();
        }
        if (this.golden_output != null) {
            this.golden_output.flush();
        }
    }

    private void initStreams(InputStream inputStream, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        this.input = inputStream;
        this.output = printWriter;
        this.errput = printWriter2;
        this.golden_output = printWriter3;
        this.buffInput = this.input != null ? new BufferedReader(new InputStreamReader(inputStream)) : null;
    }
}

