/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.util.Lookup;

class LogFormatter
extends XMLFormatter {
    private String javaHome = this.convert(System.getProperty("java.home", ""));
    private String userHome = this.convert(System.getProperty("user.home", ""));
    private String netbeansUserDir = this.convert(System.getProperty("netbeans.user", ""));
    private String netbeansHome = this.convert(System.getProperty("netbeans.home", ""));
    private List<String> installDirs;

    public LogFormatter() {
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.convert(stringArray[i]);
            }
            this.installDirs = Arrays.asList(stringArray);
        } else {
            this.installDirs = Collections.emptyList();
        }
    }

    private String convert(String string) {
        try {
            return new File(string).toURI().toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.INFO, "unaccessible file", malformedURLException);
            return "";
        }
    }

    private void a2(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c < ' ' && c != '\t' && c != '\r' && c != '\n') {
                stringBuffer.append('^').append((char)(c + 64));
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private void printFrame(StackTraceElement stackTraceElement, StringBuffer stringBuffer) {
        stringBuffer.append("    <frame>\n");
        stringBuffer.append("      <class>");
        this.escape(stringBuffer, stackTraceElement.getClassName());
        stringBuffer.append("</class>\n");
        stringBuffer.append("      <method>");
        this.escape(stringBuffer, stackTraceElement.getMethodName());
        stringBuffer.append("</method>\n");
        if (stackTraceElement.getLineNumber() >= 0) {
            stringBuffer.append("      <line>");
            stringBuffer.append(stackTraceElement.getLineNumber());
            stringBuffer.append("</line>\n");
        }
        stringBuffer.append("      <file>");
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Class<?> clazz = null;
        URL uRL = null;
        String string = null;
        try {
            clazz = classLoader.loadClass(stackTraceElement.getClassName());
        }
        catch (Throwable throwable) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.FINE, "Class loading error", throwable);
        }
        if (clazz != null) {
            String[] stringArray = clazz.getName().split("\\.");
            if (stringArray.length > 0) {
                uRL = clazz.getResource(stringArray[stringArray.length - 1] + ".class");
            }
            if (uRL != null) {
                string = uRL.toString();
                int n = string.indexOf("!");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                string = string.replace("jar:", "");
                if (this.javaHome.length() > 0) {
                    string = string.replace(this.javaHome, "${java.home}");
                }
                if (this.netbeansHome.length() > 0) {
                    string = string.replace(this.netbeansHome, "${netbeans.home}");
                }
                if (this.netbeansUserDir.length() > 0) {
                    string = string.replace(this.netbeansUserDir, "${user.dir}");
                }
                for (String string2 : this.installDirs) {
                    string = string.replace(string2, "${netBeansDir}");
                }
                if (this.userHome.length() > 0) {
                    string = string.replace(this.userHome, "${user.home}");
                }
                string = string.replace("file:", "");
                string = string.replace("nbjcl:", "");
                this.escape(stringBuffer, string);
            }
        }
        stringBuffer.append("</file>\n");
        stringBuffer.append("    </frame>\n");
    }

    private void printCause(Throwable throwable, StringBuffer stringBuffer, StackTraceElement[] stackTraceElementArray) {
        stringBuffer.append("  <exception>\n");
        stringBuffer.append("   <message>");
        this.escape(stringBuffer, throwable.toString());
        stringBuffer.append("</message>\n");
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        for (int i = 0; i <= n; ++i) {
            this.printFrame(stackTraceElementArray2[i], stringBuffer);
        }
        stringBuffer.append("   <more>");
        stringBuffer.append(n2);
        stringBuffer.append("</more>\n");
        stringBuffer.append("  </exception>\n");
        if (throwable.getCause() != null) {
            this.printCause(throwable.getCause(), stringBuffer, stackTraceElementArray2);
        }
    }

    private void printThrown(Throwable throwable, StringBuffer stringBuffer) {
        stringBuffer.append("  <exception>\n");
        stringBuffer.append("    <message>");
        this.escape(stringBuffer, throwable.toString());
        stringBuffer.append("</message>\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            this.printFrame(stackTraceElementArray[i], stringBuffer);
        }
        stringBuffer.append("  </exception>\n");
        if (throwable.getCause() != null) {
            this.printCause(throwable.getCause(), stringBuffer, stackTraceElementArray);
        }
    }

    private void appendISO8601(StringBuffer stringBuffer, long l) {
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append('-');
        this.a2(stringBuffer, gregorianCalendar.get(2) + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, gregorianCalendar.get(5));
        stringBuffer.append('T');
        this.a2(stringBuffer, gregorianCalendar.get(11));
        stringBuffer.append(':');
        this.a2(stringBuffer, gregorianCalendar.get(12));
        stringBuffer.append(':');
        this.a2(stringBuffer, gregorianCalendar.get(13));
    }

    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<record>\n");
        stringBuffer.append("  <date>");
        this.appendISO8601(stringBuffer, logRecord.getMillis());
        stringBuffer.append("</date>\n");
        stringBuffer.append("  <millis>");
        stringBuffer.append(logRecord.getMillis());
        stringBuffer.append("</millis>\n");
        stringBuffer.append("  <sequence>");
        stringBuffer.append(logRecord.getSequenceNumber());
        stringBuffer.append("</sequence>\n");
        String string = logRecord.getLoggerName();
        if (string != null) {
            stringBuffer.append("  <logger>");
            this.escape(stringBuffer, string);
            stringBuffer.append("</logger>\n");
        }
        stringBuffer.append("  <level>");
        this.escape(stringBuffer, logRecord.getLevel().toString());
        stringBuffer.append("</level>\n");
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append("  <class>");
            this.escape(stringBuffer, logRecord.getSourceClassName());
            stringBuffer.append("</class>\n");
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append("  <method>");
            this.escape(stringBuffer, logRecord.getSourceMethodName());
            stringBuffer.append("</method>\n");
        }
        stringBuffer.append("  <thread>");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append("</thread>\n");
        if (logRecord.getMessage() != null) {
            stringBuffer.append("  <message>");
            this.escape(stringBuffer, logRecord.getMessage());
            stringBuffer.append("</message>\n");
        }
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        try {
            if (resourceBundle != null && resourceBundle.getString(logRecord.getMessage()) != null) {
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, logRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, logRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
            }
        }
        catch (Exception exception) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.FINE, "Catalog loading error", exception);
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null && objectArray.length != 0 && logRecord.getMessage().indexOf("{") == -1) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("  <param>");
                try {
                    this.escape(stringBuffer, LogFormatter.paramToString(objectArray[i]));
                }
                catch (Exception exception) {
                    stringBuffer.append("???");
                }
                stringBuffer.append("</param>\n");
            }
        }
        if (logRecord.getThrown() != null) {
            this.printThrown(logRecord.getThrown(), stringBuffer);
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }

    private static String paramToString(Object object) {
        Object object2;
        Action action;
        if (object == null) {
            return "null";
        }
        if (object instanceof JMenuItem && (action = ((AbstractButton)(object2 = (JMenuItem)object)).getAction()) != null) {
            return object2.getClass().getName() + '[' + LogFormatter.paramToString(action) + ']';
        }
        if (object instanceof AbstractButton) {
            object2 = (AbstractButton)object;
            return object2.getClass().getName() + '[' + ((AbstractButton)object2).getText() + ']';
        }
        if (object instanceof Action) {
            object2 = (Action)object;
            if (object2.getClass().getName().endsWith("$DelegateAction") && object2.getClass().getName().startsWith("org.openide")) {
                return object2.toString().replaceAll("@[0-9a-fA-F]*", "," + object2.getValue("Name"));
            }
            return object2.getClass().getName() + '[' + object2.getValue("Name") + ']';
        }
        if (object instanceof Component) {
            object2 = (Component)object;
            return object2.getClass().getName() + '[' + ((Component)object2).getName() + ']';
        }
        return object.toString();
    }
}

