/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.SQLStatementExecutor;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SQLExecutionHelper {
    private final DataView dataView;
    private final DatabaseConnection dbConn;
    private static Logger mLogger = Logger.getLogger(SQLExecutionHelper.class.getName());
    private final RequestProcessor rp = new RequestProcessor("SQLStatementExecution", 1, true);

    SQLExecutionHelper(DataView dataView, DatabaseConnection databaseConnection) {
        this.dataView = dataView;
        this.dbConn = databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void initialDataLoad(DataView dataView, DatabaseConnection databaseConnection, SQLExecutionHelper sQLExecutionHelper) throws SQLException {
        Object object;
        Statement statement;
        block18: {
            boolean bl;
            String string;
            block17: {
                ResultSet resultSet;
                DBMetaDataFactory dBMetaDataFactory;
                block15: {
                    block16: {
                        Connection connection;
                        block13: {
                            block14: {
                                statement = null;
                                try {
                                    connection = DBConnectionFactory.getInstance().getConnection(databaseConnection);
                                    dBMetaDataFactory = new DBMetaDataFactory(connection);
                                    dataView.setLimitSupported(dBMetaDataFactory.supportsLimit());
                                    string = dataView.getSQLString();
                                    bl = sQLExecutionHelper.isSelectStatement(string);
                                    statement = sQLExecutionHelper.prepareSQLStatement(connection, string);
                                    sQLExecutionHelper.executeSQLStatement(statement, string);
                                    if (dataView.getUpdateCount() == -1) break block13;
                                    if (connection.getAutoCommit()) break block14;
                                    connection.commit();
                                }
                                catch (Throwable throwable) {
                                    DataViewUtils.closeResources(statement);
                                    throw throwable;
                                }
                            }
                            DataViewUtils.closeResources(statement);
                            return;
                        }
                        resultSet = null;
                        resultSet = statement.getResultSet();
                        if (resultSet != null) break block15;
                        if (connection.getAutoCommit()) break block16;
                        connection.commit();
                    }
                    DataViewUtils.closeResources(resultSet);
                    DataViewUtils.closeResources(statement);
                    return;
                }
                object = dBMetaDataFactory.generateDBTables(resultSet, string, bl);
                DataViewDBTable dataViewDBTable = new DataViewDBTable((Collection<DBTable>)object);
                dataView.setDataViewDBTable(dataViewDBTable);
                sQLExecutionHelper.loadDataFrom(resultSet);
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    DataViewUtils.closeResources(resultSet);
                }
            }
            object = null;
            try {
                if (bl) {
                    object = statement.executeQuery(SQLStatementGenerator.getCountSQLQuery(string));
                    sQLExecutionHelper.setTotalCount((ResultSet)object);
                    break block18;
                }
                sQLExecutionHelper.setTotalCount(null);
            }
            catch (SQLException sQLException) {
                try {
                    sQLExecutionHelper.setTotalCount(null);
                }
                catch (Throwable throwable) {
                    DataViewUtils.closeResources(object);
                    throw throwable;
                }
                DataViewUtils.closeResources((ResultSet)object);
            }
        }
        DataViewUtils.closeResources(object);
        DataViewUtils.closeResources(statement);
    }

    void executeInsertRow(final String[] stringArray, final Object[] objectArray) {
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_insert"), ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                PreparedStatement preparedStatement = this.conn.prepareStatement(stringArray[0]);
                try {
                    int n;
                    int n2 = 1;
                    for (n = 0; n < objectArray.length; ++n) {
                        if (objectArray[n] == null) continue;
                        DBReadWriteHelper.setAttributeValue(preparedStatement, n2++, this.dataView.getDataViewDBTable().getColumnType(n), objectArray[n]);
                    }
                    SQLExecutionHelper.this.executeSQLStatement(preparedStatement, stringArray[1]);
                    n = this.dataView.getUpdateCount();
                    if (n != 1) {
                        this.error = true;
                        this.errorMsg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_failure_insert_rows");
                    }
                }
                finally {
                    DataViewUtils.closeResources(preparedStatement);
                }
            }

            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_insert_command"));
            }

            protected void executeOnSucess() {
                if (this.dataView.getDataViewPageContext().getTotalRows() < 0) {
                    this.dataView.getDataViewPageContext().setTotalRows(0);
                    this.dataView.getDataViewPageContext().first();
                }
                this.dataView.incrementRowSize(1);
                if (this.dataView.getDataViewPageContext().refreshRequiredOnInsert()) {
                    SQLExecutionHelper.this.executeQuery();
                } else {
                    this.reinstateToolbar();
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeDeleteRow(final DataViewTableUI dataViewTableUI) {
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_delete"), ""){

            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                int[] nArray = dataViewTableUI.getSelectedRows();
                for (int i = 0; i < nArray.length && !this.error && !Thread.currentThread().isInterrupted(); ++i) {
                    this.deleteARow(nArray[i], dataViewTableUI.getModel());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void deleteARow(int n, TableModel tableModel) throws SQLException, DBException {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
                String[] stringArray = sQLStatementGenerator.generateDeleteStatement(arrayList2, arrayList, n, tableModel);
                PreparedStatement preparedStatement = this.conn.prepareStatement(stringArray[0]);
                try {
                    int n2 = 1;
                    for (Object e : arrayList) {
                        DBReadWriteHelper.setAttributeValue(preparedStatement, n2, (Integer)arrayList2.get(n2 - 1), e);
                        ++n2;
                    }
                    SQLExecutionHelper.this.executeSQLStatement(preparedStatement, stringArray[1]);
                    int n3 = this.dataView.getUpdateCount();
                    if (n3 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_delete");
                    } else if (n3 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(preparedStatement);
                }
            }

            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_delete_command"));
            }

            protected void executeOnSucess() {
                this.dataView.decrementRowSize(dataViewTableUI.getSelectedRows().length);
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeUpdateRow(final DataViewTableUI dataViewTableUI, final boolean bl) {
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_update"), ""){
            private PreparedStatement pstmt;
            Set<String> keysToRemove;
            {
                super(dataView, string, string2);
                this.keysToRemove = new HashSet<String>();
            }

            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                if (bl) {
                    this.updateSelected();
                } else {
                    for (String string : this.dataView.getUpdatedRowContext().getUpdateKeys()) {
                        if (Thread.currentThread().isInterrupted()) break;
                        this.updateARow(string);
                        this.keysToRemove.add(string);
                    }
                }
            }

            private void updateSelected() throws SQLException, DBException {
                int[] nArray = dataViewTableUI.getSelectedRows();
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                block0: for (int i = 0; i < nArray.length && !this.error; ++i) {
                    Set<String> set = updatedRowContext.getUpdateKeys();
                    for (String string : set) {
                        if (Thread.currentThread().isInterrupted()) continue block0;
                        if (!string.startsWith(nArray[i] + 1 + ";")) continue;
                        this.updateARow(string);
                        this.keysToRemove.add(string);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateARow(String string) throws SQLException, DBException {
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                String string2 = updatedRowContext.getUpdateStmt(string);
                String string3 = updatedRowContext.getRawUpdateStmt(string);
                List<Object> list = updatedRowContext.getValueList(string);
                List<Integer> list2 = updatedRowContext.getTypeList(string);
                this.pstmt = this.conn.prepareStatement(string2);
                int n = 1;
                for (Object object : list) {
                    DBReadWriteHelper.setAttributeValue(this.pstmt, n, list2.get(n - 1), object);
                    ++n;
                }
                try {
                    SQLExecutionHelper.this.executeSQLStatement(this.pstmt, string3);
                    int n2 = this.dataView.getUpdateCount();
                    if (n2 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_delete");
                    } else if (n2 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(this.pstmt);
                }
            }

            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_update_command"));
            }

            protected void executeOnSucess() {
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                for (String string : this.keysToRemove) {
                    updatedRowContext.removeUpdateStmt(string);
                }
                this.dataView.syncPageWithTableModel();
                this.reinstateToolbar();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeTruncate() {
        String string = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_truncate_table_progress");
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_truncate"), string){
            private Statement stmt;
            {
                this.stmt = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws SQLException, DBException {
                this.stmt = this.conn.createStatement();
                DBTable dBTable = this.dataView.getDataViewDBTable().geTable(0);
                String string = "TRUNCATE TABLE" + dBTable.getFullyQualifiedName();
                try {
                    SQLExecutionHelper.this.executeSQLStatement(this.stmt, string);
                }
                catch (SQLException sQLException) {
                    mLogger.log(Level.FINE, "TRUNCATE Not supported...will try DELETE * \n");
                    string = "DELETE FROM " + dBTable.getFullyQualifiedName();
                    SQLExecutionHelper.this.executeSQLStatement(this.stmt, string);
                }
                finally {
                    DataViewUtils.closeResources(this.stmt);
                }
            }

            public void finished() {
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_truncate_command"));
            }

            protected void executeOnSucess() {
                this.dataView.getDataViewPageContext().setTotalRows(0);
                this.dataView.getDataViewPageContext().first();
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeQuery() {
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executequery"), this.dataView.getSQLString()){
            private ResultSet rs;
            private ResultSet crs;
            private Statement stmt;
            boolean lastEditState;
            {
                this.rs = null;
                this.crs = null;
                this.stmt = null;
                this.lastEditState = this.dataView.isEditable();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws SQLException, DBException {
                String string;
                block12: {
                    this.dataView.setEditable(false);
                    string = this.dataView.getSQLString();
                    this.stmt = SQLExecutionHelper.this.prepareSQLStatement(this.conn, string);
                    try {
                        SQLExecutionHelper.this.executeSQLStatement(this.stmt, string);
                        if (this.dataView.hasResultSet()) {
                            this.rs = this.stmt.getResultSet();
                            SQLExecutionHelper.this.loadDataFrom(this.rs);
                            break block12;
                        }
                        return;
                    }
                    finally {
                        DataViewUtils.closeResources(this.rs);
                    }
                }
                if (this.dataView.getDataViewPageContext().getTotalRows() == -1) {
                    try {
                        if (SQLExecutionHelper.this.isSelectStatement(string)) {
                            this.crs = this.stmt.executeQuery(SQLStatementGenerator.getCountSQLQuery(string));
                            SQLExecutionHelper.this.setTotalCount(this.crs);
                        } else {
                            SQLExecutionHelper.this.setTotalCount(null);
                        }
                    }
                    catch (SQLException sQLException) {
                        SQLExecutionHelper.this.setTotalCount(null);
                    }
                    finally {
                        DataViewUtils.closeResources(this.crs);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                DataViewUtils.closeResources(this.stmt);
                this.dataView.setEditable(this.lastEditState);
                DataView dataView = this.dataView;
                synchronized (dataView) {
                    if (this.error) {
                        this.dataView.setErrorStatusText(this.ex);
                    }
                    this.dataView.getUpdatedRowContext().resetUpdateState();
                    this.dataView.resetToolbar(this.error);
                    this.dataView.setRowsInTableModel();
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void loadDataFrom(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return;
        }
        int n = this.dataView.getDataViewPageContext().getPageSize();
        int n2 = 0;
        if (!this.dataView.isLimitSupported()) {
            n2 = this.dataView.getDataViewPageContext().getCurrentPos() - 1;
        }
        DataViewDBTable dataViewDBTable = this.dataView.getDataViewDBTable();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n3 = dataViewDBTable.getColumnCount();
        try {
            boolean bl = resultSet.next();
            for (int i = 1; bl && i < n2 + 1; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                bl = resultSet.next();
            }
            for (int i = 0; (n == -1 || n > i) && (bl || resultSet.next()); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Object[] objectArray = new Object[n3];
                for (int j = 0; j < n3; ++j) {
                    int n4 = dataViewDBTable.getColumn(j).getJdbcType();
                    objectArray[j] = DBReadWriteHelper.readResultSet(resultSet, n4, j + 1);
                }
                arrayList.add(objectArray);
                if (!bl) continue;
                bl = false;
            }
        }
        catch (SQLException sQLException) {
            mLogger.log(Level.SEVERE, "Failed to set up table model" + sQLException);
            throw sQLException;
        }
        finally {
            this.dataView.getDataViewPageContext().setCurrentRows(arrayList);
        }
    }

    void setTotalCount(ResultSet resultSet) {
        try {
            if (resultSet == null) {
                this.dataView.getDataViewPageContext().setTotalRows(-1);
            } else if (resultSet.next()) {
                int n = resultSet.getInt(1);
                this.dataView.getDataViewPageContext().setTotalRows(n);
            }
        }
        catch (SQLException sQLException) {
            mLogger.log(Level.SEVERE, "Could not get total row count " + sQLException);
        }
    }

    private Statement prepareSQLStatement(Connection connection, String string) throws SQLException {
        Statement statement = null;
        boolean bl = false;
        if (string.startsWith("{")) {
            statement = connection.prepareCall(string);
        } else if (this.isSelectStatement(string)) {
            statement = connection.createStatement(1003, 1007);
            bl = true;
        } else {
            statement = connection.createStatement();
        }
        int n = this.dataView.getDataViewPageContext().getPageSize();
        statement.setFetchSize(n);
        if (this.dataView.isLimitSupported() && bl) {
            statement.setMaxRows(n);
        } else {
            statement.setMaxRows(this.dataView.getDataViewPageContext().getCurrentPos() + n);
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQLStatement(Statement statement, String string) throws SQLException {
        string = string.replaceAll("\\n", " ").replaceAll("\\t", " ");
        if (this.dataView.isLimitSupported() && this.isSelectStatement(string) && string.toUpperCase().indexOf("LIMIT") == -1) {
            string = string + " LIMIT " + this.dataView.getDataViewPageContext().getPageSize();
            string = string + " OFFSET " + (this.dataView.getDataViewPageContext().getCurrentPos() - 1);
        }
        mLogger.log(Level.FINE, "Executing Statement: " + string);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executestmt") + string);
        long l = System.currentTimeMillis();
        boolean bl = statement instanceof PreparedStatement ? ((PreparedStatement)statement).execute() : statement.execute(string);
        long l2 = System.currentTimeMillis() - l;
        String string2 = this.millisecondsToSeconds(l2);
        mLogger.log(Level.FINE, "Executed Successfully in" + string2 + " seconds");
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_execution_success", (Object)string2));
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setHasResultSet(bl);
            this.dataView.setUpdateCount(statement.getUpdateCount());
            this.dataView.setExecutionTime(l2);
        }
    }

    private boolean isSelectStatement(String string) {
        return string.trim().toUpperCase().startsWith("SELECT");
    }

    private String millisecondsToSeconds(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        return numberFormat.format((double)l / 1000.0);
    }
}

