/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableSorter;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataViewTablePanel
extends JPanel {
    private final DataViewDBTable tblMeta;
    private final UpdatedRowContext tblContext;
    private final DataViewUI dataViewUI;
    private final DataViewTableUI tableUI;
    private final SQLStatementGenerator stmtGenerator;
    private boolean isEditable = true;
    private boolean isDirty = false;
    private int MAX_COLUMN_WIDTH = 40;
    private TableModel model;
    private final List<Integer> columnWidthList;
    private static Logger mLogger = Logger.getLogger(DataViewTablePanel.class.getName());

    public DataViewTablePanel(DataView dataView, DataViewUI dataViewUI, DataViewActionHandler dataViewActionHandler) {
        this.tblMeta = dataView.getDataViewDBTable();
        this.dataViewUI = dataViewUI;
        this.setLayout(new BorderLayout());
        this.tableUI = new DataViewTableUI(this, dataViewActionHandler, dataView);
        this.tableUI.setColumnToolTips(this.tblMeta.getColumnToolTips());
        JScrollPane jScrollPane = new JScrollPane(this.tableUI);
        this.add((Component)jScrollPane, "Center");
        this.stmtGenerator = dataView.getSQLStatementGenerator();
        this.tblContext = new UpdatedRowContext(this.stmtGenerator);
        this.columnWidthList = this.getColumnWidthList();
    }

    public void fireTableModelChange() {
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    protected boolean isEditable() {
        return this.isEditable;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
        if (!this.isDirty) {
            this.tblContext.resetUpdateState();
        }
    }

    DataViewTableUI getDataViewTableUI() {
        return this.tableUI;
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.tblContext;
    }

    DataViewDBTable getDataViewDBTable() {
        return this.tblMeta;
    }

    boolean isCommitEnabled() {
        return this.dataViewUI.isCommitEnabled();
    }

    public void createTableModel(List<Object[]> list) {
        assert (list != null);
        this.setDirty(false);
        final TableModel tableModel = this.model = this.createModelFrom(list);
        Runnable runnable = new Runnable(){

            public void run() {
                DataViewTablePanel.this.tableUI.setModel(tableModel);
                if (!DataViewTablePanel.this.columnWidthList.isEmpty()) {
                    DataViewTablePanel.this.setHeader(DataViewTablePanel.this.tableUI, DataViewTablePanel.this.columnWidthList);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setHeader(JTable jTable, List<Integer> list) {
        try {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(list.get(i));
            }
            jTable.getTableHeader().setColumnModel(tableColumnModel);
        }
        catch (Exception exception) {
            mLogger.log(Level.INFO, "Failed to set the size of the table headers" + exception);
        }
    }

    private List<Integer> getColumnWidthList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            for (int i = 0; i < this.tblMeta.getColumnCount(); ++i) {
                int n;
                DBColumn dBColumn = this.tblMeta.getColumn(i);
                int n2 = dBColumn.getDisplaySize();
                int n3 = Math.max(n2, n = dBColumn.getDisplayName().length()) * this.tableUI.getMultiplier();
                if (n3 > this.MAX_COLUMN_WIDTH * this.tableUI.getMultiplier()) {
                    n3 = this.MAX_COLUMN_WIDTH * this.tableUI.getMultiplier();
                }
                arrayList.add(n3);
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.INFO, "Failed to set the size of the table headers" + exception);
        }
        return arrayList;
    }

    private TableModel createModelFrom(List<Object[]> list) {
        DataViewTableModel dataViewTableModel = new DataViewTableModel(list);
        DataViewTableSorter dataViewTableSorter = new DataViewTableSorter(dataViewTableModel);
        dataViewTableSorter.setTableHeader(this.tableUI.getTableHeader());
        int n = this.tblMeta.getColumnCount();
        for (int i = 0; i < n; ++i) {
            DBColumn dBColumn = this.tblMeta.getColumn(i);
            dataViewTableModel.addColumn(dBColumn.getDisplayName());
        }
        for (Object[] objectArray : list) {
            dataViewTableModel.addRow(objectArray);
        }
        return dataViewTableSorter;
    }

    List<Object[]> getPageDataFromTable() {
        DataViewTableSorter dataViewTableSorter = (DataViewTableSorter)this.tableUI.getModel();
        DefaultTableModel defaultTableModel = (DefaultTableModel)dataViewTableSorter.getTableModel();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = defaultTableModel.getColumnCount();
        for (Vector vector : defaultTableModel.getDataVector()) {
            Object[] objectArray = new Object[n];
            int n2 = 0;
            for (Object e : vector) {
                objectArray[n2++] = e;
            }
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public void enableDeleteBtn(boolean bl) {
        this.dataViewUI.enableDeleteBtn(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataViewTableModel
    extends DefaultTableModel {
        Class[] collumnClasses;

        DataViewTableModel(List<Object[]> list) {
            this.collumnClasses = new Class[DataViewTablePanel.this.tblMeta.getColumnCount()];
            if (list.size() > 0) {
                Object[] objectArray = list.get(0);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (objectArray[i] == null) continue;
                    this.collumnClasses[i] = objectArray[i].getClass();
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!DataViewTablePanel.this.isEditable) {
                return false;
            }
            DBColumn dBColumn = DataViewTablePanel.this.tblMeta.getColumn(n2);
            if (dBColumn.isGenerated()) {
                return false;
            }
            return dBColumn.isEditable();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (DataViewTablePanel.this.tblMeta == null) {
                return;
            }
            Object object2 = this.getValueAt(n, n2);
            if (object2 != null && object2.toString().equals(object == null ? "" : object.toString()) || object2 == null && object == null) {
                return;
            }
            try {
                Object object3 = DBReadWriteHelper.validate(object, DataViewTablePanel.this.tblMeta.getColumn(n2));
                DataViewTablePanel.this.tblContext.createUpdateStatement(n, n2, object3, DataViewTablePanel.this.model);
                DataViewTablePanel.this.isDirty = true;
                super.setValueAt(object3, n, n2);
                DataViewTablePanel.this.dataViewUI.setCommitEnabled(true);
                DataViewTablePanel.this.dataViewUI.setCancelEnabled(true);
                this.fireTableDataChanged();
            }
            catch (DBException dBException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)dBException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            DataViewTablePanel.this.tableUI.revalidate();
            DataViewTablePanel.this.tableUI.repaint();
        }

        public Class getColumnClass(int n) {
            if (this.collumnClasses[n] == null) {
                return super.getColumnClass(n);
            }
            return this.collumnClasses[n];
        }
    }
}

