/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.Connection;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.spi.DBConnectionProvider;
import org.openide.util.Mutex;

public final class DBConnectionFactory {
    private static volatile DBConnectionFactory INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBConnectionFactory getInstance() {
        Class<DBConnectionFactory> clazz = DBConnectionFactory.class;
        synchronized (DBConnectionFactory.class) {
            if (INSTANCE == null && INSTANCE == null) {
                INSTANCE = new DBConnectionFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private DBConnectionFactory() {
    }

    public void closeConnection(Connection connection) {
        DBConnectionProvider dBConnectionProvider = this.findDBConnectionProvider();
        if (dBConnectionProvider != null) {
            dBConnectionProvider.closeConnection(connection);
        }
    }

    public Connection getConnection(DatabaseConnection databaseConnection) {
        DBConnectionProvider dBConnectionProvider = this.findDBConnectionProvider();
        if (dBConnectionProvider != null) {
            return dBConnectionProvider.getConnection(databaseConnection);
        }
        return this.showConnectionDialog(databaseConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection showConnectionDialog(final DatabaseConnection databaseConnection) {
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                return null;
            }
        });
        Class<DBConnectionFactory> clazz = DBConnectionFactory.class;
        synchronized (DBConnectionFactory.class) {
            if (databaseConnection != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return databaseConnection.getJDBCConnection();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private DBConnectionProvider findDBConnectionProvider() {
        Iterator<DBConnectionProvider> iterator = ServiceRegistry.lookupProviders(DBConnectionProvider.class);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        ClassLoader classLoader = DBConnectionFactory.class.getClassLoader();
        iterator = ServiceRegistry.lookupProviders(DBConnectionProvider.class, classLoader);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

