/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.editor.CssHelpResolver;
import org.netbeans.modules.css.editor.CssPropertyValue;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.gsf.AstUtils;
import org.netbeans.modules.css.gsf.CSSElement;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.CssPropertyElement;
import org.netbeans.modules.css.gsf.CssValueElement;
import org.netbeans.modules.css.lexer.api.CSSTokenId;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultCompletionResult;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSCompletion
implements CodeCompletionHandler {
    private static final Logger LOGGER = Logger.getLogger(CSSCompletion.class.getName());
    private final PropertyModel PROPERTIES = PropertyModel.instance();
    private static final Collection<String> AT_RULES = Arrays.asList("@media", "@page", "@import", "@charset", "@font-face");
    private final HashMap<String, String> colors = new HashMap(20);

    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        CompilationInfo compilationInfo = codeCompletionContext.getInfo();
        int n = codeCompletionContext.getCaretOffset();
        String string = codeCompletionContext.getPrefix();
        NameKind nameKind = codeCompletionContext.getNameKind();
        CodeCompletionHandler.QueryType queryType = codeCompletionContext.getQueryType();
        boolean bl = codeCompletionContext.isCaseSensitive();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return CodeCompletionResult.NONE;
        }
        TokenSequence tokenSequence = LexerUtils.getCssTokenSequence(document, n);
        if (tokenSequence == null || string == null) {
            return this.wrapProperties(this.PROPERTIES.properties(), CompletionItemKind.PROPERTY, n);
        }
        tokenSequence.move(n - string.length());
        boolean bl2 = tokenSequence.moveNext();
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
        TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            return CodeCompletionResult.NONE;
        }
        int n2 = translatedSource == null ? n : translatedSource.getAstOffset(n);
        SimpleNode simpleNode2 = SimpleNodeUtil.findDescendant(simpleNode, n2);
        if (simpleNode2 == null) {
            if (bl2 && "@".equals(((Object)tokenSequence.token().text()).toString())) {
                return this.wrapRAWValues(AT_RULES, CompletionItemKind.VALUE, tokenSequence.offset());
            }
            return CodeCompletionResult.NONE;
        }
        if (simpleNode2.kind() == 35 && (simpleNode2 = (SimpleNode)simpleNode2.jjtGetParent()) == null) {
            return CodeCompletionResult.NONE;
        }
        if (simpleNode2.kind() == 1) {
            return this.wrapRAWValues(AT_RULES, CompletionItemKind.VALUE, n);
        }
        if (simpleNode2.kind() == 37) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetParent();
            if (simpleNode3 != null && simpleNode3.kind() == 4) {
                Collection<String> collection = this.filterStrings(AT_RULES, string);
                return this.wrapRAWValues(collection, CompletionItemKind.VALUE, AstUtils.documentPosition(simpleNode3.startOffset(), translatedSource));
            }
        } else if (simpleNode2.kind() == 5 || simpleNode2.kind() == 6 || simpleNode2.kind() == 11 || simpleNode2.kind() == 3 || simpleNode2.kind() == 13) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == CSSTokenId.IMPORT_SYM || tokenId == CSSTokenId.MEDIA_SYM || tokenId == CSSTokenId.PAGE_SYM || tokenId == CSSTokenId.CHARSET_SYM || tokenId == CSSTokenId.FONT_FACE_SYM) {
                Collection<String> collection = this.filterStrings(AT_RULES, string);
                return this.wrapRAWValues(collection, CompletionItemKind.VALUE, AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource));
            }
        } else {
            if (simpleNode2.kind() == 17 && (string.length() > 0 || n2 == simpleNode2.startOffset())) {
                Collection<Property> collection = this.filterProperties(this.PROPERTIES.properties(), string);
                return this.wrapProperties(collection, CompletionItemKind.PROPERTY, AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource));
            }
            if (simpleNode2.kind() == 18) {
                return this.wrapProperties(this.PROPERTIES.properties(), CompletionItemKind.PROPERTY, n);
            }
            if (simpleNode2.kind() == 28) {
                Object object;
                final SimpleNode[] simpleNodeArray = new SimpleNode[2];
                NodeVisitor nodeVisitor = new NodeVisitor(){

                    public void visit(SimpleNode simpleNode) {
                        if (simpleNode.kind() == 17) {
                            simpleNodeArray[0] = simpleNode;
                        } else if (simpleNode.kind() == 39) {
                            simpleNodeArray[1] = simpleNode;
                        }
                    }
                };
                simpleNode2.visitChildren(nodeVisitor);
                SimpleNode simpleNode4 = simpleNodeArray[0];
                String string2 = "";
                if (simpleNodeArray[1] != null) {
                    int n3;
                    int n4;
                    object = simpleNode2.image().trim();
                    if (((String)object).endsWith("}")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if ((n4 = ((String)object).indexOf(58)) >= 0) {
                        string2 = ((String)object).substring(n4 + 1);
                    }
                    if ((n3 = string2.indexOf(10)) > 0) {
                        string2 = string2.substring(0, n3);
                    }
                }
                if ((object = this.PROPERTIES.getProperty(simpleNode4.image())) != null) {
                    int n5;
                    CssPropertyValue cssPropertyValue = new CssPropertyValue((Property)object, string2);
                    Set<PropertyModel.Element> set = cssPropertyValue.alternatives();
                    Collection<PropertyModel.Element> collection = this.filterElements(set, string);
                    int n6 = n5 = string.trim().length() == 0 ? n : AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource);
                    if (set.size() > 0 && collection.size() == 0) {
                        n5 = n;
                        collection = set;
                    }
                    return this.wrapPropertyValues((Property)object, collection, CompletionItemKind.VALUE, n5, false);
                }
            } else if (simpleNode2.kind() == 31) {
                int n7;
                final SimpleNode[] simpleNodeArray = new SimpleNode[1];
                NodeVisitor nodeVisitor = new NodeVisitor(){

                    public void visit(SimpleNode simpleNode) {
                        if (simpleNode.kind() == 28) {
                            simpleNodeArray[0] = simpleNode;
                        }
                    }
                };
                SimpleNodeUtil.visitAncestors(simpleNode2, nodeVisitor);
                SimpleNode simpleNode5 = simpleNodeArray[0];
                simpleNodeArray[0] = null;
                NodeVisitor nodeVisitor2 = new NodeVisitor(){

                    public void visit(SimpleNode simpleNode) {
                        if (simpleNode.kind() == 17) {
                            simpleNodeArray[0] = simpleNode;
                        }
                    }
                };
                SimpleNodeUtil.visitChildren(simpleNode5, nodeVisitor2);
                SimpleNode simpleNode6 = simpleNodeArray[0];
                Property property = this.PROPERTIES.getProperty(simpleNode6.image());
                if (property == null) {
                    return CodeCompletionResult.NONE;
                }
                SimpleNode simpleNode7 = (SimpleNode)simpleNode2.jjtGetParent();
                String string3 = simpleNode7.image();
                int n8 = string3.indexOf(10);
                if (n8 > 0) {
                    string3 = string3.substring(0, n8);
                }
                CssPropertyValue cssPropertyValue = new CssPropertyValue(property, string3);
                Set<PropertyModel.Element> set = cssPropertyValue.alternatives();
                Collection<PropertyModel.Element> collection = this.filterElements(set, string);
                int n9 = n7 = string.trim().length() == 0 ? n : AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource);
                if (set.size() > 0 && collection.size() == 0) {
                    n7 = n;
                    collection = set;
                }
                return this.wrapPropertyValues(property, collection, CompletionItemKind.VALUE, n7, false);
            }
        }
        return CodeCompletionResult.NONE;
    }

    private CodeCompletionResult wrapRAWValues(Collection<String> collection, CompletionItemKind completionItemKind, int n) {
        ArrayList<CSSCompletionItem> arrayList = new ArrayList<CSSCompletionItem>(collection.size());
        for (String string : collection) {
            CSSElement cSSElement = new CSSElement(string);
            CSSCompletionItem cSSCompletionItem = this.createCompletionItem(cSSElement, string, completionItemKind, n, false);
            arrayList.add(cSSCompletionItem);
        }
        return new DefaultCompletionResult(arrayList, false);
    }

    private CodeCompletionResult wrapPropertyValues(Property property, Collection<PropertyModel.Element> collection, CompletionItemKind completionItemKind, int n, boolean bl) {
        ArrayList<CSSCompletionItem> arrayList = new ArrayList<CSSCompletionItem>(collection.size());
        for (PropertyModel.Element element : collection) {
            if (element instanceof PropertyModel.ValueElement && ((PropertyModel.ValueElement)element).isUnit()) continue;
            CssValueElement cssValueElement = new CssValueElement(property, element);
            CSSCompletionItem cSSCompletionItem = this.createValueCompletionItem(cssValueElement, element, completionItemKind, n, bl);
            arrayList.add(cSSCompletionItem);
        }
        return new DefaultCompletionResult(arrayList, false);
    }

    private Collection<String> filterStrings(Collection<String> collection, String string) {
        string = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            if (!string2.toLowerCase().startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private Collection<PropertyModel.Element> filterElements(Collection<PropertyModel.Element> collection, String string) {
        string = string.toLowerCase();
        ArrayList<PropertyModel.Element> arrayList = new ArrayList<PropertyModel.Element>();
        for (PropertyModel.Element element : collection) {
            if (!element.toString().toLowerCase().startsWith(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    private CodeCompletionResult wrapProperties(Collection<Property> collection, CompletionItemKind completionItemKind, int n) {
        ArrayList<CSSCompletionItem> arrayList = new ArrayList<CSSCompletionItem>(collection.size());
        for (Property property : collection) {
            if (property.name().startsWith("-")) continue;
            CssPropertyElement cssPropertyElement = new CssPropertyElement(property);
            CSSCompletionItem cSSCompletionItem = this.createCompletionItem(cssPropertyElement, property.name(), completionItemKind, n, false);
            arrayList.add(cSSCompletionItem);
        }
        return new DefaultCompletionResult(arrayList, false);
    }

    private Collection<Property> filterProperties(Collection<Property> collection, String string) {
        string = string.toLowerCase();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : collection) {
            if (!property.name().toLowerCase().startsWith(string)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (elementHandle instanceof CssValueElement) {
            CssValueElement cssValueElement = (CssValueElement)elementHandle;
            return CssHelpResolver.instance().getPropertyHelp(cssValueElement.property().name());
        }
        if (elementHandle instanceof CssPropertyElement) {
            CssPropertyElement cssPropertyElement = (CssPropertyElement)elementHandle;
            return CssHelpResolver.instance().getPropertyHelp(cssPropertyElement.property().name());
        }
        return null;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return new ElementHandle.UrlHandle(CssHelpResolver.HELP_URL + string);
    }

    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        Token token;
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return null;
        }
        TokenSequence tokenSequence = LexerUtils.getCssTokenSequence(document, n);
        if (tokenSequence == null) {
            return null;
        }
        int n2 = tokenSequence.move(n);
        if (n2 == 0) {
            if (!tokenSequence.movePrevious()) {
                return "";
            }
        } else if (!tokenSequence.moveNext()) {
            return null;
        }
        if ((token = tokenSequence.token()).id() == CSSTokenId.COLON) {
            return "";
        }
        return ((Object)token.text().subSequence(0, n2 == 0 ? token.text().length() : n2)).toString().trim();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        if (string == null || string.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = string.charAt(0);
        switch (c) {
            case '\n': 
            case ';': 
            case '}': {
                return CodeCompletionHandler.QueryType.STOP;
            }
            case ':': {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        return "";
    }

    public Set<String> getApplicableTemplates(CompilationInfo compilationInfo, int n, int n2) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        return ParameterInfo.NONE;
    }

    private CSSCompletionItem createValueCompletionItem(CssValueElement cssValueElement, PropertyModel.Element element, CompletionItemKind completionItemKind, int n, boolean bl) {
        String string = element.origin();
        assert (string != null) : "Css value completion item has no origin!";
        if (string.startsWith("-")) {
            PropertyModel.Element element2 = element;
            while ((element2 = element2.parent()) != null) {
                if (element2.origin() == null) continue;
                string = element2.origin();
                break;
            }
        }
        if ("color".equals(string)) {
            return new ColorCompletionItem(cssValueElement, element.toString(), string, completionItemKind, n, bl);
        }
        return new ValueCompletionItem(cssValueElement, element.toString(), string, completionItemKind, n, bl);
    }

    private CSSCompletionItem createCompletionItem(CSSElement cSSElement, String string, CompletionItemKind completionItemKind, int n, boolean bl) {
        return new CSSCompletionItem(cSSElement, string, completionItemKind, n, bl);
    }

    private synchronized HashMap<String, String> colors() {
        if (this.colors.isEmpty()) {
            this.colors.put("red", "ff0000");
            this.colors.put("black", "000000");
            this.colors.put("green", "00ff00");
            this.colors.put("blue", "0000ff");
            this.colors.put("silver", "C0C0C0");
            this.colors.put("gray", "808080");
            this.colors.put("white", "ffffff");
            this.colors.put("maroon", "800000");
            this.colors.put("purple", "800080");
            this.colors.put("fuchsia", "ff00ff");
            this.colors.put("lime", "00ff00");
            this.colors.put("olive", "808000");
            this.colors.put("orange", "ffa500");
            this.colors.put("yellow", "ffff00");
            this.colors.put("navy", "000080");
            this.colors.put("teal", "008080");
            this.colors.put("aqua", "00ffff");
        }
        return this.colors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSSCompletionItem
    implements CompletionProposal {
        private static final String CSS_PROPERTY = "org/netbeans/modules/css/resources/methodPublic.png";
        private static final String CSS_VALUE = "org/netbeans/modules/css/resources/fieldPublic.png";
        private ImageIcon propertyIcon;
        private ImageIcon valueIcon;
        private int anchorOffset;
        private String value;
        protected CompletionItemKind kind;
        private CSSElement element;
        protected boolean addSemicolon;

        private CSSCompletionItem() {
        }

        private CSSCompletionItem(CSSElement cSSElement, String string, CompletionItemKind completionItemKind, int n, boolean bl) {
            this.anchorOffset = n;
            this.value = string;
            this.kind = completionItemKind;
            this.element = cSSElement;
            this.addSemicolon = bl;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public String getName() {
            return this.value;
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public ImageIcon getIcon() {
            if (this.kind == CompletionItemKind.PROPERTY) {
                if (this.propertyIcon == null) {
                    this.propertyIcon = new ImageIcon(Utilities.loadImage((String)CSS_PROPERTY));
                }
                return this.propertyIcon;
            }
            if (this.kind == CompletionItemKind.VALUE) {
                if (this.valueIcon == null) {
                    this.valueIcon = new ImageIcon(Utilities.loadImage((String)CSS_VALUE));
                }
                return this.valueIcon;
            }
            return null;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.getName());
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public String toString() {
            return this.getName();
        }

        public boolean isSmart() {
            return false;
        }

        public List<String> getInsertParams() {
            return null;
        }

        public String[] getParamListDelimiters() {
            return new String[]{"(", ")"};
        }

        public String getCustomInsertTemplate() {
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }
    }

    private class ColorCompletionItem
    extends ValueCompletionItem {
        final byte COLOR_ICON_SIZE = 16;
        final byte COLOR_RECT_SIZE = 10;

        private ColorCompletionItem(CSSElement cSSElement, String string, String string2, CompletionItemKind completionItemKind, int n, boolean bl) {
            super(cSSElement, string, string2, completionItemKind, n, bl);
            this.COLOR_ICON_SIZE = (byte)16;
            this.COLOR_RECT_SIZE = (byte)10;
        }

        public ImageIcon getIcon() {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            String string = (String)CSSCompletion.this.colors().get(this.getName());
            if (string == null) {
                return null;
            }
            Color color = new Color(0xFFFFFF, true);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, 16, 16);
            graphics2D.setColor(Color.decode("0x" + string));
            graphics2D.fillRect(6, 5, 9, 9);
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.drawRect(5, 4, 10, 10);
            return new ImageIcon(bufferedImage);
        }
    }

    private class ValueCompletionItem
    extends CSSCompletionItem {
        private String origin;

        private ValueCompletionItem(CSSElement cSSElement, String string, String string2, CompletionItemKind completionItemKind, int n, boolean bl) {
            super(cSSElement, string, completionItemKind, n, bl);
            this.origin = string2;
        }

        public String getInsertPrefix() {
            return this.getName() + (this.addSemicolon ? ";" : "");
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return "<font color=999999>" + this.origin + "</font>";
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            Property property = ((CssValueElement)this.getElement()).property();
            String string = property.initialValue();
            if (string != null && string.equals(this.getName())) {
                return "<i>" + super.getLhsHtml(htmlFormatter) + "</i>";
            }
            return super.getLhsHtml(htmlFormatter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompletionItemKind {
        PROPERTY,
        VALUE;

    }
}

