/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.EditorAwareSourceTaskSupport;
import org.netbeans.modules.css.parser.ASCII_CharStream;
import org.netbeans.modules.css.parser.CSSParser;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.ParseException;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String MODEL_UPDATED = "modelUpdated";
    public static final String MODEL_PARSING = "modelParsing";
    public static final String MODEL_INVALID = "modelInvalid";
    private Document doc;
    private List<CssRule> rules = new ArrayList<CssRule>(10);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean immutable;

    public static CssModel get(Document document) {
        if (document == null) {
            throw new NullPointerException("Passed null document!");
        }
        CssModel cssModel = (CssModel)document.getProperty(CssModel.class);
        if (cssModel == null) {
            cssModel = new CssModel(document);
            document.putProperty(CssModel.class, cssModel);
        }
        return cssModel;
    }

    public static CssModel get(Reader reader) {
        try {
            CSSParser cSSParser = new CSSParser();
            cSSParser.ReInit(new ASCII_CharStream(reader));
            SimpleNode simpleNode = cSSParser.styleSheet();
            return new CssModel(simpleNode);
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
            return null;
        }
    }

    private CssModel(Document document) {
        try {
            this.doc = document;
            this.immutable = true;
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
            FileObject fileObject = dataObject.getPrimaryFile();
            EditorAwareSourceTaskSupport.Listener listener = new EditorAwareSourceTaskSupport.Listener(){

                public void parsed(CompilationInfo compilationInfo) {
                    if (compilationInfo.getDocument() != CssModel.this.doc) {
                        return;
                    }
                    ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
                    SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
                    if (CssModel.this.containsErrors(parserResult)) {
                        CssModel.this.support.firePropertyChange(CssModel.MODEL_INVALID, CssModel.this.rules, null);
                        return;
                    }
                    CssModel.this.updateModel(simpleNode);
                }
            };
            EditorAwareSourceTaskSupport.instance().addListener(listener);
            final HashSet hashSet = new HashSet(1);
            SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(CompilationInfo compilationInfo) throws Exception {
                    ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
                    hashSet.add(parserResult);
                }
            }, true);
            ParserResult parserResult = (ParserResult)hashSet.iterator().next();
            SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
            if (this.containsErrors(parserResult)) {
                this.support.firePropertyChange(MODEL_INVALID, this.rules, null);
                return;
            }
            this.updateModel(simpleNode);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private boolean containsErrors(ParserResult parserResult) {
        for (Error error : parserResult.getDiagnostics()) {
            if (error.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    private CssModel(SimpleNode simpleNode) {
        this.immutable = false;
        this.updateModel(simpleNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CssRule> rules() {
        List<CssRule> list = this.rules;
        synchronized (list) {
            return this.rules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssRule ruleForOffset(int n) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            if (this.rules != null) {
                for (CssRule cssRule : this.rules()) {
                    if (cssRule.getRuleNameOffset() > n || cssRule.getRuleCloseBracketOffset() < n) continue;
                    return cssRule;
                }
            }
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private boolean isImmutable() {
        return this.immutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateModel(SimpleNode simpleNode) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            List<CssRule> list2 = this.rules;
            final ArrayList<CssRule> arrayList = new ArrayList<CssRule>(list2.size());
            NodeVisitor nodeVisitor = new NodeVisitor(){

                public void visit(SimpleNode simpleNode) {
                    try {
                        if (simpleNode.kind() == 18) {
                            Object object;
                            Object object2;
                            Token token = simpleNode.jjtGetFirstToken();
                            Token token2 = simpleNode.jjtGetLastToken();
                            int n = -1;
                            int n2 = -1;
                            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                            while (token != null && token.offset <= token2.offset) {
                                if (token.kind == 8) {
                                    n = token.offset;
                                } else if (token.kind == 9) {
                                    n2 = token.offset;
                                } else if (token.kind == 12) {
                                    arrayList4.add(token.offset);
                                } else if (token.kind == 13) {
                                    arrayList2.add(token.offset);
                                }
                                token = token.next;
                            }
                            SimpleNode simpleNode2 = SimpleNodeUtil.getChildByType(simpleNode, 19);
                            SimpleNode[] simpleNodeArray = SimpleNodeUtil.getChildrenByType(simpleNode, 28);
                            ArrayList<CssRuleItem> arrayList3 = new ArrayList<CssRuleItem>(simpleNodeArray.length);
                            for (int i = 0; i < simpleNodeArray.length; ++i) {
                                object2 = simpleNodeArray[i];
                                object = SimpleNodeUtil.getChildByType((SimpleNode)object2, 17);
                                SimpleNode simpleNode3 = SimpleNodeUtil.getChildByType((SimpleNode)object2, 30);
                                int n3 = i < arrayList4.size() ? (Integer)arrayList4.get(i) : -1;
                                int n4 = (Integer)arrayList2.get(i);
                                CssRuleItem cssRuleItem = new CssRuleItem(CssModel.this.doc, ((SimpleNode)object).image(), ((SimpleNode)object).startOffset(), simpleNode3.image(), simpleNode3.startOffset(), n4, n3);
                                arrayList3.add(cssRuleItem);
                            }
                            CssRuleContent cssRuleContent = new CssRuleContent(arrayList3, CssModel.this.isImmutable());
                            object2 = simpleNode2.image().trim();
                            object = new CssRule(CssModel.this.doc, (String)object2, simpleNode2.startOffset(), n, n2, cssRuleContent);
                            arrayList.add(object);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            };
            SimpleNodeUtil.visitChildren(simpleNode, nodeVisitor);
            if (LOG) {
                LOGGER.fine("CssModel parse tree:");
                simpleNode.dump("");
                LOGGER.fine("CssModel structure:");
                for (CssRule cssRule : arrayList) {
                    LOGGER.fine(cssRule.toString());
                }
            }
            this.rules = arrayList;
            this.support.firePropertyChange(MODEL_UPDATED, list2, this.rules);
        }
    }
}

