/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.bridge.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCreator {
    private static final String MAKEFILE_NAME = "Makefile";
    private static final String TYPE = "org.netbeans.modules.cnd.makeproject";
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/make-project/1";
    private String workingDir;
    private String buildCommand;
    private String cleanCommand;
    private String output;
    private String makefileName = "Makefile";
    private List<File> sourceFiles;
    private List<String> requiredProjects;
    private String makefilePath;
    private String projectFolder;
    private String baseDir;
    private String buildScript;
    private Folder rootFolder;
    private DiscoveryDescriptor discovery;

    public ProjectCreator(DiscoveryDescriptor discoveryDescriptor) {
        this.discovery = discoveryDescriptor;
    }

    public void init(String string, String string2, String string3, String string4) {
        this.projectFolder = string;
        this.workingDir = string2;
        this.makefilePath = string3;
        this.buildScript = string4;
    }

    public void setBuildCommand(String string) {
        this.buildCommand = string;
    }

    public void setCleanCommand(String string) {
        this.cleanCommand = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void setSourceFiles(List<File> list) {
        this.sourceFiles = list;
    }

    public void setRequiredProjects(List<String> list) {
        this.requiredProjects = list;
    }

    public List<String> getProjectLevelInludes() {
        return Collections.emptyList();
    }

    public List<String> getProjectLevelMacros() {
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public AntProjectHelper createProject(String string, String string2, Set<String> set, Set<String> set2) throws IOException {
        void var10_15;
        File file = new File(this.projectFolder);
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
        }
        String string3 = "Default";
        MakeConfiguration makeConfiguration = new MakeConfiguration(file.getPath(), string3, 0, "localhost");
        String string4 = IpeUtils.toRelativePath((String)file.getPath(), (String)FilePathAdaptor.naturalize((String)this.workingDir));
        string4 = FilePathAdaptor.normalize((String)string4);
        makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string4);
        if (string2.indexOf(".lib.") > 0 || string2.indexOf(".cmd.") > 0) {
            makeConfiguration.getMakefileConfiguration().getBuildCommand().setValue("bldenv -d ../../../../" + this.buildScript + " 'dmake all'");
            makeConfiguration.getMakefileConfiguration().getCleanCommand().setValue("bldenv -d ../../../../" + this.buildScript + " 'dmake clobber'");
        } else {
            makeConfiguration.getMakefileConfiguration().getBuildCommand().setValue("bldenv -d ../../../" + this.buildScript + " 'dmake all'");
            makeConfiguration.getMakefileConfiguration().getCleanCommand().setValue("bldenv -d ../../../" + this.buildScript + " 'dmake clobber'");
        }
        makeConfiguration.getMakefileConfiguration().getOutput().setValue(this.output);
        if (this.requiredProjects != null) {
            for (String iterator2 : this.requiredProjects) {
                makeConfiguration.getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(iterator2, 0, "Default", true, false, iterator2, "${MAKE}  -f " + iterator2 + "-Makefile.mk CONF=Default", "${MAKE}  -f " + iterator2 + "-Makefile.mk CONF=Default clean", "")));
            }
        }
        if (Utilities.getOperatingSystem() == 8) {
            makeConfiguration.getCompilerSet().setCompilerSetName(new StringConfiguration(null, "SunStudio"));
        } else {
            makeConfiguration.getCompilerSet().setCompilerSetName(new StringConfiguration(null, "GNU"));
        }
        makeConfiguration.getCCCompilerConfiguration().getIncludeDirectories().setValue(this.getProjectLevelInludes());
        makeConfiguration.getCCompilerConfiguration().getIncludeDirectories().setValue(this.getProjectLevelInludes());
        makeConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration().setValue(this.getProjectLevelMacros());
        makeConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration().setValue(this.getProjectLevelMacros());
        Iterator<String> iterator3 = null;
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.makefilePath = IpeUtils.toRelativePath((String)file.getPath(), (String)FilePathAdaptor.naturalize((String)this.makefilePath));
            this.makefilePath = FilePathAdaptor.normalize((String)this.makefilePath);
            arrayList.add(this.makefilePath);
            iterator3 = arrayList.iterator();
        }
        Object var10_13 = null;
        if (this.sourceFiles != null) {
            Iterator<File> iterator = this.sourceFiles.iterator();
        }
        AntProjectHelper antProjectHelper = null;
        this.makefileName = string + "-" + this.makefileName + ".mk";
        antProjectHelper = this.createProject(file, string2, this.makefileName, (Configuration[])new MakeConfiguration[]{makeConfiguration}, (Iterator)var10_15, iterator3, set, set2);
        return antProjectHelper;
    }

    public AntProjectHelper createProject(File file, String string, String string2, Configuration[] configurationArray, Iterator iterator, Iterator iterator2, Set<String> set, Set<String> set2) throws IOException {
        FileObject fileObject = ProjectCreator.createProjectDir(file);
        AntProjectHelper antProjectHelper = this.createProject(fileObject, string, string2, configurationArray, iterator, iterator2);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        boolean bl = this.applyDiscovery(project, string, set, set2);
        ProjectManager.getDefault().saveProject(project);
        if (!bl) {
            this.removeProjectDir(file);
            return null;
        }
        ProjectManager.getDefault().clearNonProjectCache();
        return antProjectHelper;
    }

    private AntProjectHelper createProject(FileObject fileObject, String string, String string2, Configuration[] configurationArray, Iterator iterator, Iterator iterator2) throws IOException {
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)TYPE);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS(PROJECT_CONFIGURATION_NAMESPACE, "make-project-type");
        element3.appendChild(document.createTextNode("0"));
        element.appendChild(element3);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        MakeConfigurationDescriptor makeConfigurationDescriptor = new MakeConfigurationDescriptor(FileUtil.toFile((FileObject)fileObject).getPath());
        makeConfigurationDescriptor.setProjectMakefileName(string2);
        makeConfigurationDescriptor.init(configurationArray);
        this.baseDir = makeConfigurationDescriptor.getBaseDir();
        makeConfigurationDescriptor.initLogicalFolders(null, false, iterator2);
        this.rootFolder = makeConfigurationDescriptor.getLogicalFolders();
        makeConfigurationDescriptor.addSourceRootRaw(IpeUtils.toRelativePath((String)this.baseDir, (String)this.workingDir));
        this.addFiles(iterator);
        makeConfigurationDescriptor.save();
        this.copyURLFile("/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile", makeConfigurationDescriptor.getBaseDir() + File.separator + makeConfigurationDescriptor.getProjectMakefileName());
        return antProjectHelper;
    }

    private boolean applyDiscovery(Project project, String string, Set<String> set, Set<String> set2) throws IOException {
        this.discovery.setProject(project);
        new DiscoveryProjectGenerator(this.discovery).process();
        this.createAdditionalRequiredProjects(project, string, set, set2);
        return true;
    }

    private void addFiles(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            String string = IpeUtils.toRelativePath((String)this.workingDir, (String)file.getPath());
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            String string2 = IpeUtils.toRelativePath((String)this.baseDir, (String)file.getPath());
            this.addFile(this.rootFolder, stringTokenizer, file.getPath(), string2);
        }
    }

    private void addFile(Folder object, StringTokenizer stringTokenizer, String string, String string2) {
        String string3;
        String string4;
        if (stringTokenizer.countTokens() == 1) {
            string4 = string.substring(0, string.lastIndexOf(File.separator));
            string3 = string4.substring(string4.lastIndexOf(File.separator) + 1);
            Folder folder = null;
            folder = object.findFolderByName(string3);
            if (folder == null) {
                folder = new Folder(object.getConfigurationDescriptor(), object, string3, string3, true);
                object.addFolder(folder);
            }
            object = folder;
        }
        while (stringTokenizer.hasMoreElements()) {
            string4 = stringTokenizer.nextToken();
            if (string4.contains(":") || string4.equals("..")) continue;
            if (string4.contains(".")) {
                object.addItem(new Item(string2));
                continue;
            }
            string3 = null;
            string3 = object.findFolderByName(string4);
            if (string3 == null) {
                string3 = new Folder(object.getConfigurationDescriptor(), object, string4, string4, true);
                object.addFolder((Folder)string3);
            }
            object = string3;
        }
    }

    private void copyURLFile(String string, String string2) throws IOException {
        Object object;
        String string3 = "nbresloc:" + string;
        InputStream inputStream = null;
        try {
            object = new URL(string3);
            inputStream = ((URL)object).openStream();
        }
        catch (Exception exception) {
            inputStream = MakeConfigurationDescriptor.class.getResourceAsStream(string);
        }
        if (inputStream != null) {
            object = new FileOutputStream(string2);
            FileUtil.copy((InputStream)inputStream, (OutputStream)object);
            inputStream.close();
            ((FileOutputStream)object).close();
        }
    }

    static FileObject createProjectDir(File file) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null && !file.exists()) {
            ProjectCreator.refreshFileSystem(file);
            if (!file.mkdirs()) {
                throw new IOException("Can not create project folder.");
            }
            ProjectCreator.refreshFileSystem(file);
        }
        fileObject = FileUtil.toFileObject((File)file);
        assert (fileObject != null) : "No such dir on disk: " + file;
        assert (fileObject.isFolder()) : "Not really a dir: " + file;
        return fileObject;
    }

    static void refreshFileSystem(File file) throws FileStateInvalidException {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        assert (fileObject != null) : "At least disk roots must be mounted! " + file2;
        fileObject.getFileSystem().refresh(false);
    }

    private Set<String> getIncludePaths(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Item item : makeConfigurationDescriptor.getProjectItems()) {
            BasicCompilerConfiguration basicCompilerConfiguration;
            ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
            if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) continue;
            BooleanConfiguration booleanConfiguration = itemConfiguration.getExcluded();
            if (booleanConfiguration.getValue()) {
                booleanConfiguration.setValue(false);
            }
            if (!((basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration()) instanceof CCCCompilerConfiguration)) continue;
            CCCCompilerConfiguration cCCCompilerConfiguration = (CCCCompilerConfiguration)basicCompilerConfiguration;
            for (String string : cCCCompilerConfiguration.getIncludeDirectories().getValueAsArray()) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private void createAdditionalRequiredProjects(Project project, String string, Set<String> set, Set<String> set2) {
        if (string.indexOf(".sources") > 0 || string.indexOf(".libraries") > 0 || string.indexOf(".uts") > 0 || string.indexOf(".commands") > 0) {
            return;
        }
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
        MakeConfiguration makeConfiguration = (MakeConfiguration)makeConfigurationDescriptor.getConfs().getActive();
        String string2 = string;
        if (string.indexOf(46) > 0) {
            string2 = string.substring(string.lastIndexOf(46) + 1);
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (string2.equals("libc")) {
            set2.remove("c");
        } else {
            set2.add("c");
        }
        for (String string3 : set2) {
            int n;
            string3 = "lib" + string3;
            String stringArray2 = null;
            for (String string4 : set) {
                if (!string4.endsWith("/" + string3)) continue;
                stringArray2 = string4;
                break;
            }
            if (stringArray2 == null) continue;
            String[] stringArray4 = this.workingDir.substring(this.workingDir.indexOf("/usr/src/") + 9).split("/");
            String[] stringArray = stringArray2.split("/");
            int n2 = 0;
            for (int i = 0; i < stringArray4.length && stringArray4[i].equals(stringArray[i]); ++i) {
                ++n2;
            }
            String string5 = "";
            for (n = n2; n < stringArray4.length; ++n) {
                string5 = string5 + "../";
            }
            for (n = n2; n < stringArray.length; ++n) {
                string5 = string5.length() > 0 && string5.charAt(string5.length() - 1) == '/' ? string5 + stringArray[n] : string5 + "/" + stringArray[n];
            }
            hashSet.add(string5);
        }
        for (String string3 : hashSet) {
            makeConfigurationDescriptor.setModified();
            makeConfiguration.getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(string3, 0, "Default", true, false, string3, "${MAKE}  -f " + string3 + "-Makefile.mk CONF=Default", "${MAKE}  -f " + string3 + "-Makefile.mk CONF=Default clean", "")));
        }
        makeConfigurationDescriptor.save();
    }

    private void removeProjectDir(File file) {
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            this.removeProjectDir(file2);
        }
        for (File file2 : file.listFiles()) {
            file2.delete();
        }
        file.delete();
    }
}

