/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBeanInvocationHandler
implements InvocationHandler {
    private static final String PARSE_METHOD = "valueOf";
    private static final String ADD_PREFIX = "add";
    private static final int ADD_PREFIX_LEN = "add".length();
    private static final String REMOVE_PREFIX = "remove";
    private static final int REMOVE_PREFIX_LEN = "remove".length();
    private static final String PROPERTY_CHANGE_LISTENER = "PropertyChangeListener";
    private static final String VETOABLE_CHANGE_LISTENER = "VetoableChangeListener";
    private static final String READ_PREFIX = "get";
    private static final String READ_BOOLEAN_PREFIX = "is";
    private static final String WRITE_PREFIX = "set";
    private static final String HAS_PREFIX = "has";
    private static final int READ_PREFIX_LEN = "get".length();
    private static final int READ_BOOLEAN_PREFIX_LEN = "is".length();
    private static final int WRITE_PREFIX_LEN = "set".length();
    private static final int HAS_PREFIX_LEN = "has".length();
    private PropertyChangeSupport _pcSupport;
    private VetoableChangeSupport _vcSupport;
    private Object _proxy;

    protected AbstractBeanInvocationHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws PropertyVetoException {
        String listener;
        Object ret = null;
        String name = method.getName();
        AbstractBeanInvocationHandler abstractBeanInvocationHandler = this;
        synchronized (abstractBeanInvocationHandler) {
            if (this._proxy == null) {
                this._proxy = proxy;
            }
        }
        if (name.startsWith(READ_PREFIX)) {
            String property = Introspector.decapitalize(name.substring(READ_PREFIX_LEN));
            ret = this.getProperty(property, method.getReturnType());
        } else if (name.startsWith(READ_BOOLEAN_PREFIX)) {
            String property = Introspector.decapitalize(name.substring(READ_BOOLEAN_PREFIX_LEN));
            ret = this.getProperty(property, method.getReturnType());
        } else if (name.startsWith(WRITE_PREFIX)) {
            String property = Introspector.decapitalize(name.substring(WRITE_PREFIX_LEN));
            this.setProperty(property, args[0], method.getParameterTypes()[0]);
        } else if (name.startsWith(ADD_PREFIX)) {
            listener = name.substring(ADD_PREFIX_LEN);
            if (listener.equals(PROPERTY_CHANGE_LISTENER)) {
                this.addPropertyChangeListener((String)args[0], (PropertyChangeListener)args[1]);
            } else if (listener.equals(VETOABLE_CHANGE_LISTENER)) {
                this.addVetoableChangeListener((String)args[0], (VetoableChangeListener)args[1]);
            }
        } else if (name.startsWith(REMOVE_PREFIX)) {
            listener = name.substring(REMOVE_PREFIX_LEN);
            if (listener.equals(PROPERTY_CHANGE_LISTENER)) {
                this.removePropertyChangeListener((String)args[0], (PropertyChangeListener)args[1]);
            } else if (listener.equals(VETOABLE_CHANGE_LISTENER)) {
                this.removeVetoableChangeListener((String)args[0], (VetoableChangeListener)args[1]);
            }
        } else if (name.startsWith(HAS_PREFIX)) {
            String property = Introspector.decapitalize(name.substring(HAS_PREFIX_LEN));
            ret = this.hasProperty(property);
        }
        return ret;
    }

    protected synchronized Object getProperty(String property, Class<?> clazz) {
        Object o;
        try {
            o = this.getPropertySpi(property, clazz);
            if (o == null) {
                o = AbstractBeanInvocationHandler.zero(clazz);
            } else if (o instanceof String && !clazz.equals(String.class)) {
                o = AbstractBeanInvocationHandler.parseValue((String)o, clazz);
            }
        }
        catch (Exception x) {
            o = AbstractBeanInvocationHandler.zero(clazz);
        }
        return o;
    }

    protected abstract Object getPropertySpi(String var1, Class<?> var2);

    protected synchronized void setProperty(String property, Object value, Class<?> clazz) throws PropertyVetoException {
        try {
            Object old;
            boolean pc = this._pcSupport != null && this._pcSupport.hasListeners(property);
            boolean vc = this._vcSupport != null && this._vcSupport.hasListeners(property);
            Object object = old = pc || vc ? this.getProperty(property, clazz) : null;
            if (vc) {
                this.fireVetoableChange(property, old, value);
            }
            if (clazz.equals(String.class) && !(value instanceof String)) {
                value = value.toString();
            }
            this.setPropertySpi(property, value, clazz);
            if (pc) {
                this.firePropertyChange(property, old, value);
            }
        }
        catch (PropertyVetoException x) {
            throw x;
        }
        catch (Exception x) {
            // empty catch block
        }
    }

    protected abstract void setPropertySpi(String var1, Object var2, Class<?> var3);

    protected synchronized boolean hasProperty(String property) {
        boolean ret;
        try {
            ret = this.hasPropertySpi(property);
        }
        catch (Exception x) {
            ret = false;
        }
        return ret;
    }

    protected abstract boolean hasPropertySpi(String var1);

    protected synchronized void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this._pcSupport == null) {
            this._pcSupport = new PropertyChangeSupport(this._proxy);
        }
        this._pcSupport.addPropertyChangeListener(property, listener);
    }

    protected synchronized void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this._pcSupport != null) {
            this._pcSupport.removePropertyChangeListener(property, listener);
        }
    }

    protected synchronized void addVetoableChangeListener(String property, VetoableChangeListener listener) {
        if (this._vcSupport == null) {
            this._vcSupport = new VetoableChangeSupport(this._proxy);
        }
        this._vcSupport.addVetoableChangeListener(property, listener);
    }

    protected synchronized void removeVetoableChangeListener(String property, VetoableChangeListener listener) {
        if (this._vcSupport != null) {
            this._vcSupport.removeVetoableChangeListener(property, listener);
        }
    }

    protected synchronized void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this._pcSupport != null) {
            this._pcSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    protected synchronized void fireVetoableChange(String property, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this._vcSupport != null) {
            this._vcSupport.fireVetoableChange(property, oldValue, newValue);
        }
    }

    protected synchronized Object getProxy() {
        return this._proxy;
    }

    protected static Object zero(Class clazz) {
        Comparable<Boolean> o = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                o = Boolean.FALSE;
            } else if (clazz == Byte.TYPE) {
                o = new Byte(0);
            } else if (clazz == Character.TYPE) {
                o = new Character('\u0000');
            } else if (clazz == Double.TYPE) {
                o = new Double(0.0);
            } else if (clazz == Float.TYPE) {
                o = new Float(0.0f);
            } else if (clazz == Integer.TYPE) {
                o = new Integer(0);
            } else if (clazz == Long.TYPE) {
                o = new Long(0L);
            } else if (clazz == Short.TYPE) {
                o = new Short(0);
            }
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Object parseValue(String value, Class clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("null argument");
        }
        Object o = null;
        if (value == null) {
            return AbstractBeanInvocationHandler.zero(clazz);
        }
        if (clazz.isPrimitive()) {
            try {
                if (clazz == Boolean.TYPE) {
                    return Boolean.valueOf(value);
                }
                if (clazz == Byte.TYPE) {
                    return Byte.valueOf(value);
                }
                if (clazz == Character.TYPE) {
                    return new Character(value.charAt(0));
                }
                if (clazz == Double.TYPE) {
                    return Double.valueOf(value);
                }
                if (clazz == Float.TYPE) {
                    return Float.valueOf(value);
                }
                if (clazz == Integer.TYPE) {
                    return Integer.valueOf(value);
                }
                if (clazz == Long.TYPE) {
                    return Long.valueOf(value);
                }
                if (clazz != Short.TYPE) return o;
                return Short.valueOf(value);
            }
            catch (Exception x) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(x);
            }
        }
        if (clazz == String.class) {
            return value;
        }
        if (clazz != Character.class) return AbstractBeanInvocationHandler.parseSpecialValue(value, clazz);
        return new Character(value.charAt(0));
    }

    protected static Object parseSpecialValue(String value, Class clazz) throws IllegalArgumentException {
        Object o;
        try {
            if (clazz == File.class) {
                o = new File(value);
            } else if (clazz == URL.class) {
                o = new URL(value);
            } else if (clazz == URI.class) {
                o = new URI(value);
            } else if (clazz == Class.class) {
                o = Class.forName(value);
            } else if (clazz == TimeZone.class) {
                o = TimeZone.getTimeZone(value);
            } else {
                Method parser = clazz.getMethod(PARSE_METHOD, String.class);
                o = parser.invoke(null, value);
            }
        }
        catch (Exception x) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(x);
        }
        return o;
    }
}

