/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.rubyproject.RubyActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyFileLocator
implements FileLocator {
    protected Lookup context;
    protected Project project;

    public RubyFileLocator(Lookup lookup, Project project) {
        assert (project != null);
        this.context = lookup;
        this.project = project;
    }

    public FileObject find(String string) {
        SourceGroup[] sourceGroupArray;
        File file = new File(string);
        if (file.isAbsolute() && file.isFile()) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray2 = sources.getSourceGroups("ruby");
        if (sourceGroupArray2 != null) {
            sourceGroupArray = sourceGroupArray2;
            int n = sourceGroupArray.length;
            for (int i = 0; i < n; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                arrayList.add(sourceGroup.getRootFolder());
            }
        }
        if ((sourceGroupArray = sources.getSourceGroups("generic")) != null) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                arrayList.add(sourceGroup.getRootFolder());
            }
        }
        for (FileObject fileObject : arrayList) {
            File file2 = new File(FileUtil.toFile((FileObject)fileObject), string);
            if (!file2.isFile()) continue;
            try {
                file2 = file2.getCanonicalFile();
                return FileUtil.toFileObject((File)file2);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        FileObject[] fileObjectArray = this.findSources(arrayList);
        String string2 = new File(string).getName();
        if (fileObjectArray != null) {
            for (FileObject fileObject : fileObjectArray) {
                if (!fileObject.getNameExt().equals(string2)) continue;
                return fileObject;
            }
        }
        for (FileObject fileObject : arrayList) {
            FileObject fileObject2 = this.findFile(fileObject, string2);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    private FileObject findFile(FileObject fileObject, String string) {
        if (string.equals(fileObject.getNameExt())) {
            return fileObject;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            FileObject fileObject3 = this.findFile(fileObject2, string);
            if (fileObject3 == null) continue;
            return fileObject3;
        }
        return null;
    }

    protected Lookup getContext() {
        if (this.context == null) {
            this.context = this.project.getLookup();
        }
        return this.context;
    }

    protected FileObject[] findSources(List<FileObject> list) {
        for (FileObject fileObject : list) {
            FileObject[] fileObjectArray = RubyActionProvider.findSelectedFiles(this.getContext(), fileObject, "text/x-ruby", true);
            if (fileObjectArray == null) continue;
            return fileObjectArray;
        }
        return null;
    }
}

