/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RSpecSupport {
    private static final String PLUGIN_SPEC_PATH = "vendor/plugins/rspec/bin/spec";
    private static final String SPEC_OPTS = "spec/spec.opts";
    private static final String NETBEANS_SPEC_OPTS = "spec/spec.opts.netbeans";
    private static final String RSPEC_GEM_NAME = "rspec";
    private final Project project;

    public RSpecSupport(Project project) {
        this.project = project;
    }

    static boolean hasRSpecInstalled(RubyPlatform rubyPlatform) {
        return RSpecSupport.getLatestVersion(rubyPlatform.getGemManager()) != null;
    }

    private static String getLatestVersion(GemManager gemManager) {
        return gemManager == null ? null : gemManager.getLatestVersion(RSPEC_GEM_NAME);
    }

    private String getLatestVersion() {
        return RSpecSupport.getLatestVersion(RubyPlatform.gemManagerFor((Project)this.project));
    }

    public boolean isRSpecInstalled() {
        FileObject fileObject;
        if (this.getLatestVersion() != null) {
            return true;
        }
        return this.project != null && (fileObject = this.project.getProjectDirectory()) != null && fileObject.getFileObject(PLUGIN_SPEC_PATH) != null;
    }

    public static boolean isSpecFile(FileObject fileObject) {
        if (!fileObject.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        return fileObject.getName().endsWith("_spec");
    }

    private String getSpecBinary() {
        File file;
        File file2;
        String string;
        assert (this.isRSpecInstalled());
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)this.project);
        String string2 = this.getLatestVersion();
        if (string2 != null && (string = gemManager.getGemHome()) != null && (file2 = new File(string, "gems")).exists() && (file = new File(file2, "rspec-" + string2 + File.separator + "bin" + File.separator + "spec")).exists()) {
            return file.getAbsolutePath();
        }
        if (this.project != null && (string = this.project.getProjectDirectory()) != null && (file2 = string.getFileObject(PLUGIN_SPEC_PATH)) != null) {
            return FileUtil.toFile((FileObject)file2).getAbsolutePath();
        }
        return null;
    }

    public void runRSpec(File file, FileObject fileObject, String string, FileLocator fileLocator, boolean bl, boolean bl2, String ... stringArray) {
        this.runRSpec(file, fileObject, -1, string, fileLocator, bl, bl2, stringArray);
    }

    public void runRSpec(File file, FileObject fileObject, int n, String string, FileLocator fileLocator, boolean bl, boolean bl2, String ... executionDescriptor) {
        ExecutionDescriptor executionDescriptor2;
        RubyPlatform rubyPlatform;
        FileObject fileObject2 = null;
        if (this.project != null) {
            fileObject2 = this.project.getProjectDirectory();
        }
        if (file == null) {
            rubyPlatform = fileObject2 != null ? fileObject2 : fileObject.getParent();
            file = FileUtil.toFile((FileObject)rubyPlatform);
        }
        if (!(rubyPlatform = RubyPlatform.platformFor((Project)this.project)).isValidRuby(bl)) {
            return;
        }
        String string2 = this.getSpecBinary();
        if (string2 == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileObject2 != null) {
            executionDescriptor2 = fileObject2.getFileObject(NETBEANS_SPEC_OPTS);
            if (executionDescriptor2 == null) {
                executionDescriptor2 = fileObject2.getFileObject(SPEC_OPTS);
            }
            if (executionDescriptor2 != null) {
                arrayList.add("--options");
                arrayList.add(FileUtil.toFile((FileObject)executionDescriptor2).getAbsolutePath());
            }
        }
        if (n != -1) {
            arrayList.add("--line");
            arrayList.add(Integer.toString(n));
        }
        if (executionDescriptor != null && ((String[])executionDescriptor).length > 0) {
            for (String string3 : executionDescriptor) {
                arrayList.add(string3);
            }
        }
        arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        executionDescriptor2 = null;
        String string4 = null;
        if (this.project != null) {
            String string3;
            PropertyEvaluator propertyEvaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class);
            if (propertyEvaluator != null) {
                string4 = propertyEvaluator.getProperty("source.encoding");
            }
            if ((string3 = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class)) instanceof ScriptDescProvider) {
                ScriptDescProvider scriptDescProvider = (ScriptDescProvider)((Object)string3);
                OutputRecognizer[] outputRecognizerArray = new OutputRecognizer[]{new TestNotifier(true, true)};
                String string5 = string2;
                executionDescriptor2 = scriptDescProvider.getScriptDescriptor(file, null, string5, string, this.project.getLookup(), bl2, outputRecognizerArray);
                executionDescriptor2.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
            }
        } else {
            executionDescriptor2 = new ExecutionDescriptor(rubyPlatform, string, file, string2);
            executionDescriptor2.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
            executionDescriptor2.debug(bl2);
            executionDescriptor2.allowInput();
            executionDescriptor2.fileLocator(fileLocator);
            executionDescriptor2.addStandardRecognizers();
            executionDescriptor2.addOutputRecognizer((OutputRecognizer)new TestNotifier(true, true));
        }
        if (executionDescriptor2 != null) {
            new RubyExecution(executionDescriptor2, string4).run();
        }
    }
}

