/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.demo.TextAreaReadline;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class IrbTopComponent
extends TopComponent {
    private boolean finished = true;
    private JTextPane text;
    private static IrbTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/ruby/rubyproject/jruby.png";
    private static final String PREFERRED_ID = "IrbTopComponent";

    private IrbTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(IrbTopComponent.class, (String)"CTL_IrbTopComponent"));
        this.setToolTipText(NbBundle.getMessage(IrbTopComponent.class, (String)"HINT_IrbTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized IrbTopComponent getDefault() {
        if (instance == null) {
            instance = new IrbTopComponent();
        }
        return instance;
    }

    public static synchronized IrbTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return IrbTopComponent.getDefault();
        }
        if (topComponent instanceof IrbTopComponent) {
            return (IrbTopComponent)topComponent;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'IrbTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return IrbTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (this.finished) {
            this.finished = false;
            this.removeAll();
            this.createTerminal();
        }
    }

    public void componentClosed() {
    }

    public void componentActivated() {
        Caret caret;
        if (this.text != null && (caret = this.text.getCaret()) != null) {
            caret.setVisible(true);
        }
    }

    public void componentDeactivated() {
        Caret caret;
        if (this.text != null && (caret = this.text.getCaret()) != null) {
            caret.setVisible(false);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void createTerminal() {
        Serializable serializable;
        this.text = new JTextPane();
        this.text.setMargin(new Insets(8, 8, 8, 8));
        this.text.setCaretColor(new Color(164, 0, 0));
        this.text.setBackground(new Color(242, 242, 242));
        this.text.setForeground(new Color(164, 0, 0));
        Integer n = (Integer)UIManager.get("customFontSize");
        int n2 = n != null ? n : ((serializable = (Font)UIManager.get("controlFont")) != null ? serializable.getSize() : 11);
        this.text.setFont(new Font("Monospaced", 0, n2));
        this.setBorder(BorderFactory.createEmptyBorder());
        serializable = UIManager.getColor("nb.output.selectionBackground");
        if (serializable != null) {
            this.text.setSelectionColor((Color)serializable);
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.text);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add(jScrollPane);
        this.validate();
        final Ruby ruby = IrbTopComponent.getRuntime(this.text);
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                IrbTopComponent.startIRB(ruby);
            }
        });
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                IrbTopComponent.this.finished = true;
                IrbTopComponent.this.text.setEditable(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IrbTopComponent.this.close();
                        IrbTopComponent.this.removeAll();
                        IrbTopComponent.this.text = null;
                    }
                });
            }
        });
        task.schedule(10);
        this.text.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                final int n = mouseEvent.getX();
                final int n2 = mouseEvent.getY();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n3 = IrbTopComponent.this.text.getDocument().getEndPosition().getOffset() - 1;
                        if (n3 == -1) {
                            return;
                        }
                        try {
                            Rectangle rectangle = IrbTopComponent.this.text.modelToView(n3);
                            if (n2 >= rectangle.y) {
                                rectangle.x = n;
                                n3 = IrbTopComponent.this.text.viewToModel(rectangle.getLocation());
                            }
                            IrbTopComponent.this.text.getCaret().setDot(n3);
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
        });
    }

    static Ruby getRuntime(JTextComponent jTextComponent) {
        final TextAreaReadline textAreaReadline = new TextAreaReadline(jTextComponent, " " + NbBundle.getMessage(IrbTopComponent.class, (String)"IrbWelcome") + " \n\n");
        RubyInstallation.getInstance().setJRubyLoadPaths();
        final PipedInputStream pipedInputStream = new PipedInputStream();
        RubyInstanceConfig rubyInstanceConfig = new RubyInstanceConfig(){
            {
                this.setInput(pipedInputStream);
                this.setOutput(new PrintStream(textAreaReadline.getOutputStream()));
                this.setError(new PrintStream(textAreaReadline.getOutputStream()));
                this.setObjectSpaceEnabled(false);
            }
        };
        Ruby ruby = Ruby.newInstance((RubyInstanceConfig)rubyInstanceConfig);
        ruby.getGlobalVariables().defineReadonly("$$", (IAccessor)new ValueAccessor((IRubyObject)ruby.newFixnum(System.identityHashCode(ruby))));
        ruby.getLoadService().init(new ArrayList());
        textAreaReadline.hookIntoRuntime(ruby);
        return ruby;
    }

    private static void startIRB(Ruby ruby) {
        ruby.evalScriptlet("require 'irb'; require 'irb/completion'; IRB.start");
    }

    public void requestFocus() {
        if (this.text != null) {
            this.text.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.text != null) {
            return this.text.requestFocusInWindow();
        }
        return false;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return IrbTopComponent.getDefault();
        }
    }
}

