/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationWizardModel {
    private Set<UpdateElement> primaryElements;
    private Set<UpdateElement> requiredElements = null;
    private Set<UpdateElement> customHandledElements = null;
    private Set<UpdateElement> allElements = null;
    private HashMap<UpdateElement, Collection<UpdateElement>> required2primary = new HashMap();
    private JButton originalCancel = null;
    private JButton originalNext = null;
    private JButton originalFinish = null;
    private boolean reconized = false;
    static Dimension PREFFERED_DIMENSION = new Dimension(530, 400);
    private static int MAX_TO_REPORT = 3;
    static String MORE_BROKEN_PLUGINS = "OperationWizardModel_MoreBrokenPlugins";
    private TreeMap<String, Set<UpdateElement>> dep2plugins = null;

    abstract OperationType getOperation();

    abstract OperationContainer getBaseContainer();

    abstract OperationContainer<OperationSupport> getCustomHandledContainer();

    public Set<UpdateElement> getPrimaryUpdateElements() {
        if (this.primaryElements == null) {
            this.primaryElements = new HashSet<UpdateElement>();
            for (OperationContainer.OperationInfo operationInfo : this.getBaseInfos()) {
                this.primaryElements.add(operationInfo.getUpdateElement());
            }
        }
        return this.primaryElements;
    }

    public boolean hasRequiredUpdateElements() {
        return !this.getRequiredUpdateElements().isEmpty();
    }

    public Set<UpdateElement> getRequiredUpdateElements() {
        if (this.requiredElements == null) {
            this.requiredElements = new HashSet<UpdateElement>();
            for (OperationContainer.OperationInfo object : this.getBaseInfos()) {
                Set set = object.getRequiredElements();
                for (UpdateElement updateElement : set) {
                    if (this.required2primary.get(updateElement) == null) {
                        this.required2primary.put(updateElement, new HashSet());
                    }
                    this.required2primary.get(updateElement).add(object.getUpdateElement());
                }
                this.requiredElements.addAll(set);
            }
            HashSet hashSet = new HashSet();
            for (UpdateElement updateElement : this.requiredElements) {
                if (updateElement == null || updateElement.getUpdateUnit() == null || !updateElement.getUpdateUnit().isPending()) continue;
                hashSet.add(updateElement);
            }
            if (!hashSet.isEmpty()) {
                Logger.getLogger(OperationWizardModel.class.getName()).log(Level.INFO, "Required UpdateElements " + hashSet + " cannot be in pending state.");
                this.requiredElements.removeAll(hashSet);
            }
            this.addRequiredElements(this.requiredElements);
            this.requiredElements.removeAll(this.getPrimaryUpdateElements());
        }
        return this.requiredElements;
    }

    public boolean hasBrokenDependencies() {
        return !this.getBrokenDependency2Plugins().isEmpty();
    }

    public boolean hasCustomComponents() {
        return !this.getCustomHandledContainer().listAll().isEmpty();
    }

    public boolean hasStandardComponents() {
        return !this.getBaseContainer().listAll().isEmpty();
    }

    public Set<UpdateElement> getCustomHandledComponents() {
        if (this.customHandledElements == null) {
            this.customHandledElements = new HashSet<UpdateElement>();
            for (OperationContainer.OperationInfo<OperationSupport> operationInfo : this.getCustomHandledInfos()) {
                this.customHandledElements.add(operationInfo.getUpdateElement());
                this.customHandledElements.addAll(operationInfo.getRequiredElements());
            }
        }
        return this.customHandledElements;
    }

    private List<OperationContainer.OperationInfo<OperationSupport>> getCustomHandledInfos() {
        return this.getCustomHandledContainer().listAll();
    }

    private List<OperationContainer.OperationInfo> getBaseInfos() {
        return this.getBaseContainer().listAll();
    }

    public SortedMap<String, Set<UpdateElement>> getBrokenDependency2Plugins() {
        if (this.dep2plugins != null) {
            return this.dep2plugins;
        }
        this.dep2plugins = new TreeMap();
        for (OperationContainer.OperationInfo operationInfo : this.getBaseInfos()) {
            Set set = operationInfo.getBrokenDependencies();
            if (set.isEmpty()) continue;
            for (String string : set) {
                if (string.toLowerCase().startsWith("package")) {
                    string = "package";
                }
                if (this.dep2plugins.get(string) == null) {
                    this.dep2plugins.put(string, new HashSet());
                }
                this.dep2plugins.get(string).add(operationInfo.getUpdateElement());
            }
            if (this.dep2plugins.keySet().size() < MAX_TO_REPORT) continue;
            this.dep2plugins.put(MORE_BROKEN_PLUGINS, null);
            break;
        }
        return this.dep2plugins;
    }

    public Collection<UpdateElement> findPrimaryPlugins(UpdateElement updateElement) {
        Collection<UpdateElement> collection = new HashSet<UpdateElement>(Collections.singleton(updateElement));
        if (this.required2primary.containsKey(updateElement)) {
            collection = this.required2primary.get(updateElement);
        }
        return collection;
    }

    public Set<UpdateElement> getAllUpdateElements() {
        if (this.allElements == null) {
            this.allElements = new HashSet<UpdateElement>(this.getPrimaryUpdateElements());
            this.allElements.addAll(this.getRequiredUpdateElements());
            assert (this.allElements.size() == this.getPrimaryUpdateElements().size() + this.getRequiredUpdateElements().size()) : "Primary [" + this.getPrimaryUpdateElements().size() + "] plus " + "Required [" + this.getRequiredUpdateElements().size() + "] is All [" + this.allElements.size() + "] ";
        }
        return this.allElements;
    }

    public static Set<UpdateElement> getVisibleUpdateElements(Set<UpdateElement> set, boolean bl, OperationType operationType) {
        if (Utilities.modulesOnly() || OperationType.LOCAL_DOWNLOAD == operationType) {
            return set;
        }
        Set<UpdateElement> set2 = new HashSet<UpdateElement>();
        for (UpdateElement updateElement : set) {
            if (UpdateManager.TYPE.KIT_MODULE != updateElement.getUpdateUnit().getType()) continue;
            set2.add(updateElement);
        }
        if (set2.isEmpty() && !bl) {
            set2 = set;
        }
        return set2;
    }

    public void modifyOptionsForDoClose(WizardDescriptor wizardDescriptor) {
        this.modifyOptionsForDoClose(wizardDescriptor, false);
    }

    public void modifyOptionsForFailed(final WizardDescriptor wizardDescriptor) {
        this.recognizeButtons(wizardDescriptor);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                wizardDescriptor.setOptions((Object[])new JButton[]{OperationWizardModel.this.getOriginalCancel(wizardDescriptor)});
            }
        });
    }

    public void modifyOptionsForDoClose(final WizardDescriptor wizardDescriptor, final boolean bl) {
        this.recognizeButtons(wizardDescriptor);
        final JButton jButton = this.getOriginalFinish(wizardDescriptor);
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)this.getBundle("InstallUnitWizardModel_Buttons_Close"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray;
                if (bl) {
                    JButton[] jButtonArray = new JButton[2];
                    jButtonArray[0] = jButton;
                    objectArray = jButtonArray;
                    jButtonArray[1] = OperationWizardModel.this.getOriginalCancel(wizardDescriptor);
                } else {
                    Object[] objectArray2 = new JButton[1];
                    objectArray = objectArray2;
                    objectArray2[0] = jButton;
                }
                wizardDescriptor.setOptions(objectArray);
            }
        });
    }

    public void modifyOptionsForStartWizard(WizardDescriptor wizardDescriptor) {
        this.recognizeButtons(wizardDescriptor);
        this.removeFinish(wizardDescriptor);
        Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)NbBundle.getMessage(InstallUnitWizardModel.class, (String)"InstallUnitWizardModel_Buttons_MnemonicNext", (Object)this.getBundle("InstallUnitWizardModel_Buttons_Next")));
    }

    public void modifyOptionsForContinue(final WizardDescriptor wizardDescriptor, boolean bl) {
        if (bl) {
            this.recognizeButtons(wizardDescriptor);
            final JButton jButton = this.getOriginalFinish(wizardDescriptor);
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)this.getBundle("InstallUnitWizardModel_Buttons_Close"));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    wizardDescriptor.setOptions((Object[])new JButton[]{jButton});
                }
            });
        } else {
            this.recognizeButtons(wizardDescriptor);
            this.removeFinish(wizardDescriptor);
            Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)NbBundle.getMessage(InstallUnitWizardModel.class, (String)"InstallUnitWizardModel_Buttons_MnemonicNext", (Object)this.getBundle("InstallUnitWizardModel_Buttons_Next")));
        }
    }

    public void modifyOptionsForDoOperation(WizardDescriptor wizardDescriptor) {
        this.recognizeButtons(wizardDescriptor);
        this.removeFinish(wizardDescriptor);
        switch (this.getOperation()) {
            case LOCAL_DOWNLOAD: {
                if (Containers.forUpdateNbms().listAll().isEmpty()) {
                    Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("InstallUnitWizardModel_Buttons_Install"));
                    break;
                }
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("InstallUnitWizardModel_Buttons_Update"));
                break;
            }
            case INSTALL: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("InstallUnitWizardModel_Buttons_Install"));
                break;
            }
            case UPDATE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("InstallUnitWizardModel_Buttons_Update"));
                break;
            }
            case UNINSTALL: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("UninstallUnitWizardModel_Buttons_Uninstall"));
                break;
            }
            case ENABLE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOn"));
                break;
            }
            case DISABLE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wizardDescriptor), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOff"));
                break;
            }
            default: {
                assert (false) : "Unknown operationType " + (Object)((Object)this.getOperation());
                break;
            }
        }
    }

    public JButton getCancelButton(WizardDescriptor wizardDescriptor) {
        return this.getOriginalCancel(wizardDescriptor);
    }

    public void modifyOptionsForDisabledCancel(final WizardDescriptor wizardDescriptor) {
        this.recognizeButtons(wizardDescriptor);
        Object[] objectArray = wizardDescriptor.getOptions();
        final ArrayList<JButton> arrayList = new ArrayList<JButton>();
        List<Object> list = Arrays.asList(objectArray);
        for (Object object : list) {
            assert (object instanceof JButton) : object + " instanceof JButton";
            if (!(object instanceof JButton)) continue;
            JButton jButton = (JButton)object;
            if (jButton.equals(this.getOriginalCancel(wizardDescriptor))) {
                JButton jButton2 = new JButton(jButton.getText());
                jButton2.setEnabled(false);
                arrayList.add(jButton2);
                continue;
            }
            arrayList.add(jButton);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                wizardDescriptor.setOptions(arrayList.toArray());
            }
        });
    }

    public void doCleanup(boolean bl) throws OperationException {
        this.getBaseContainer().removeAll();
        this.getCustomHandledContainer().removeAll();
    }

    private void recognizeButtons(WizardDescriptor wizardDescriptor) {
        if (!this.reconized) {
            Object[] objectArray = wizardDescriptor.getOptions();
            assert (objectArray != null) : "options: " + objectArray;
            assert (objectArray.length >= 4) : Arrays.asList(objectArray) + " has lenght 4";
            assert (objectArray[1] instanceof JButton) : objectArray[1] + " instanceof JButton";
            this.originalNext = (JButton)objectArray[1];
            assert (objectArray[2] instanceof JButton) : objectArray[2] + " instanceof JButton";
            this.originalFinish = (JButton)objectArray[2];
            assert (objectArray[3] instanceof JButton) : objectArray[3] + " instanceof JButton";
            this.originalCancel = (JButton)objectArray[3];
            this.reconized = true;
        }
    }

    private JButton getOriginalNext(WizardDescriptor wizardDescriptor) {
        return this.originalNext;
    }

    private JButton getOriginalCancel(WizardDescriptor wizardDescriptor) {
        return this.originalCancel;
    }

    private JButton getOriginalFinish(WizardDescriptor wizardDescriptor) {
        return this.originalFinish;
    }

    private void removeFinish(final WizardDescriptor wizardDescriptor) {
        Object[] objectArray = wizardDescriptor.getOptions();
        final ArrayList<JButton> arrayList = new ArrayList<JButton>();
        List<Object> list = Arrays.asList(objectArray);
        for (Object object : list) {
            JButton jButton;
            assert (object instanceof JButton) : object + " instanceof JButton";
            if (!(object instanceof JButton) || (jButton = (JButton)object).equals(this.originalFinish)) continue;
            arrayList.add(jButton);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                wizardDescriptor.setOptions(arrayList.toArray());
            }
        });
    }

    private void addRequiredElements(Set<UpdateElement> set) {
        for (UpdateElement updateElement : set) {
            if (updateElement == null || updateElement.getUpdateUnit() == null) {
                Logger.getLogger(OperationWizardModel.class.getName()).log(Level.INFO, "UpdateElement " + updateElement + " cannot be null" + (updateElement == null ? "" : " or UpdateUnit " + updateElement.getUpdateUnit() + " cannot be null"));
                continue;
            }
            if (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == updateElement.getUpdateUnit().getType()) {
                this.getCustomHandledContainer().add(updateElement);
                continue;
            }
            this.getBaseContainer().add(updateElement);
        }
    }

    private String getBundle(String string) {
        return NbBundle.getMessage(InstallUnitWizardModel.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        UPDATE,
        REVERT,
        ENABLE,
        DISABLE,
        LOCAL_DOWNLOAD;

    }
}

