/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

public class BalloonManager {
    private static Balloon currentBalloon;
    private static JLayeredPane currentPane;
    private static ComponentListener listener;
    private static WindowStateListener windowListener;
    private static Window ownerWindow;

    public static synchronized void show(JComponent jComponent, JComponent jComponent2, Action action, int n) {
        assert (null != jComponent);
        assert (null != jComponent2);
        BalloonManager.dismiss();
        currentBalloon = new Balloon(jComponent2, action, n);
        currentPane = JLayeredPane.getLayeredPaneAbove(jComponent);
        listener = new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }
        };
        windowListener = new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                BalloonManager.dismiss();
            }
        };
        ownerWindow = SwingUtilities.getWindowAncestor(jComponent);
        if (null != ownerWindow) {
            ownerWindow.addWindowStateListener(windowListener);
        }
        currentPane.addComponentListener(listener);
        BalloonManager.configureBalloon(currentBalloon, currentPane, jComponent);
        currentPane.add((Component)currentBalloon, new Integer(JLayeredPane.POPUP_LAYER - 1));
    }

    public static synchronized void dismiss() {
        if (null != currentBalloon) {
            currentBalloon.setVisible(false);
            currentBalloon.stopDismissTimer();
            currentPane.remove(currentBalloon);
            currentPane.repaint();
            currentPane.removeComponentListener(listener);
            if (null != ownerWindow) {
                ownerWindow.removeWindowStateListener(windowListener);
            }
            currentBalloon = null;
            currentPane = null;
            listener = null;
            ownerWindow = null;
            windowListener = null;
        }
    }

    public static synchronized void dismissSlowly() {
        if (null != currentBalloon) {
            if (currentBalloon.timeoutMillis > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        currentBalloon.startDismissTimer();
                    }
                });
            } else {
                BalloonManager.dismiss();
            }
        }
    }

    public static synchronized void stopDismissSlowly() {
        if (null != currentBalloon && currentBalloon.timeoutMillis > 0) {
            currentBalloon.timeoutMillis = ToolTipManager.sharedInstance().getDismissDelay();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    currentBalloon.stopDismissTimer();
                }
            });
        }
    }

    private static void configureBalloon(Balloon balloon, JLayeredPane jLayeredPane, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        rectangle = SwingUtilities.convertRectangle(jComponent.getParent(), rectangle, jLayeredPane);
        int n = jLayeredPane.getWidth();
        int n2 = jLayeredPane.getHeight();
        Dimension dimension = balloon.getPreferredSize();
        dimension.height += 15;
        if (rectangle.x + rectangle.width + dimension.width < n && rectangle.y + rectangle.height + dimension.height + 15 < n2) {
            balloon.setArrowLocation(14);
            balloon.setBounds(rectangle.x + rectangle.width - 7, rectangle.y + rectangle.height, dimension.width + 15, dimension.height);
        } else if (rectangle.x + rectangle.width + dimension.width < n && rectangle.y - dimension.height - 15 > 0) {
            balloon.setArrowLocation(12);
            balloon.setBounds(rectangle.x + rectangle.width - 7, rectangle.y - dimension.height, dimension.width + 15, dimension.height);
        } else if (rectangle.x - dimension.width > 0 && rectangle.y + rectangle.height + dimension.height + 15 < n2) {
            balloon.setArrowLocation(16);
            balloon.setBounds(rectangle.x - dimension.width + 7, rectangle.y + rectangle.height, dimension.width + 15, dimension.height);
        } else {
            balloon.setArrowLocation(18);
            balloon.setBounds(rectangle.x - dimension.width, rectangle.y - dimension.height, dimension.width + 15, dimension.height);
        }
    }

    private static class DismissButton
    extends JButton {
        public DismissButton() {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/dismiss_enabled.png");
            this.setIcon(new ImageIcon(image));
            image = ImageUtilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/dismiss_rollover.png");
            this.setRolloverIcon(new ImageIcon(image));
            image = ImageUtilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/dismiss_pressed.png");
            this.setPressedIcon(new ImageIcon(image));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
        }

        public void paint(Graphics graphics) {
            Icon icon = null;
            icon = this.getModel().isArmed() && this.getModel().isPressed() ? this.getPressedIcon() : (this.getModel().isRollover() ? this.getRolloverIcon() : this.getIcon());
            icon.paintIcon(this, graphics, 0, 0);
        }
    }

    private static class Balloon
    extends JPanel {
        private static final int Y_OFFSET = 8;
        private static final int ARC = 15;
        private static final int SHADOW_SIZE = 3;
        private JComponent content;
        private Action defaultAction;
        private JButton btnDismiss;
        private int arrowLocation = 14;
        private float currentAlpha = 1.0f;
        private Timer dismissTimer;
        private int timeoutMillis;
        private boolean isMouseOverEffect = false;
        private static final float ALPHA_DECREMENT = 0.03f;
        private static final int DISMISS_REPAINT_REPEAT = 100;
        private static final Color mouseOverGradientStartColor = new Color(224, 224, 185);
        private static final Color mouseOverGradientFinishColor = new Color(255, 255, 241);
        private static final Color defaultGradientStartColor = new Color(225, 225, 225);
        private static final Color defaultGradientFinishColor = new Color(255, 255, 255);

        public Balloon(final JComponent jComponent, final Action action, int n) {
            super(new GridBagLayout());
            this.content = jComponent;
            this.defaultAction = action;
            this.timeoutMillis = n;
            jComponent.setOpaque(false);
            this.btnDismiss = new DismissButton();
            this.btnDismiss.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BalloonManager.dismiss();
                }
            });
            this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.btnDismiss, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 0, 0, 7), 0, 0));
            this.setOpaque(false);
            if (null != action) {
                jComponent.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        BalloonManager.dismiss();
                        action.actionPerformed(new ActionEvent(Balloon.this, 0, "", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        jComponent.setCursor(Cursor.getPredefinedCursor(12));
                        Balloon.this.stopDismissTimer();
                        Balloon.this.repaint();
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        jComponent.setCursor(Cursor.getDefaultCursor());
                        if (Balloon.this.timeoutMillis > 0) {
                            Balloon.this.startDismissTimer();
                        }
                    }
                });
            }
            if (n > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Balloon.this.startDismissTimer();
                    }
                });
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    Balloon.this.isMouseOverEffect = true;
                    Balloon.this.stopDismissTimer();
                    Balloon.this.repaint();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    Balloon.this.isMouseOverEffect = false;
                    Balloon.this.repaint();
                }
            };
            this.addMouseListener(mouseAdapter);
            jComponent.addMouseListener(mouseAdapter);
            this.btnDismiss.addMouseListener(mouseAdapter);
        }

        synchronized void startDismissTimer() {
            this.stopDismissTimer();
            this.currentAlpha = 1.0f;
            this.dismissTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Balloon.this.currentAlpha -= 0.03f;
                    if (Balloon.this.currentAlpha <= 0.03f) {
                        Balloon.this.stopDismissTimer();
                        BalloonManager.dismiss();
                    }
                    Balloon.this.repaint();
                }
            });
            this.dismissTimer.setInitialDelay(this.timeoutMillis);
            this.dismissTimer.start();
        }

        synchronized void stopDismissTimer() {
            if (null != this.dismissTimer) {
                this.dismissTimer.stop();
                this.dismissTimer = null;
                this.currentAlpha = 1.0f;
            }
        }

        void setArrowLocation(int n) {
            this.arrowLocation = n;
            if (n == 12 || n == 18) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, this.btnDismiss.getWidth()));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, this.btnDismiss.getWidth()));
            }
        }

        private Shape getMask(int n, int n2) {
            --n;
            n -= 3;
            GeneralPath generalPath = new GeneralPath();
            Area area = null;
            switch (this.arrowLocation) {
                case 14: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 8.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(7.0f, 0.0f);
                    generalPath.lineTo(7.0f, 8.0f);
                    generalPath.lineTo(15.0f, 8.0f);
                    break;
                }
                case 12: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 3.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(7.0f, n2 - 1);
                    generalPath.lineTo(7.0f, n2 - 1 - 8);
                    generalPath.lineTo(15.0f, n2 - 1 - 8);
                    break;
                }
                case 16: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 8.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(n - 7, 0.0f);
                    generalPath.lineTo(n - 7, 8.0f);
                    generalPath.lineTo(n - 7 - 8, 8.0f);
                    break;
                }
                case 18: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 3.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(n - 7, n2 - 1);
                    generalPath.lineTo(n - 7 - 8, n2 - 1 - 8);
                    generalPath.lineTo(n - 7, n2 - 1 - 8);
                }
            }
            generalPath.closePath();
            area.add(new Area(generalPath));
            return area;
        }

        private Shape getShadowMask(Shape shape) {
            Area area = new Area(shape);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(3.0, 3.0);
            area.transform(affineTransform);
            area.subtract(new Area(shape));
            return area;
        }

        protected void paintBorder(Graphics graphics) {
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite composite = graphics2D.getComposite();
            Shape shape = this.getMask(this.getWidth(), this.getHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f * this.currentAlpha));
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.getShadowMask(shape));
            graphics2D.setColor(UIManager.getColor("ToolTip.background"));
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            Point point = shape.getBounds().getLocation();
            Point2D.Double double_ = new Point2D.Double(((Point2D)point).getX(), ((Point2D)point).getY() + shape.getBounds().getHeight());
            if (this.isMouseOverEffect) {
                graphics2D.setPaint(new GradientPaint(double_, mouseOverGradientStartColor, point, mouseOverGradientFinishColor));
            } else {
                graphics2D.setPaint(new GradientPaint(double_, defaultGradientStartColor, point, defaultGradientFinishColor));
            }
            graphics2D.fill(shape);
            graphics2D.setColor(Color.black);
            graphics2D.draw(shape);
            graphics2D.setComposite(composite);
        }

        protected void paintChildren(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            super.paintChildren(graphics);
            graphics2D.setComposite(composite);
        }
    }
}

