/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.libraries.FiberLibrary;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 50;
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private IRubyObject errorInfo;
    private RubyModule[] parentStack = new RubyModule[50];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[50];
    private int frameIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[50];
    private int scopeIndex = -1;
    private RubyKernel.CatchTarget[] catchStack = new RubyKernel.CatchTarget[50];
    private int catchIndex = -1;
    private String file = "";
    private int line = 0;
    private int rubyFrameDelta = 0;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    int calls = 0;

    public static synchronized ThreadContext newContext(Ruby ruby) {
        ThreadContext threadContext = new ThreadContext(ruby);
        return threadContext;
    }

    private ThreadContext(Ruby ruby) {
        this.runtime = ruby;
        this.errorInfo = ruby.getNil();
        LocalStaticScope localStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(localStaticScope, null));
        for (int i = 0; i < this.frameStack.length; ++i) {
            this.frameStack[i] = new Frame();
        }
    }

    protected void finalize() throws Throwable {
        this.thread.dispose();
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject iRubyObject) {
        this.errorInfo = iRubyObject;
        return iRubyObject;
    }

    public JumpException.ReturnJump returnJump(IRubyObject iRubyObject) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), iRubyObject);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject iRubyObject) {
        this.lastExitStatus = iRubyObject;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int n = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[n], n);
    }

    private Frame[] fillNewFrameStack(Frame[] frameArray, int n) {
        System.arraycopy(this.frameStack, 0, frameArray, 0, this.frameStack.length);
        for (int i = this.frameStack.length; i < n; ++i) {
            frameArray[i] = new Frame();
        }
        return frameArray;
    }

    private void expandParentsIfNecessary() {
        int n = this.parentStack.length * 2;
        RubyModule[] rubyModuleArray = new RubyModule[n];
        System.arraycopy(this.parentStack, 0, rubyModuleArray, 0, this.parentStack.length);
        this.parentStack = rubyModuleArray;
    }

    public void pushScope(DynamicScope dynamicScope) {
        this.scopeStack[++this.scopeIndex] = dynamicScope;
        if (this.scopeIndex + 1 == this.scopeStack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int n = this.scopeStack.length * 2;
        DynamicScope[] dynamicScopeArray = new DynamicScope[n];
        System.arraycopy(this.scopeStack, 0, dynamicScopeArray, 0, this.scopeStack.length);
        this.scopeStack = dynamicScopeArray;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread rubyThread) {
        this.thread = rubyThread;
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        int n = this.catchStack.length * 2;
        RubyKernel.CatchTarget[] catchTargetArray = new RubyKernel.CatchTarget[n];
        System.arraycopy(this.catchStack, 0, catchTargetArray, 0, this.catchStack.length);
        this.catchStack = catchTargetArray;
    }

    public void pushCatch(RubyKernel.CatchTarget catchTarget) {
        this.catchStack[++this.catchIndex] = catchTarget;
        if (this.catchIndex + 1 == this.catchStack.length) {
            this.expandCatchIfNecessary();
        }
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyKernel.CatchTarget[] getActiveCatches() {
        if (this.catchIndex < 0) {
            return new RubyKernel.CatchTarget[0];
        }
        RubyKernel.CatchTarget[] catchTargetArray = new RubyKernel.CatchTarget[this.catchIndex + 1];
        System.arraycopy(this.catchStack, 0, catchTargetArray, 0, this.catchIndex + 1);
        return catchTargetArray;
    }

    private void pushFrameCopy() {
        Frame frame = this.getCurrentFrame();
        this.frameStack[++this.frameIndex].updateFrame(frame);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrameCopy(Frame frame) {
        this.frameStack[++this.frameIndex].updateFrame(frame);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
        return this.frameStack[this.frameIndex];
    }

    private Frame pushFrame(Frame frame) {
        this.frameStack[++this.frameIndex] = frame;
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule rubyModule, String string, IRubyObject iRubyObject, Block block, JumpTarget jumpTarget) {
        this.frameStack[++this.frameIndex].updateFrame(rubyModule, iRubyObject, string, block, this.file, this.line, jumpTarget);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushBacktraceFrame(String string) {
        this.pushFrame(string);
    }

    private void pushFrame(String string) {
        this.frameStack[++this.frameIndex].updateFrame(string, this.file, this.line);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushFrame() {
        this.frameStack[++this.frameIndex].updateFrame(this.file, this.line);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex];
        --this.frameIndex;
        this.setFile(frame.getFile());
        this.setLine(frame.getLine());
        frame.clear();
    }

    private void popFrameReal(Frame frame) {
        Frame frame2 = this.frameStack[this.frameIndex];
        this.frameStack[this.frameIndex] = frame;
        --this.frameIndex;
        this.setFile(frame2.getFile());
        this.setLine(frame2.getLine());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int n) {
        this.rubyFrameDelta = n;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
        return this.frameStack[this.frameIndex + 1];
    }

    public Frame getPreviousFrame() {
        return this.frameIndex < 1 ? null : this.frameStack[this.frameIndex - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public JumpTarget getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    @Deprecated
    public void setFrameJumpTarget(JumpTarget jumpTarget) {
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setFileAndLine(String string, int n) {
        this.file = string;
        this.line = n;
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents(this);
    }

    public void callThreadPoll() {
        if ((this.calls++ & 0xFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public void trace(int n, String string, RubyModule rubyModule) {
        this.runtime.callEventHooks(this, n, this.file, this.line, string, rubyModule);
    }

    public void pushRubyClass(RubyModule rubyModule) {
        this.parentStack[++this.parentIndex] = rubyModule;
        if (this.parentIndex + 1 == this.parentStack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        RubyModule rubyModule = this.parentStack[this.parentIndex];
        this.parentStack[this.parentIndex--] = null;
        return rubyModule;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule rubyModule = this.parentStack[this.parentIndex];
        return rubyModule.getNonIncludedClass();
    }

    public RubyModule getBindingRubyClass() {
        RubyModule rubyModule = null;
        rubyModule = this.parentIndex == 0 ? this.parentStack[this.parentIndex] : this.parentStack[this.parentIndex - 1];
        return rubyModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String string) {
        for (StaticScope staticScope = this.getCurrentScope().getStaticScope(); staticScope != null; staticScope = staticScope.getPreviousCRefScope()) {
            RubyModule rubyModule = staticScope.getModule();
            IRubyObject iRubyObject = rubyModule.fastFetchConstant(string);
            if (iRubyObject == null) continue;
            if (iRubyObject != RubyObject.UNDEF) {
                return true;
            }
            return this.runtime.getLoadService().autoloadFor(rubyModule.getName() + "::" + string) != null;
        }
        return this.getCurrentScope().getStaticScope().getModule().fastIsConstantDefined(string);
    }

    public IRubyObject getConstant(String string) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, string, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String string, IRubyObject iRubyObject) {
        RubyModule rubyModule = this.getCurrentScope().getStaticScope().getModule();
        if (rubyModule != null) {
            rubyModule.fastSetConstant(string, iRubyObject);
            return iRubyObject;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject instanceof RubyModule)) {
            throw this.runtime.newTypeError(iRubyObject.toString() + " is not a class/module");
        }
        RubyModule rubyModule = (RubyModule)iRubyObject;
        rubyModule.fastSetConstant(string, iRubyObject2);
        return iRubyObject2;
    }

    public IRubyObject setConstantInObject(String string, IRubyObject iRubyObject) {
        this.runtime.getObject().fastSetConstant(string, iRubyObject);
        return iRubyObject;
    }

    private static void addBackTraceElement(RubyArray rubyArray, Frame frame, Frame frame2) {
        if (frame != frame2 && frame.getName() != null && frame.getName().equals(frame2.getName()) && frame.getFile().equals(frame2.getFile()) && frame.getLine() == frame2.getLine()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append(frame.getFile()).append(':').append(frame.getLine() + 1);
        if (frame2.getName() != null) {
            stringBuilder.append(":in `").append(frame2.getName()).append('\'');
        }
        rubyArray.append(rubyArray.getRuntime().newString(stringBuilder.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby ruby, Frame[] frameArray) {
        return ThreadContext.createBacktraceFromFrames(ruby, frameArray, true);
    }

    public static IRubyObject createBacktraceFromFrames(Ruby ruby, Frame[] frameArray, boolean bl) {
        RubyArray rubyArray = ruby.newArray();
        if (frameArray == null || frameArray.length <= 0) {
            return rubyArray;
        }
        int n = frameArray.length;
        for (int i = n - 1; i > 0; --i) {
            Frame frame = frameArray[i];
            if (bl && frame.isBindingFrame()) break;
            ThreadContext.addBackTraceElement(rubyArray, frame, frameArray[i - 1]);
        }
        return rubyArray;
    }

    public Frame[] createBacktrace(int n, boolean bl) {
        Frame[] frameArray;
        int n2 = this.frameIndex - n + 1;
        if (n2 <= 0) {
            return null;
        }
        if (bl) {
            frameArray = new Frame[n2 + 1];
            frameArray[n2] = this.frameStack[this.frameIndex];
        } else {
            frameArray = new Frame[n2];
        }
        System.arraycopy(this.frameStack, 0, frameArray, 0, n2);
        return frameArray;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule rubyModule, String[] stringArray) {
        this.pushRubyClass(rubyModule);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(rubyModule);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        LocalStaticScope localStaticScope = new LocalStaticScope(this.getCurrentScope().getStaticScope(), stringArray);
        localStaticScope.setModule(rubyModule);
        this.pushScope(new ManyVarsDynamicScope(localStaticScope, null));
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule rubyModule) {
        this.pushRubyClass(rubyModule);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(rubyModule);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] stringArray) {
        LocalStaticScope localStaticScope = new LocalStaticScope(null);
        localStaticScope.setVariables(stringArray);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule rubyModule, String string, IRubyObject iRubyObject, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
        RubyModule rubyModule2 = staticScope.getModule();
        if (rubyModule2 == null) {
            rubyModule2 = rubyModule;
        }
        this.pushCallFrame(rubyModule, string, iRubyObject, block, jumpTarget);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(rubyModule2);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule rubyModule, String string, IRubyObject iRubyObject, Block block, JumpTarget jumpTarget) {
        this.pushRubyClass(rubyModule);
        this.pushCallFrame(rubyModule, string, iRubyObject, block, jumpTarget);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule rubyModule, StaticScope staticScope) {
        RubyModule rubyModule2 = staticScope.getModule();
        if (rubyModule2 == null) {
            rubyModule2 = rubyModule;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(rubyModule2);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String string, RubyModule rubyModule, StaticScope staticScope) {
        this.preMethodScopeOnly(rubyModule, staticScope);
        this.pushBacktraceFrame(string);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
        this.popFrame();
    }

    public void preMethodBacktraceOnly(String string) {
        this.pushBacktraceFrame(string);
    }

    public void postMethodBacktraceOnly() {
        this.popFrame();
    }

    public void prepareTopLevel(RubyClass rubyClass, IRubyObject iRubyObject) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(rubyClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(iRubyObject);
        this.getCurrentScope().getStaticScope().setModule(rubyClass);
    }

    public void preNodeEval(RubyModule rubyModule, IRubyObject iRubyObject, String string) {
        this.pushRubyClass(rubyModule);
        this.pushCallFrame(null, null, iRubyObject, Block.NULL_BLOCK, null);
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void preNodeEval(RubyModule rubyModule, IRubyObject iRubyObject) {
        this.pushRubyClass(rubyModule);
        this.pushCallFrame(null, null, iRubyObject, Block.NULL_BLOCK, null);
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule rubyModule, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(rubyModule);
        DynamicScope dynamicScope = this.getCurrentScope();
        BlockStaticScope blockStaticScope = new BlockStaticScope(dynamicScope.getStaticScope());
        blockStaticScope.setModule(rubyModule);
        this.pushScope(DynamicScope.newDynamicScope(blockStaticScope, dynamicScope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block, frame.getJumpTarget());
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame frame) {
        this.pushFrame(frame);
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = binding.getFrame();
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        this.pushFrame(frame2);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope());
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preYieldSpecificBlock(Binding binding, StaticScope staticScope, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = this.pushFrame(binding.getFrame());
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        frame2.setVisibility(binding.getVisibility());
        this.pushScope(DynamicScope.newDynamicScope(staticScope, binding.getDynamicScope()));
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preYieldLightBlock(Binding binding, DynamicScope dynamicScope, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = this.pushFrame(binding.getFrame());
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        frame2.setVisibility(binding.getVisibility());
        this.pushScope(dynamicScope);
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preYieldNoScope(Binding binding, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = this.pushFrame(binding.getFrame());
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        frame2.setVisibility(binding.getVisibility());
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preEvalWithBinding(Binding binding) {
        Frame frame = this.getNextFrame();
        Frame frame2 = binding.getFrame();
        frame2.setIsBindingFrame(true);
        this.pushFrame(frame2);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushRubyClass(binding.getKlass());
        return frame;
    }

    public void postEvalWithBinding(Binding binding, Frame frame) {
        binding.getFrame().setIsBindingFrame(false);
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void postYield(Binding binding, Frame frame) {
        this.popScope();
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding, Frame frame) {
        this.popScope();
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame frame) {
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope dynamicScope) {
        this.pushScope(dynamicScope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean bl) {
        this.isWithinTrace = bl;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean bl) {
        this.isWithinDefined = bl;
    }
}

