/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class MethodBlock
extends BlockBody {
    private final RubyMethod method;
    private final Callback callback;
    private final Arity arity;
    private final StaticScope staticScope;

    public static Block createMethodBlock(ThreadContext threadContext, DynamicScope dynamicScope, Callback callback, RubyMethod rubyMethod, IRubyObject iRubyObject) {
        Binding binding = new Binding(iRubyObject, threadContext.getCurrentFrame().duplicate(), threadContext.getCurrentFrame().getVisibility(), threadContext.getRubyClass(), dynamicScope);
        MethodBlock methodBlock = new MethodBlock(callback, rubyMethod, dynamicScope.getStaticScope());
        return new Block(methodBlock, binding);
    }

    public MethodBlock(Callback callback, RubyMethod rubyMethod, StaticScope staticScope) {
        super(3);
        this.callback = callback;
        this.method = rubyMethod;
        this.arity = Arity.createArity((int)rubyMethod.arity().getLongValue());
        this.staticScope = staticScope;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
        return this.yield(threadContext, threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray), null, null, true, binding, type);
    }

    protected Frame pre(ThreadContext threadContext, RubyModule rubyModule, Binding binding) {
        return threadContext.preYieldNoScope(binding, rubyModule);
    }

    protected void post(ThreadContext threadContext, Binding binding, Frame frame) {
        threadContext.postYieldNoScope(frame);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        return this.yield(threadContext, iRubyObject, null, null, false, binding, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
        if (rubyModule == null) {
            iRubyObject2 = binding.getSelf();
            binding.getFrame().setSelf(iRubyObject2);
        }
        Frame frame = this.pre(threadContext, rubyModule, binding);
        while (true) {
            try {
                IRubyObject iRubyObject3 = this.callback.execute(iRubyObject, new IRubyObject[]{this.method, iRubyObject2}, Block.NULL_BLOCK);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                try {
                    threadContext.pollThreadEvents();
                    continue;
                    catch (JumpException.BreakJump breakJump) {
                        if (breakJump.getTarget() != null) throw breakJump;
                        breakJump.setTarget(this);
                        throw breakJump;
                    }
                }
                catch (JumpException.NextJump nextJump) {
                    IRubyObject iRubyObject4 = (IRubyObject)nextJump.getValue();
                    return iRubyObject4;
                }
            }
            break;
        }
        finally {
            this.post(threadContext, binding, frame);
        }
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope().cloneScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

