/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class FiberLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) throws IOException {
        Fiber.setup(ruby);
    }

    @JRubyClass(name={"Fiber"})
    public static class Fiber
    extends RubyObject {
        private Block block;
        private Object yieldLock = new Object();
        private IRubyObject result;
        private Thread thread;
        private boolean alive = false;

        @JRubyMethod(name={"new"}, rest=true, meta=true, frame=true, compat=CompatVersion.RUBY1_9)
        public static Fiber newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Fiber fiber = new Fiber(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            fiber.initialize(iRubyObjectArray, block);
            return fiber;
        }

        public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
            this.block = block;
            final Ruby ruby = this.getRuntime();
            this.result = ruby.getNil();
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Fiber.this.yieldLock;
                    synchronized (object) {
                        Fiber.this.alive = true;
                        ThreadContext threadContext = ruby.getCurrentContext();
                        threadContext.setFiber(Fiber.this);
                        try {
                            Fiber.this.result = Fiber.this.block.yield(ruby.getCurrentContext(), Fiber.this.result, null, null, true);
                        }
                        finally {
                            Fiber.this.yieldLock.notify();
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            return this;
        }

        public Fiber(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Fiber", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            rubyClass.defineAnnotatedMethods(Fiber.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject resume(IRubyObject[] iRubyObjectArray) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = this.getRuntime().newArrayNoCopyLight(iRubyObjectArray);
                if (!this.alive) {
                    this.thread.start();
                    this.yieldLock.wait();
                } else {
                    this.yieldLock.notify();
                    this.yieldLock.wait();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject transfer(IRubyObject[] iRubyObjectArray) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                this.yieldLock.wait();
            }
            return this.result;
        }

        @JRubyMethod(name={"alive?"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject alive_p() {
            return this.getRuntime().newBoolean(this.alive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject yield(IRubyObject iRubyObject, IRubyObject iRubyObject2) throws InterruptedException {
            Fiber fiber = iRubyObject.getRuntime().getCurrentContext().getFiber();
            fiber.result = iRubyObject2;
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                fiber.yieldLock.wait();
            }
            return iRubyObject.getRuntime().getNil();
        }

        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject current(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().getCurrentContext().getFiber();
        }
    }
}

