/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;

    public DefaultMethod(RubyModule rubyModule, StaticScope staticScope, Node node, ArgsNode argsNode, Visibility visibility, ISourcePosition iSourcePosition) {
        super(rubyModule, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = node;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = iSourcePosition;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void setCallCount(int n) {
        this.callCount = n;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script script) {
        this.jitCompiledScript = script;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration callConfiguration) {
        this.jitCallConfig = callConfiguration;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        assert (iRubyObjectArray != null);
        Ruby ruby = threadContext.getRuntime();
        if (ruby.getInstanceConfig().getCompileMode().shouldJIT()) {
            ruby.getJITCompiler().runJIT(this, threadContext, string);
        }
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, block);
                this.getArity().checkArity(ruby, iRubyObjectArray);
                IRubyObject iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObjectArray, block);
                return iRubyObject2;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject4 = this.handleRedo(ruby);
                return iRubyObject4;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.interpretedCall(threadContext, ruby, iRubyObject, rubyModule, string, iRubyObjectArray, block);
    }

    public IRubyObject interpretedCall(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            RubyModule rubyModule2 = this.getImplementationClass();
            threadContext.preMethodFrameAndScope(rubyModule2, string, iRubyObject, block, this.staticScope, this);
            if (this.argsNode.getBlockArgNode() != null) {
                threadContext.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(ruby, block), 0);
            }
            this.getArity().checkArity(ruby, iRubyObjectArray);
            this.prepareArguments(threadContext, ruby, iRubyObjectArray);
            if (ruby.hasEventHooks()) {
                this.traceCall(threadContext, ruby, string);
            }
            IRubyObject iRubyObject2 = this.body.interpret(ruby, threadContext, iRubyObject, block);
            return iRubyObject2;
        }
        catch (JumpException.ReturnJump returnJump) {
            IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
            return iRubyObject3;
        }
        catch (JumpException.RedoJump redoJump) {
            IRubyObject iRubyObject4 = this.handleRedo(ruby);
            return iRubyObject4;
        }
        catch (StackOverflowError stackOverflowError) {
            throw ruby.newSystemStackError("stack level too deep");
        }
        finally {
            if (ruby.hasEventHooks()) {
                this.traceReturn(threadContext, ruby, string);
            }
            threadContext.postMethodFrameAndScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK);
                IRubyObject iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObjectArray, Block.NULL_BLOCK);
                return iRubyObject2;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject4 = this.handleRedo(ruby);
                return iRubyObject4;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK);
                IRubyObject iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, Block.NULL_BLOCK);
                return iRubyObject2;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject4 = this.handleRedo(ruby);
                return iRubyObject4;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, block);
                IRubyObject iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, block);
                return iRubyObject2;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject4 = this.handleRedo(ruby);
                return iRubyObject4;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK);
                IRubyObject iRubyObject3 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, Block.NULL_BLOCK);
                return iRubyObject3;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject4 = this.handleReturn(threadContext, returnJump);
                return iRubyObject4;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject5 = this.handleRedo(ruby);
                return iRubyObject5;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, block);
                IRubyObject iRubyObject3 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, block);
                return iRubyObject3;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject4 = this.handleReturn(threadContext, returnJump);
                return iRubyObject4;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject5 = this.handleRedo(ruby);
                return iRubyObject5;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK);
                IRubyObject iRubyObject4 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, Block.NULL_BLOCK);
                return iRubyObject4;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject5 = this.handleReturn(threadContext, returnJump);
                return iRubyObject5;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject6 = this.handleRedo(ruby);
                return iRubyObject6;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, block);
                IRubyObject iRubyObject4 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, block);
                return iRubyObject4;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject5 = this.handleReturn(threadContext, returnJump);
                return iRubyObject5;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject6 = this.handleRedo(ruby);
                return iRubyObject6;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK);
                IRubyObject iRubyObject5 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, Block.NULL_BLOCK);
                return iRubyObject5;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject6 = this.handleReturn(threadContext, returnJump);
                return iRubyObject6;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject7 = this.handleRedo(ruby);
                return iRubyObject7;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                this.jitPre(threadContext, iRubyObject, string, block);
                IRubyObject iRubyObject5 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, block);
                return iRubyObject5;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject6 = this.handleReturn(threadContext, returnJump);
                return iRubyObject6;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject7 = this.handleRedo(ruby);
                return iRubyObject7;
            }
            finally {
                this.jitPost(ruby, threadContext, string);
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, block);
    }

    private void jitPre(ThreadContext threadContext, IRubyObject iRubyObject, String string, Block block) {
        RubyModule rubyModule = this.getImplementationClass();
        this.jitCallConfig.pre(threadContext, iRubyObject, rubyModule, string, block, this.staticScope, this);
    }

    private void jitPost(Ruby ruby, ThreadContext threadContext, String string) {
        if (ruby.hasEventHooks()) {
            this.traceReturn(threadContext, ruby, string);
        }
        this.jitCallConfig.post(threadContext);
    }

    private void prepareArguments(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        if (this.requiredArgsCount > iRubyObjectArray.length) {
            throw ruby.newArgumentError("Wrong # of arguments(" + iRubyObjectArray.length + " for " + this.requiredArgsCount + ")");
        }
        if (this.requiredArgsCount > 0) {
            threadContext.getCurrentScope().setArgValues(iRubyObjectArray, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(threadContext, ruby, iRubyObjectArray);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        int n;
        Object object;
        int n2 = this.requiredArgsCount;
        int n3 = this.requiredArgsCount;
        if (this.argsNode.getOptArgs() != null && this.restArg == -1 && (n3 += this.argsNode.getOptArgs().size()) < iRubyObjectArray.length) {
            throw ruby.newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for " + n3 + ")");
        }
        if (this.hasOptArgs) {
            int n4;
            object = this.argsNode.getOptArgs();
            n = 0;
            for (n4 = this.requiredArgsCount; n4 < iRubyObjectArray.length && n < ((ListNode)object).size(); ++n4, ++n) {
                ((ListNode)object).get(n).assign(ruby, threadContext, threadContext.getFrameSelf(), iRubyObjectArray[n4], Block.NULL_BLOCK, true);
                ++n2;
            }
            n4 = 0;
            while (n < ((ListNode)object).size()) {
                ((ListNode)object).get(n).interpret(ruby, threadContext, threadContext.getFrameSelf(), Block.NULL_BLOCK);
                ++n4;
                ++n;
            }
        }
        if (this.restArg != -1 && this.restArg >= 0) {
            object = ruby.newArray(iRubyObjectArray.length - n2);
            for (n = n2; n < iRubyObjectArray.length; ++n) {
                ((RubyArray)object).append(iRubyObjectArray[n]);
            }
            threadContext.getCurrentScope().setValue(this.restArg, (IRubyObject)object, 0);
        }
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext threadContext, Ruby ruby, String string) {
        ruby.callEventHooks(threadContext, 4, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
    }

    private void traceCall(ThreadContext threadContext, Ruby ruby, String string) {
        ruby.callEventHooks(threadContext, 3, this.position.getFile(), this.position.getStartLine(), string, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

