/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UDPSocket"}, parent="IPSocket")
public class RubyUDPSocket
extends RubyIPSocket {
    private static ObjectAllocator UDPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyUDPSocket(ruby, rubyClass);
        }
    };

    static void createUDPSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("UDPSocket", ruby.fastGetClass("IPSocket"), UDPSOCKET_ALLOCATOR);
        rubyClass.includeModule(ruby.fastGetClass("Socket").fastGetConstant("Constants"));
        rubyClass.defineAnnotatedMethods(RubyUDPSocket.class);
        ruby.getObject().fastSetConstant("UDPsocket", rubyClass);
    }

    public RubyUDPSocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            this.initSocket(new ChannelDescriptor(datagramChannel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException connectException) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException iOException) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject iRubyObject) {
        return this.initialize();
    }

    public IRubyObject setsockopt(IRubyObject[] iRubyObjectArray) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject bind(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = iRubyObject.isNil() ? new InetSocketAddress(RubyNumeric.fix2int(iRubyObject2)) : new InetSocketAddress(InetAddress.getByName(iRubyObject.convertToString().toString()), RubyNumeric.fix2int(iRubyObject2));
            ((DatagramChannel)this.getChannel()).socket().bind(inetSocketAddress);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
        catch (SocketException socketException) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
    }

    @JRubyMethod
    public IRubyObject connect(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(iRubyObject.convertToString().toString()), RubyNumeric.fix2int(iRubyObject2));
            ((DatagramChannel)this.getChannel()).connect(inetSocketAddress);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
        catch (IOException iOException) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject recvfrom(IRubyObject[] iRubyObjectArray) {
        try {
            int n = RubyNumeric.fix2int(iRubyObjectArray[0]);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)((DatagramChannel)this.getChannel()).receive(byteBuffer);
            RubyArray rubyArray = this.getRuntime().newArray(new IRubyObject[]{this.getRuntime().newString("AF_INET"), this.getRuntime().newFixnum(inetSocketAddress.getPort()), this.getRuntime().newString(inetSocketAddress.getHostName()), this.getRuntime().newString(inetSocketAddress.getAddress().getHostAddress())});
            RubyString rubyString = this.getRuntime().newString(new ByteList(byteBuffer.array(), 0, byteBuffer.position()));
            return this.getRuntime().newArray(new IRubyObject[]{rubyString, rubyArray});
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
        catch (IOException iOException) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
    }

    public IRubyObject recv(IRubyObject[] iRubyObjectArray) {
        try {
            int n = RubyNumeric.fix2int(iRubyObjectArray[0]);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            ((DatagramChannel)this.getChannel()).receive(byteBuffer);
            return this.getRuntime().newString(new ByteList(byteBuffer.array(), 0, byteBuffer.position()));
        }
        catch (IOException iOException) {
            throw RubyUDPSocket.sockerr(this, "recv: name or service not known");
        }
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject send(IRubyObject[] iRubyObjectArray) {
        try {
            if (iRubyObjectArray.length >= 3) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(iRubyObjectArray[2].convertToString().toString()), RubyNumeric.fix2int(iRubyObjectArray[3]));
                RubyString rubyString = iRubyObjectArray[0].convertToString();
                ByteBuffer byteBuffer = ByteBuffer.wrap(rubyString.getBytes());
                ((DatagramChannel)this.getChannel()).send(byteBuffer, inetSocketAddress);
                return rubyString.length();
            }
            RubyString rubyString = iRubyObjectArray[0].convertToString();
            ByteBuffer byteBuffer = ByteBuffer.wrap(rubyString.getBytes());
            ((DatagramChannel)this.getChannel()).write(byteBuffer);
            return rubyString.length();
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
        catch (IOException iOException) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyUDPSocket rubyUDPSocket = (RubyUDPSocket)iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "new", iRubyObjectArray);
        if (!block.isGiven()) {
            return rubyUDPSocket;
        }
        try {
            IRubyObject iRubyObject2 = block.yield(iRubyObject.getRuntime().getCurrentContext(), rubyUDPSocket);
            return iRubyObject2;
        }
        finally {
            if (rubyUDPSocket.openFile.isOpen()) {
                rubyUDPSocket.close();
            }
        }
    }
}

