/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class RubyTCPSocket
extends RubyIPSocket {
    private static ObjectAllocator TCPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyTCPSocket(ruby, rubyClass);
        }
    };

    static void createTCPSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("TCPSocket", ruby.fastGetClass("IPSocket"), TCPSOCKET_ALLOCATOR);
        rubyClass.includeModule(ruby.fastGetClass("Socket").fastGetConstant("Constants"));
        rubyClass.defineAnnotatedMethods(RubyTCPSocket.class);
        ruby.getObject().fastSetConstant("TCPsocket", rubyClass);
    }

    public RubyTCPSocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    private int getPortFrom(IRubyObject iRubyObject) {
        return RubyNumeric.fix2int(iRubyObject instanceof RubyString ? RubyNumeric.str2inum(this.getRuntime(), (RubyString)iRubyObject, 0, true) : iRubyObject);
    }

    @JRubyMethod(required=2, optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray) {
        Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 2, 4);
        String string = iRubyObjectArray[0].isNil() ? "localhost" : iRubyObjectArray[0].convertToString().toString();
        int n = this.getPortFrom(iRubyObjectArray[1]);
        String string2 = iRubyObjectArray.length >= 3 ? iRubyObjectArray[2].convertToString().toString() : null;
        int n2 = iRubyObjectArray.length == 4 ? this.getPortFrom(iRubyObjectArray[3]) : 0;
        try {
            SocketChannel socketChannel = null;
            if (string2 == null) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string), n);
                socketChannel = SocketChannel.open(inetSocketAddress);
            } else {
                socketChannel = SocketChannel.open();
                Socket socket = socketChannel.socket();
                socket.bind(new InetSocketAddress(InetAddress.getByName(string2), n2));
                socket.connect(new InetSocketAddress(InetAddress.getByName(string), n));
            }
            socketChannel.finishConnect();
            this.initSocket(new ChannelDescriptor(socketChannel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException connectException) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException iOException) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(frame=true, rest=true, meta=true)
    public static IRubyObject open(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyTCPSocket rubyTCPSocket = (RubyTCPSocket)iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "new", iRubyObjectArray);
        if (!block.isGiven()) {
            return rubyTCPSocket;
        }
        try {
            IRubyObject iRubyObject2 = block.yield(iRubyObject.getRuntime().getCurrentContext(), rubyTCPSocket);
            return iRubyObject2;
        }
        finally {
            if (rubyTCPSocket.openFile.isOpen()) {
                rubyTCPSocket.close();
            }
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            IRubyObject[] iRubyObjectArray = new IRubyObject[4];
            Ruby ruby = iRubyObject.getRuntime();
            String string = iRubyObject2.convertToString().toString();
            InetAddress inetAddress = InetAddress.getByName(string);
            iRubyObjectArray[0] = ruby.newString(inetAddress.getCanonicalHostName());
            iRubyObjectArray[1] = ruby.newArray();
            iRubyObjectArray[3] = ruby.newString(inetAddress.getHostAddress());
            if (inetAddress instanceof Inet4Address) {
                Inet4Address inet4Address = (Inet4Address)inetAddress;
                iRubyObjectArray[2] = ruby.newFixnum(2);
            } else if (inetAddress instanceof Inet6Address) {
                Inet6Address inet6Address = (Inet6Address)inetAddress;
                iRubyObjectArray[2] = ruby.newFixnum(30);
            }
            return ruby.newArrayNoCopy(iRubyObjectArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyTCPSocket.sockerr(iRubyObject, "gethostbyname: name or service not known");
        }
    }
}

