/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.load.Library;

public class LateLoadingLibrary
implements Library {
    private String libraryName;
    private String className;
    private ClassLoader classLoader;

    public LateLoadingLibrary(String string, String string2, ClassLoader classLoader) {
        this.libraryName = string;
        this.className = string2;
        this.classLoader = classLoader;
    }

    public synchronized void load(Ruby ruby, boolean bl) throws IOException {
        try {
            if (this.classLoader == null && Ruby.isSecurityRestricted()) {
                this.classLoader = ruby.getInstanceConfig().getLoader();
            }
            Library library = (Library)this.classLoader.loadClass(this.className).newInstance();
            library.load(ruby, bl);
        }
        catch (RaiseException raiseException) {
            throw raiseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw ruby.newLoadError("library `" + this.libraryName + "' could not be loaded: " + throwable);
        }
    }
}

