/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Iterator;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.YARVNodesCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;

public class ASTCompiler {
    private boolean isAtRoot = true;

    public void compile(Node node, MethodCompiler methodCompiler) {
        if (node == null) {
            methodCompiler.loadNil();
            return;
        }
        switch (node.nodeId) {
            case ALIASNODE: {
                this.compileAlias(node, methodCompiler);
                break;
            }
            case ANDNODE: {
                this.compileAnd(node, methodCompiler);
                break;
            }
            case ARGSCATNODE: {
                this.compileArgsCat(node, methodCompiler);
                break;
            }
            case ARGSPUSHNODE: {
                this.compileArgsPush(node, methodCompiler);
                break;
            }
            case ARRAYNODE: {
                this.compileArray(node, methodCompiler);
                break;
            }
            case ATTRASSIGNNODE: {
                this.compileAttrAssign(node, methodCompiler);
                break;
            }
            case BACKREFNODE: {
                this.compileBackref(node, methodCompiler);
                break;
            }
            case BEGINNODE: {
                this.compileBegin(node, methodCompiler);
                break;
            }
            case BIGNUMNODE: {
                this.compileBignum(node, methodCompiler);
                break;
            }
            case BLOCKNODE: {
                this.compileBlock(node, methodCompiler);
                break;
            }
            case BREAKNODE: {
                this.compileBreak(node, methodCompiler);
                break;
            }
            case CALLNODE: {
                this.compileCall(node, methodCompiler);
                break;
            }
            case CASENODE: {
                this.compileCase(node, methodCompiler);
                break;
            }
            case CLASSNODE: {
                this.compileClass(node, methodCompiler);
                break;
            }
            case CLASSVARNODE: {
                this.compileClassVar(node, methodCompiler);
                break;
            }
            case CLASSVARASGNNODE: {
                this.compileClassVarAsgn(node, methodCompiler);
                break;
            }
            case CLASSVARDECLNODE: {
                this.compileClassVarDecl(node, methodCompiler);
                break;
            }
            case COLON2NODE: {
                this.compileColon2(node, methodCompiler);
                break;
            }
            case COLON3NODE: {
                this.compileColon3(node, methodCompiler);
                break;
            }
            case CONSTDECLNODE: {
                this.compileConstDecl(node, methodCompiler);
                break;
            }
            case CONSTNODE: {
                this.compileConst(node, methodCompiler);
                break;
            }
            case DASGNNODE: {
                this.compileDAsgn(node, methodCompiler);
                break;
            }
            case DEFINEDNODE: {
                this.compileDefined(node, methodCompiler);
                break;
            }
            case DEFNNODE: {
                this.compileDefn(node, methodCompiler);
                break;
            }
            case DEFSNODE: {
                this.compileDefs(node, methodCompiler);
                break;
            }
            case DOTNODE: {
                this.compileDot(node, methodCompiler);
                break;
            }
            case DREGEXPNODE: {
                this.compileDRegexp(node, methodCompiler);
                break;
            }
            case DSTRNODE: {
                this.compileDStr(node, methodCompiler);
                break;
            }
            case DSYMBOLNODE: {
                this.compileDSymbol(node, methodCompiler);
                break;
            }
            case DVARNODE: {
                this.compileDVar(node, methodCompiler);
                break;
            }
            case DXSTRNODE: {
                this.compileDXStr(node, methodCompiler);
                break;
            }
            case ENSURENODE: {
                this.compileEnsureNode(node, methodCompiler);
                break;
            }
            case EVSTRNODE: {
                this.compileEvStr(node, methodCompiler);
                break;
            }
            case FALSENODE: {
                this.compileFalse(node, methodCompiler);
                break;
            }
            case FCALLNODE: {
                this.compileFCall(node, methodCompiler);
                break;
            }
            case FIXNUMNODE: {
                this.compileFixnum(node, methodCompiler);
                break;
            }
            case FLIPNODE: {
                this.compileFlip(node, methodCompiler);
                break;
            }
            case FLOATNODE: {
                this.compileFloat(node, methodCompiler);
                break;
            }
            case FORNODE: {
                this.compileFor(node, methodCompiler);
                break;
            }
            case GLOBALASGNNODE: {
                this.compileGlobalAsgn(node, methodCompiler);
                break;
            }
            case GLOBALVARNODE: {
                this.compileGlobalVar(node, methodCompiler);
                break;
            }
            case HASHNODE: {
                this.compileHash(node, methodCompiler);
                break;
            }
            case IFNODE: {
                this.compileIf(node, methodCompiler);
                break;
            }
            case INSTASGNNODE: {
                this.compileInstAsgn(node, methodCompiler);
                break;
            }
            case INSTVARNODE: {
                this.compileInstVar(node, methodCompiler);
                break;
            }
            case ITERNODE: {
                this.compileIter(node, methodCompiler);
                break;
            }
            case LOCALASGNNODE: {
                this.compileLocalAsgn(node, methodCompiler);
                break;
            }
            case LOCALVARNODE: {
                this.compileLocalVar(node, methodCompiler);
                break;
            }
            case MATCH2NODE: {
                this.compileMatch2(node, methodCompiler);
                break;
            }
            case MATCH3NODE: {
                this.compileMatch3(node, methodCompiler);
                break;
            }
            case MATCHNODE: {
                this.compileMatch(node, methodCompiler);
                break;
            }
            case MODULENODE: {
                this.compileModule(node, methodCompiler);
                break;
            }
            case MULTIPLEASGNNODE: {
                this.compileMultipleAsgn(node, methodCompiler);
                break;
            }
            case NEWLINENODE: {
                this.compileNewline(node, methodCompiler);
                break;
            }
            case NEXTNODE: {
                this.compileNext(node, methodCompiler);
                break;
            }
            case NTHREFNODE: {
                this.compileNthRef(node, methodCompiler);
                break;
            }
            case NILNODE: {
                this.compileNil(node, methodCompiler);
                break;
            }
            case NOTNODE: {
                this.compileNot(node, methodCompiler);
                break;
            }
            case OPASGNANDNODE: {
                this.compileOpAsgnAnd(node, methodCompiler);
                break;
            }
            case OPASGNNODE: {
                this.compileOpAsgn(node, methodCompiler);
                break;
            }
            case OPASGNORNODE: {
                this.compileOpAsgnOr(node, methodCompiler);
                break;
            }
            case OPELEMENTASGNNODE: {
                this.compileOpElementAsgn(node, methodCompiler);
                break;
            }
            case ORNODE: {
                this.compileOr(node, methodCompiler);
                break;
            }
            case POSTEXENODE: {
                this.compilePostExe(node, methodCompiler);
                break;
            }
            case PREEXENODE: {
                this.compilePreExe(node, methodCompiler);
                break;
            }
            case REDONODE: {
                this.compileRedo(node, methodCompiler);
                break;
            }
            case REGEXPNODE: {
                this.compileRegexp(node, methodCompiler);
                break;
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                this.compileRescue(node, methodCompiler);
                break;
            }
            case RETRYNODE: {
                this.compileRetry(node, methodCompiler);
                break;
            }
            case RETURNNODE: {
                this.compileReturn(node, methodCompiler);
                break;
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use compileRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                this.compileSClass(node, methodCompiler);
                break;
            }
            case SELFNODE: {
                this.compileSelf(node, methodCompiler);
                break;
            }
            case SPLATNODE: {
                this.compileSplat(node, methodCompiler);
                break;
            }
            case STRNODE: {
                this.compileStr(node, methodCompiler);
                break;
            }
            case SUPERNODE: {
                this.compileSuper(node, methodCompiler);
                break;
            }
            case SVALUENODE: {
                this.compileSValue(node, methodCompiler);
                break;
            }
            case SYMBOLNODE: {
                this.compileSymbol(node, methodCompiler);
                break;
            }
            case TOARYNODE: {
                this.compileToAry(node, methodCompiler);
                break;
            }
            case TRUENODE: {
                this.compileTrue(node, methodCompiler);
                break;
            }
            case UNDEFNODE: {
                this.compileUndef(node, methodCompiler);
                break;
            }
            case UNTILNODE: {
                this.compileUntil(node, methodCompiler);
                break;
            }
            case VALIASNODE: {
                this.compileVAlias(node, methodCompiler);
                break;
            }
            case VCALLNODE: {
                this.compileVCall(node, methodCompiler);
                break;
            }
            case WHILENODE: {
                this.compileWhile(node, methodCompiler);
                break;
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                break;
            }
            case XSTRNODE: {
                this.compileXStr(node, methodCompiler);
                break;
            }
            case YIELDNODE: {
                this.compileYield(node, methodCompiler);
                break;
            }
            case ZARRAYNODE: {
                this.compileZArray(node, methodCompiler);
                break;
            }
            case ZSUPERNODE: {
                this.compileZSuper(node, methodCompiler);
                break;
            }
            default: {
                assert (false) : "Unknown node encountered in compiler: " + node;
                break;
            }
        }
    }

    public void compileArguments(Node node, MethodCompiler methodCompiler) {
        switch (node.nodeId) {
            case ARGSCATNODE: {
                this.compileArgsCatArguments(node, methodCompiler);
                break;
            }
            case ARGSPUSHNODE: {
                this.compileArgsPushArguments(node, methodCompiler);
                break;
            }
            case ARRAYNODE: {
                this.compileArrayArguments(node, methodCompiler);
                break;
            }
            case SPLATNODE: {
                this.compileSplatArguments(node, methodCompiler);
                break;
            }
            default: {
                this.compile(node, methodCompiler);
                methodCompiler.convertToJavaArray();
            }
        }
    }

    public ArgumentsCallback getArgsCallback(Node node) {
        if (node == null) {
            return null;
        }
        while (node.nodeId == NodeType.NEWLINENODE) {
            node = ((NewlineNode)node).getNextNode();
        }
        switch (node.nodeId) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: 
            case SPLATNODE: {
                return new VariableArityArguments(node);
            }
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)node;
                if (arrayNode.size() == 0) {
                    return null;
                }
                if (arrayNode.size() > 3) {
                    return new VariableArityArguments(node);
                }
                return new SpecificArityArguments(node);
            }
        }
        return new SpecificArityArguments(node);
    }

    public void compileAssignment(Node node, MethodCompiler methodCompiler) {
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                this.compileAttrAssignAssignment(node, methodCompiler);
                break;
            }
            case DASGNNODE: {
                this.compileDAsgnAssignment(node, methodCompiler);
                break;
            }
            case CLASSVARASGNNODE: {
                this.compileClassVarAsgnAssignment(node, methodCompiler);
                break;
            }
            case CLASSVARDECLNODE: {
                this.compileClassVarDeclAssignment(node, methodCompiler);
                break;
            }
            case CONSTDECLNODE: {
                this.compileConstDeclAssignment(node, methodCompiler);
                break;
            }
            case GLOBALASGNNODE: {
                this.compileGlobalAsgnAssignment(node, methodCompiler);
                break;
            }
            case INSTASGNNODE: {
                this.compileInstAsgnAssignment(node, methodCompiler);
                break;
            }
            case LOCALASGNNODE: {
                this.compileLocalAsgnAssignment(node, methodCompiler);
                break;
            }
            case MULTIPLEASGNNODE: {
                this.compileMultipleAsgnAssignment(node, methodCompiler);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't compile assignment node: " + node);
            }
        }
    }

    public static YARVNodesCompiler getYARVCompiler() {
        return new YARVNodesCompiler();
    }

    public void compileAlias(Node node, MethodCompiler methodCompiler) {
        AliasNode aliasNode = (AliasNode)node;
        methodCompiler.defineAlias(aliasNode.getNewName(), aliasNode.getOldName());
    }

    public void compileAnd(Node node, MethodCompiler methodCompiler) {
        final AndNode andNode = (AndNode)node;
        this.compile(andNode.getFirstNode(), methodCompiler);
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(andNode.getSecondNode(), methodCompiler);
            }
        };
        methodCompiler.performLogicalAnd(branchCallback);
    }

    public void compileArray(Node node, MethodCompiler methodCompiler) {
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                Node node = (Node)((Object[])object)[n];
                ASTCompiler.this.compile(node, methodCompiler);
            }
        };
        methodCompiler.createNewArray(arrayNode.childNodes().toArray(), arrayCallback, arrayNode.isLightweight());
    }

    public void compileArgsCat(Node node, MethodCompiler methodCompiler) {
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        this.compile(argsCatNode.getFirstNode(), methodCompiler);
        methodCompiler.ensureRubyArray();
        this.compile(argsCatNode.getSecondNode(), methodCompiler);
        methodCompiler.splatCurrentValue();
        methodCompiler.concatArrays();
    }

    public void compileArgsPush(Node node, MethodCompiler methodCompiler) {
        ArgsPushNode argsPushNode = (ArgsPushNode)node;
        this.compile(argsPushNode.getFirstNode(), methodCompiler);
        this.compile(argsPushNode.getSecondNode(), methodCompiler);
        methodCompiler.concatArrays();
    }

    private void compileAttrAssign(Node node, MethodCompiler methodCompiler) {
        final AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(attrAssignNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = this.getArgsCallback(attrAssignNode.getArgsNode());
        methodCompiler.getInvocationCompiler().invokeAttrAssign(attrAssignNode.getName(), compilerCallback, argumentsCallback);
    }

    public void compileAttrAssignAssignment(Node node, MethodCompiler methodCompiler) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        this.compile(attrAssignNode.getReceiverNode(), methodCompiler);
        methodCompiler.swapValues();
        if (attrAssignNode.getArgsNode() != null) {
            this.compileArguments(attrAssignNode.getArgsNode(), methodCompiler);
            methodCompiler.swapValues();
            methodCompiler.appendToObjectArray();
        } else {
            methodCompiler.createObjectArray(1);
        }
        methodCompiler.getInvocationCompiler().invokeAttrAssign(attrAssignNode.getName());
    }

    public void compileBackref(Node node, MethodCompiler methodCompiler) {
        BackRefNode backRefNode = (BackRefNode)node;
        methodCompiler.performBackref(backRefNode.getType());
    }

    public void compileBegin(Node node, MethodCompiler methodCompiler) {
        BeginNode beginNode = (BeginNode)node;
        this.compile(beginNode.getBodyNode(), methodCompiler);
    }

    public void compileBignum(Node node, MethodCompiler methodCompiler) {
        methodCompiler.createNewBignum(((BignumNode)node).getValue());
    }

    public void compileBlock(Node node, MethodCompiler methodCompiler) {
        BlockNode blockNode = (BlockNode)node;
        Iterator<Node> iterator = blockNode.childNodes().iterator();
        while (iterator.hasNext()) {
            Node node2 = iterator.next();
            this.compile(node2, methodCompiler);
            if (!iterator.hasNext()) continue;
            methodCompiler.consumeCurrentValue();
        }
    }

    public void compileBreak(Node node, MethodCompiler methodCompiler) {
        final BreakNode breakNode = (BreakNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (breakNode.getValueNode() != null) {
                    ASTCompiler.this.compile(breakNode.getValueNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.issueBreakEvent(compilerCallback);
    }

    public void compileCall(Node node, MethodCompiler methodCompiler) {
        final CallNode callNode = (CallNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(callNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = this.getArgsCallback(callNode.getArgsNode());
        CompilerCallback compilerCallback2 = this.getBlock(callNode.getIterNode());
        methodCompiler.getInvocationCompiler().invokeDynamic(callNode.getName(), compilerCallback, argumentsCallback, CallType.NORMAL, compilerCallback2, callNode.getIterNode() instanceof IterNode);
    }

    public void compileCase(Node node, MethodCompiler methodCompiler) {
        CaseNode caseNode = (CaseNode)node;
        boolean bl = false;
        if (caseNode.getCaseNode() != null) {
            this.compile(caseNode.getCaseNode(), methodCompiler);
            bl = true;
        }
        methodCompiler.pollThreadEvents();
        Node node2 = caseNode.getFirstWhenNode();
        this.compileWhen(node2, methodCompiler, bl);
    }

    public void compileWhen(Node node, MethodCompiler methodCompiler, final boolean bl) {
        if (node == null) {
            if (bl) {
                methodCompiler.consumeCurrentValue();
            }
            methodCompiler.loadNil();
            return;
        }
        if (!(node instanceof WhenNode)) {
            if (bl) {
                methodCompiler.consumeCurrentValue();
            }
            this.compile(node, methodCompiler);
            return;
        }
        WhenNode whenNode = (WhenNode)node;
        if (whenNode.getExpressionNodes() instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
            this.compileMultiArgWhen(whenNode, arrayNode, 0, methodCompiler, bl);
        } else {
            if (bl) {
                methodCompiler.duplicateCurrentValue();
            }
            this.compile(whenNode.getExpressionNodes(), methodCompiler);
            final WhenNode whenNode2 = whenNode;
            if (bl) {
                methodCompiler.swapValues();
                methodCompiler.getInvocationCompiler().invokeEqq();
            }
            BranchCallback branchCallback = new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    if (bl) {
                        methodCompiler.consumeCurrentValue();
                    }
                    if (whenNode2.getBodyNode() != null) {
                        ASTCompiler.this.compile(whenNode2.getBodyNode(), methodCompiler);
                    } else {
                        methodCompiler.loadNil();
                    }
                }
            };
            BranchCallback branchCallback2 = new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compileWhen(whenNode2.getNextCase(), methodCompiler, bl);
                }
            };
            methodCompiler.performBooleanBranch(branchCallback, branchCallback2);
        }
    }

    public void compileMultiArgWhen(final WhenNode whenNode, final ArrayNode arrayNode, final int n, MethodCompiler methodCompiler, final boolean bl) {
        if (n >= arrayNode.size()) {
            this.compileWhen(whenNode.getNextCase(), methodCompiler, bl);
            return;
        }
        Node node = arrayNode.get(n);
        methodCompiler.setLinePosition(node.getPosition());
        if (node instanceof WhenNode) {
            if (bl) {
                methodCompiler.duplicateCurrentValue();
            } else {
                methodCompiler.loadNull();
            }
            this.compile(((WhenNode)node).getExpressionNodes(), methodCompiler);
            methodCompiler.checkWhenWithSplat();
        } else {
            if (bl) {
                methodCompiler.duplicateCurrentValue();
            }
            this.compile(node, methodCompiler);
            if (bl) {
                methodCompiler.swapValues();
                methodCompiler.getInvocationCompiler().invokeEqq();
            }
        }
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (bl) {
                    methodCompiler.consumeCurrentValue();
                }
                if (whenNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(whenNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compileMultiArgWhen(whenNode, arrayNode, n + 1, methodCompiler, bl);
            }
        };
        methodCompiler.performBooleanBranch(branchCallback, branchCallback2);
    }

    public void compileClass(Node node, MethodCompiler methodCompiler) {
        final ClassNode classNode = (ClassNode)node;
        final Node node2 = classNode.getSuperNode();
        final Colon3Node colon3Node = classNode.getCPath();
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(node2, methodCompiler);
            }
        };
        if (node2 == null) {
            compilerCallback = null;
        }
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                boolean bl = ASTCompiler.this.isAtRoot;
                ASTCompiler.this.isAtRoot = false;
                if (classNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(classNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
                ASTCompiler.this.isAtRoot = bl;
            }
        };
        CompilerCallback compilerCallback3 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (colon3Node instanceof Colon2Node) {
                    Node node = ((Colon2Node)colon3Node).getLeftNode();
                    if (node != null) {
                        ASTCompiler.this.compile(node, methodCompiler);
                    } else {
                        methodCompiler.loadNil();
                    }
                } else if (colon3Node instanceof Colon3Node) {
                    methodCompiler.loadObject();
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.defineClass(classNode.getCPath().getName(), classNode.getScope(), compilerCallback, compilerCallback3, compilerCallback2, null);
    }

    public void compileSClass(Node node, MethodCompiler methodCompiler) {
        final SClassNode sClassNode = (SClassNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(sClassNode.getReceiverNode(), methodCompiler);
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                boolean bl = ASTCompiler.this.isAtRoot;
                ASTCompiler.this.isAtRoot = false;
                if (sClassNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(sClassNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
                ASTCompiler.this.isAtRoot = bl;
            }
        };
        methodCompiler.defineClass("SCLASS", sClassNode.getScope(), null, null, compilerCallback2, compilerCallback);
    }

    public void compileClassVar(Node node, MethodCompiler methodCompiler) {
        ClassVarNode classVarNode = (ClassVarNode)node;
        methodCompiler.retrieveClassVariable(classVarNode.getName());
    }

    public void compileClassVarAsgn(Node node, MethodCompiler methodCompiler) {
        final ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(classVarAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.assignClassVariable(classVarAsgnNode.getName(), compilerCallback);
    }

    public void compileClassVarAsgnAssignment(Node node, MethodCompiler methodCompiler) {
        ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        methodCompiler.assignClassVariable(classVarAsgnNode.getName());
    }

    public void compileClassVarDecl(Node node, MethodCompiler methodCompiler) {
        final ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(classVarDeclNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.declareClassVariable(classVarDeclNode.getName(), compilerCallback);
    }

    public void compileClassVarDeclAssignment(Node node, MethodCompiler methodCompiler) {
        ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        methodCompiler.declareClassVariable(classVarDeclNode.getName());
    }

    public void compileConstDecl(Node node, MethodCompiler methodCompiler) {
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node node2 = constDeclNode.getConstNode();
        if (node2 == null) {
            this.compile(constDeclNode.getValueNode(), methodCompiler);
            methodCompiler.assignConstantInCurrent(constDeclNode.getName());
        } else if (node2.nodeId == NodeType.COLON2NODE) {
            this.compile(((Colon2Node)node2).getLeftNode(), methodCompiler);
            this.compile(constDeclNode.getValueNode(), methodCompiler);
            methodCompiler.assignConstantInModule(constDeclNode.getName());
        } else {
            this.compile(constDeclNode.getValueNode(), methodCompiler);
            methodCompiler.assignConstantInObject(constDeclNode.getName());
        }
    }

    public void compileConstDeclAssignment(Node node, MethodCompiler methodCompiler) {
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node node2 = constDeclNode.getConstNode();
        if (node2 == null) {
            methodCompiler.assignConstantInCurrent(constDeclNode.getName());
        } else if (node2.nodeId == NodeType.COLON2NODE) {
            this.compile(((Colon2Node)node2).getLeftNode(), methodCompiler);
            methodCompiler.swapValues();
            methodCompiler.assignConstantInModule(constDeclNode.getName());
        } else {
            methodCompiler.assignConstantInObject(constDeclNode.getName());
        }
    }

    public void compileConst(Node node, MethodCompiler methodCompiler) {
        ConstNode constNode = (ConstNode)node;
        methodCompiler.retrieveConstant(constNode.getName());
    }

    public void compileColon2(Node node, MethodCompiler methodCompiler) {
        final Colon2Node colon2Node = (Colon2Node)node;
        Node node2 = colon2Node.getLeftNode();
        final String string = colon2Node.getName();
        if (node2 == null) {
            methodCompiler.loadObject();
            methodCompiler.retrieveConstantFromModule(string);
        } else {
            final CompilerCallback compilerCallback = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(colon2Node.getLeftNode(), methodCompiler);
                }
            };
            BranchCallback branchCallback = new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    compilerCallback.call(methodCompiler);
                    methodCompiler.retrieveConstantFromModule(string);
                }
            };
            BranchCallback branchCallback2 = new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    methodCompiler.getInvocationCompiler().invokeDynamic(string, compilerCallback, null, CallType.FUNCTIONAL, null, false);
                }
            };
            methodCompiler.branchIfModule(compilerCallback, branchCallback, branchCallback2);
        }
    }

    public void compileColon3(Node node, MethodCompiler methodCompiler) {
        Colon3Node colon3Node = (Colon3Node)node;
        String string = colon3Node.getName();
        methodCompiler.loadObject();
        methodCompiler.retrieveConstantFromModule(string);
    }

    public void compileGetDefinitionBase(final Node node, MethodCompiler methodCompiler) {
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.inDefined();
                ASTCompiler.this.compileGetDefinition(node, methodCompiler);
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.outDefined();
            }
        };
        methodCompiler.protect(branchCallback, branchCallback2, String.class);
    }

    public void compileDefined(Node node, MethodCompiler methodCompiler) {
        this.compileGetDefinitionBase(((DefinedNode)node).getExpressionNode(), methodCompiler);
        methodCompiler.stringOrNil();
    }

    public void compileGetArgumentDefinition(Node node, MethodCompiler methodCompiler, String string) {
        if (node == null) {
            methodCompiler.pushString(string);
        } else if (node instanceof ArrayNode) {
            Object object = methodCompiler.getNewEnding();
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node node2 = ((ArrayNode)node).get(i);
                this.compileGetDefinition(node2, methodCompiler);
                methodCompiler.ifNull(object);
            }
            methodCompiler.pushString(string);
            Object object2 = methodCompiler.getNewEnding();
            methodCompiler.go(object2);
            methodCompiler.setEnding(object);
            methodCompiler.pushNull();
            methodCompiler.setEnding(object2);
        } else {
            this.compileGetDefinition(node, methodCompiler);
            Object object = methodCompiler.getNewEnding();
            methodCompiler.ifNull(object);
            methodCompiler.pushString(string);
            Object object3 = methodCompiler.getNewEnding();
            methodCompiler.go(object3);
            methodCompiler.setEnding(object);
            methodCompiler.pushNull();
            methodCompiler.setEnding(object3);
        }
    }

    public void compileGetDefinition(final Node node, MethodCompiler methodCompiler) {
        switch (node.nodeId) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: {
                methodCompiler.pushString("assignment");
                break;
            }
            case BACKREFNODE: {
                methodCompiler.backref();
                methodCompiler.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("$" + ((BackRefNode)node).getType());
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case DVARNODE: {
                methodCompiler.pushString("local-variable(in-block)");
                break;
            }
            case FALSENODE: {
                methodCompiler.pushString("false");
                break;
            }
            case TRUENODE: {
                methodCompiler.pushString("true");
                break;
            }
            case LOCALVARNODE: {
                methodCompiler.pushString("local-variable");
                break;
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                methodCompiler.pushString("method");
                break;
            }
            case NILNODE: {
                methodCompiler.pushString("nil");
                break;
            }
            case NTHREFNODE: {
                methodCompiler.isCaptured(((NthRefNode)node).getMatchNumber(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("$" + ((NthRefNode)node).getMatchNumber());
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case SELFNODE: {
                methodCompiler.pushString("self");
                break;
            }
            case VCALLNODE: {
                methodCompiler.loadSelf();
                methodCompiler.isMethodBound(((VCallNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("method");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case YIELDNODE: {
                methodCompiler.hasBlock(new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("yield");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case GLOBALVARNODE: {
                methodCompiler.isGlobalDefined(((GlobalVarNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("global-variable");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case INSTVARNODE: {
                methodCompiler.isInstanceVariableDefined(((InstVarNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("instance-variable");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case CONSTNODE: {
                methodCompiler.isConstantDefined(((ConstNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("constant");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case FCALLNODE: {
                methodCompiler.loadSelf();
                methodCompiler.isMethodBound(((FCallNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        ASTCompiler.this.compileGetArgumentDefinition(((FCallNode)node).getArgsNode(), methodCompiler, "method");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                });
                break;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node colon3Node = (Colon3Node)node;
                String string = colon3Node.getName();
                BranchCallback branchCallback = new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        if (colon3Node instanceof Colon2Node) {
                            Node node = ((Colon2Node)colon3Node).getLeftNode();
                            ASTCompiler.this.compile(node, methodCompiler);
                        } else {
                            methodCompiler.loadObject();
                        }
                    }
                };
                BranchCallback branchCallback2 = new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("constant");
                    }
                };
                BranchCallback branchCallback3 = new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushString("method");
                    }
                };
                BranchCallback branchCallback4 = new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                };
                methodCompiler.isConstantBranch(branchCallback, branchCallback2, branchCallback3, branchCallback4, string);
                break;
            }
            case CALLNODE: {
                final CallNode callNode = (CallNode)node;
                Object object = methodCompiler.getNewEnding();
                Object object2 = methodCompiler.getNewEnding();
                this.compileGetDefinition(callNode.getReceiverNode(), methodCompiler);
                methodCompiler.ifNull(object);
                methodCompiler.rescue(new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        ASTCompiler.this.compile(callNode.getReceiverNode(), methodCompiler);
                        methodCompiler.duplicateCurrentValue();
                        methodCompiler.metaclass();
                        methodCompiler.duplicateCurrentValue();
                        methodCompiler.getVisibilityFor(callNode.getName());
                        methodCompiler.duplicateCurrentValue();
                        final Object object = methodCompiler.getNewEnding();
                        Object object2 = methodCompiler.getNewEnding();
                        Object object3 = methodCompiler.getNewEnding();
                        methodCompiler.isPrivate(object, 3);
                        methodCompiler.isNotProtected(object2, 1);
                        methodCompiler.selfIsKindOf(object2);
                        methodCompiler.consumeCurrentValue();
                        methodCompiler.go(object);
                        methodCompiler.setEnding(object2);
                        methodCompiler.isMethodBound(callNode.getName(), new BranchCallback(){

                            public void branch(MethodCompiler methodCompiler) {
                                ASTCompiler.this.compileGetArgumentDefinition(callNode.getArgsNode(), methodCompiler, "method");
                            }
                        }, new BranchCallback(){

                            public void branch(MethodCompiler methodCompiler) {
                                methodCompiler.go(object);
                            }
                        });
                        methodCompiler.go(object3);
                        methodCompiler.setEnding(object);
                        methodCompiler.pushNull();
                        methodCompiler.setEnding(object3);
                    }
                }, JumpException.class, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                }, String.class);
                methodCompiler.go(object2);
                methodCompiler.setEnding(object);
                methodCompiler.pushNull();
                methodCompiler.setEnding(object2);
                break;
            }
            case CLASSVARNODE: {
                ClassVarNode classVarNode = (ClassVarNode)node;
                final Object object = methodCompiler.getNewEnding();
                Object object3 = methodCompiler.getNewEnding();
                Object object4 = methodCompiler.getNewEnding();
                Object object5 = methodCompiler.getNewEnding();
                Object object6 = methodCompiler.getNewEnding();
                methodCompiler.loadCurrentModule();
                methodCompiler.duplicateCurrentValue();
                methodCompiler.ifNotNull(object5);
                methodCompiler.consumeCurrentValue();
                methodCompiler.loadSelf();
                methodCompiler.metaclass();
                methodCompiler.duplicateCurrentValue();
                methodCompiler.isClassVarDefined(classVarNode.getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.consumeCurrentValue();
                        methodCompiler.pushString("class variable");
                        methodCompiler.go(object);
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                    }
                });
                methodCompiler.setEnding(object5);
                methodCompiler.duplicateCurrentValue();
                methodCompiler.isClassVarDefined(classVarNode.getName(), new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.consumeCurrentValue();
                        methodCompiler.pushString("class variable");
                        methodCompiler.go(object);
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                    }
                });
                methodCompiler.setEnding(object6);
                methodCompiler.duplicateCurrentValue();
                methodCompiler.ifSingleton(object4);
                methodCompiler.consumeCurrentValue();
                methodCompiler.go(object3);
                methodCompiler.setEnding(object4);
                methodCompiler.attached();
                methodCompiler.notIsModuleAndClassVarDefined(classVarNode.getName(), object3);
                methodCompiler.pushString("class variable");
                methodCompiler.go(object);
                methodCompiler.setEnding(object3);
                methodCompiler.pushNull();
                methodCompiler.setEnding(object);
                break;
            }
            case ZSUPERNODE: {
                Object object = methodCompiler.getNewEnding();
                Object object7 = methodCompiler.getNewEnding();
                Object object8 = methodCompiler.getNewEnding();
                Object object9 = methodCompiler.getNewEnding();
                methodCompiler.getFrameName();
                methodCompiler.duplicateCurrentValue();
                methodCompiler.ifNull(object);
                methodCompiler.getFrameKlazz();
                methodCompiler.duplicateCurrentValue();
                methodCompiler.ifNull(object7);
                methodCompiler.superClass();
                methodCompiler.ifNotSuperMethodBound(object8);
                methodCompiler.pushString("super");
                methodCompiler.go(object9);
                methodCompiler.setEnding(object7);
                methodCompiler.consumeCurrentValue();
                methodCompiler.setEnding(object);
                methodCompiler.consumeCurrentValue();
                methodCompiler.setEnding(object8);
                methodCompiler.pushNull();
                methodCompiler.setEnding(object9);
                break;
            }
            case SUPERNODE: {
                Object object = methodCompiler.getNewEnding();
                Object object10 = methodCompiler.getNewEnding();
                Object object11 = methodCompiler.getNewEnding();
                Object object12 = methodCompiler.getNewEnding();
                methodCompiler.getFrameName();
                methodCompiler.duplicateCurrentValue();
                methodCompiler.ifNull(object);
                methodCompiler.getFrameKlazz();
                methodCompiler.duplicateCurrentValue();
                methodCompiler.ifNull(object10);
                methodCompiler.superClass();
                methodCompiler.ifNotSuperMethodBound(object11);
                this.compileGetArgumentDefinition(((SuperNode)node).getArgsNode(), methodCompiler, "super");
                methodCompiler.go(object12);
                methodCompiler.setEnding(object10);
                methodCompiler.consumeCurrentValue();
                methodCompiler.setEnding(object);
                methodCompiler.consumeCurrentValue();
                methodCompiler.setEnding(object11);
                methodCompiler.pushNull();
                methodCompiler.setEnding(object12);
                break;
            }
            case ATTRASSIGNNODE: {
                final AttrAssignNode attrAssignNode = (AttrAssignNode)node;
                Object object = methodCompiler.getNewEnding();
                Object object13 = methodCompiler.getNewEnding();
                this.compileGetDefinition(attrAssignNode.getReceiverNode(), methodCompiler);
                methodCompiler.ifNull(object);
                methodCompiler.rescue(new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        ASTCompiler.this.compile(attrAssignNode.getReceiverNode(), methodCompiler);
                        methodCompiler.duplicateCurrentValue();
                        methodCompiler.metaclass();
                        methodCompiler.duplicateCurrentValue();
                        methodCompiler.getVisibilityFor(attrAssignNode.getName());
                        methodCompiler.duplicateCurrentValue();
                        final Object object = methodCompiler.getNewEnding();
                        Object object2 = methodCompiler.getNewEnding();
                        Object object3 = methodCompiler.getNewEnding();
                        methodCompiler.isPrivate(object, 3);
                        methodCompiler.isNotProtected(object2, 1);
                        methodCompiler.selfIsKindOf(object2);
                        methodCompiler.consumeCurrentValue();
                        methodCompiler.go(object);
                        methodCompiler.setEnding(object2);
                        methodCompiler.isMethodBound(attrAssignNode.getName(), new BranchCallback(){

                            public void branch(MethodCompiler methodCompiler) {
                                ASTCompiler.this.compileGetArgumentDefinition(attrAssignNode.getArgsNode(), methodCompiler, "assignment");
                            }
                        }, new BranchCallback(){

                            public void branch(MethodCompiler methodCompiler) {
                                methodCompiler.go(object);
                            }
                        });
                        methodCompiler.go(object3);
                        methodCompiler.setEnding(object);
                        methodCompiler.pushNull();
                        methodCompiler.setEnding(object3);
                    }
                }, JumpException.class, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                }, String.class);
                methodCompiler.go(object13);
                methodCompiler.setEnding(object);
                methodCompiler.pushNull();
                methodCompiler.setEnding(object13);
                break;
            }
            default: {
                methodCompiler.rescue(new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        ASTCompiler.this.compile(node, methodCompiler);
                        methodCompiler.consumeCurrentValue();
                        methodCompiler.pushNull();
                    }
                }, JumpException.class, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.pushNull();
                    }
                }, String.class);
                methodCompiler.consumeCurrentValue();
                methodCompiler.pushString("expression");
            }
        }
    }

    public void compileDAsgn(Node node, MethodCompiler methodCompiler) {
        final DAsgnNode dAsgnNode = (DAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(dAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.getVariableCompiler().assignLocalVariable(dAsgnNode.getIndex(), dAsgnNode.getDepth(), compilerCallback);
    }

    public void compileDAsgnAssignment(Node node, MethodCompiler methodCompiler) {
        DAsgnNode dAsgnNode = (DAsgnNode)node;
        methodCompiler.getVariableCompiler().assignLocalVariable(dAsgnNode.getIndex(), dAsgnNode.getDepth());
    }

    public void compileDefn(Node node, MethodCompiler methodCompiler) {
        final DefnNode defnNode = (DefnNode)node;
        final ArgsNode argsNode = defnNode.getArgsNode();
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (defnNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(defnNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compileArgs(argsNode, methodCompiler);
            }
        };
        ASTInspector aSTInspector = new ASTInspector();
        aSTInspector.inspect(defnNode.getArgsNode());
        aSTInspector.inspect(defnNode.getBodyNode());
        methodCompiler.defineNewMethod(defnNode.getName(), defnNode.getArgsNode().getArity().getValue(), defnNode.getScope(), compilerCallback, compilerCallback2, null, aSTInspector, this.isAtRoot);
    }

    public void compileDefs(Node node, MethodCompiler methodCompiler) {
        final DefsNode defsNode = (DefsNode)node;
        final ArgsNode argsNode = defsNode.getArgsNode();
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(defsNode.getReceiverNode(), methodCompiler);
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (defsNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(defsNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        CompilerCallback compilerCallback3 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compileArgs(argsNode, methodCompiler);
            }
        };
        ASTInspector aSTInspector = new ASTInspector();
        aSTInspector.inspect(defsNode.getArgsNode());
        aSTInspector.inspect(defsNode.getBodyNode());
        methodCompiler.defineNewMethod(defsNode.getName(), defsNode.getArgsNode().getArity().getValue(), defsNode.getScope(), compilerCallback2, compilerCallback3, compilerCallback, aSTInspector, false);
    }

    public void compileArgs(Node node, MethodCompiler methodCompiler) {
        final ArgsNode argsNode = (ArgsNode)node;
        int n = argsNode.getRequiredArgsCount();
        int n2 = argsNode.getOptionalArgsCount();
        int n3 = argsNode.getRestArg();
        ArrayCallback arrayCallback = null;
        ArrayCallback arrayCallback2 = null;
        ArrayCallback arrayCallback3 = null;
        CompilerCallback compilerCallback = null;
        CompilerCallback compilerCallback2 = null;
        if (n > 0) {
            arrayCallback = new ArrayCallback(){

                public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                    methodCompiler.getVariableCompiler().assignLocalVariable(n);
                }
            };
        }
        if (n2 > 0) {
            arrayCallback2 = new ArrayCallback(){

                public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                    Node node = ((ListNode)object).get(n);
                    ASTCompiler.this.compileAssignment(node, methodCompiler);
                }
            };
            arrayCallback3 = new ArrayCallback(){

                public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                    Node node = ((ListNode)object).get(n);
                    ASTCompiler.this.compile(node, methodCompiler);
                }
            };
        }
        if (n3 > -1) {
            compilerCallback = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    methodCompiler.getVariableCompiler().assignLocalVariable(argsNode.getRestArg());
                }
            };
        }
        if (argsNode.getBlockArgNode() != null) {
            compilerCallback2 = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    methodCompiler.getVariableCompiler().assignLocalVariable(argsNode.getBlockArgNode().getCount());
                }
            };
        }
        methodCompiler.getVariableCompiler().checkMethodArity(n, n2, n3);
        methodCompiler.getVariableCompiler().assignMethodArguments(argsNode.getArgs(), argsNode.getRequiredArgsCount(), argsNode.getOptArgs(), argsNode.getOptionalArgsCount(), arrayCallback, arrayCallback2, arrayCallback3, compilerCallback, compilerCallback2);
    }

    public void compileDot(Node node, MethodCompiler methodCompiler) {
        DotNode dotNode = (DotNode)node;
        this.compile(dotNode.getBeginNode(), methodCompiler);
        this.compile(dotNode.getEndNode(), methodCompiler);
        methodCompiler.createNewRange(dotNode.isExclusive());
    }

    public void compileDRegexp(Node node, MethodCompiler methodCompiler) {
        final DRegexpNode dRegexpNode = (DRegexpNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ArrayCallback arrayCallback = new ArrayCallback(){

                    public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                        ASTCompiler.this.compile(dRegexpNode.get(n), methodCompiler);
                    }
                };
                methodCompiler.createNewString(arrayCallback, dRegexpNode.size());
            }
        };
        methodCompiler.createNewRegexp(compilerCallback, dRegexpNode.getOptions());
    }

    public void compileDStr(Node node, MethodCompiler methodCompiler) {
        final DStrNode dStrNode = (DStrNode)node;
        ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                ASTCompiler.this.compile(dStrNode.get(n), methodCompiler);
            }
        };
        methodCompiler.createNewString(arrayCallback, dStrNode.size());
    }

    public void compileDSymbol(Node node, MethodCompiler methodCompiler) {
        final DSymbolNode dSymbolNode = (DSymbolNode)node;
        ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                ASTCompiler.this.compile(dSymbolNode.get(n), methodCompiler);
            }
        };
        methodCompiler.createNewSymbol(arrayCallback, dSymbolNode.size());
    }

    public void compileDVar(Node node, MethodCompiler methodCompiler) {
        DVarNode dVarNode = (DVarNode)node;
        methodCompiler.getVariableCompiler().retrieveLocalVariable(dVarNode.getIndex(), dVarNode.getDepth());
    }

    public void compileDXStr(Node node, MethodCompiler methodCompiler) {
        final DXStrNode dXStrNode = (DXStrNode)node;
        final ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                ASTCompiler.this.compile(dXStrNode.get(n), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

            public int getArity() {
                return 1;
            }

            public void call(MethodCompiler methodCompiler) {
                methodCompiler.createNewString(arrayCallback, dXStrNode.size());
            }
        };
        methodCompiler.getInvocationCompiler().invokeDynamic("`", null, argumentsCallback, CallType.FUNCTIONAL, null, false);
    }

    public void compileEnsureNode(Node node, MethodCompiler methodCompiler) {
        final EnsureNode ensureNode = (EnsureNode)node;
        if (ensureNode.getEnsureNode() != null) {
            methodCompiler.protect(new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    if (ensureNode.getBodyNode() != null) {
                        ASTCompiler.this.compile(ensureNode.getBodyNode(), methodCompiler);
                    } else {
                        methodCompiler.loadNil();
                    }
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(ensureNode.getEnsureNode(), methodCompiler);
                    methodCompiler.consumeCurrentValue();
                }
            }, IRubyObject.class);
        } else if (ensureNode.getBodyNode() != null) {
            this.compile(ensureNode.getBodyNode(), methodCompiler);
        } else {
            methodCompiler.loadNil();
        }
    }

    public void compileEvStr(Node node, MethodCompiler methodCompiler) {
        EvStrNode evStrNode = (EvStrNode)node;
        this.compile(evStrNode.getBody(), methodCompiler);
        methodCompiler.asString();
    }

    public void compileFalse(Node node, MethodCompiler methodCompiler) {
        methodCompiler.loadFalse();
        methodCompiler.pollThreadEvents();
    }

    public void compileFCall(Node node, MethodCompiler methodCompiler) {
        FCallNode fCallNode = (FCallNode)node;
        ArgumentsCallback argumentsCallback = this.getArgsCallback(fCallNode.getArgsNode());
        CompilerCallback compilerCallback = this.getBlock(fCallNode.getIterNode());
        methodCompiler.getInvocationCompiler().invokeDynamic(fCallNode.getName(), null, argumentsCallback, CallType.FUNCTIONAL, compilerCallback, fCallNode.getIterNode() instanceof IterNode);
    }

    private CompilerCallback getBlock(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.nodeId) {
            case ITERNODE: {
                final IterNode iterNode = (IterNode)node;
                return new CompilerCallback(){

                    public void call(MethodCompiler methodCompiler) {
                        ASTCompiler.this.compile(iterNode, methodCompiler);
                    }
                };
            }
            case BLOCKPASSNODE: {
                final BlockPassNode blockPassNode = (BlockPassNode)node;
                return new CompilerCallback(){

                    public void call(MethodCompiler methodCompiler) {
                        ASTCompiler.this.compile(blockPassNode.getBodyNode(), methodCompiler);
                        methodCompiler.unwrapPassedBlock();
                    }
                };
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public void compileFixnum(Node node, MethodCompiler methodCompiler) {
        FixnumNode fixnumNode = (FixnumNode)node;
        methodCompiler.createNewFixnum(fixnumNode.getValue());
    }

    public void compileFlip(Node node, MethodCompiler methodCompiler) {
        final FlipNode flipNode = (FlipNode)node;
        methodCompiler.getVariableCompiler().retrieveLocalVariable(flipNode.getIndex(), flipNode.getDepth());
        if (flipNode.isExclusive()) {
            methodCompiler.performBooleanBranch(new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(flipNode.getEndNode(), methodCompiler);
                    methodCompiler.performBooleanBranch(new BranchCallback(){

                        public void branch(MethodCompiler methodCompiler) {
                            methodCompiler.loadFalse();
                            methodCompiler.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            methodCompiler.consumeCurrentValue();
                        }
                    }, new BranchCallback(){

                        public void branch(MethodCompiler methodCompiler) {
                        }
                    });
                    methodCompiler.loadTrue();
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(flipNode.getBeginNode(), methodCompiler);
                    ASTCompiler.this.becomeTrueOrFalse(methodCompiler);
                    methodCompiler.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                }
            });
        } else {
            methodCompiler.performBooleanBranch(new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(flipNode.getEndNode(), methodCompiler);
                    methodCompiler.performBooleanBranch(new BranchCallback(){

                        public void branch(MethodCompiler methodCompiler) {
                            methodCompiler.loadFalse();
                            methodCompiler.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            methodCompiler.consumeCurrentValue();
                        }
                    }, new BranchCallback(){

                        public void branch(MethodCompiler methodCompiler) {
                        }
                    });
                    methodCompiler.loadTrue();
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(flipNode.getBeginNode(), methodCompiler);
                    methodCompiler.performBooleanBranch(new BranchCallback(){

                        public void branch(MethodCompiler methodCompiler) {
                            ASTCompiler.this.compile(flipNode.getEndNode(), methodCompiler);
                            ASTCompiler.this.flipTrueOrFalse(methodCompiler);
                            methodCompiler.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            methodCompiler.consumeCurrentValue();
                            methodCompiler.loadTrue();
                        }
                    }, new BranchCallback(){

                        public void branch(MethodCompiler methodCompiler) {
                            methodCompiler.loadFalse();
                        }
                    });
                }
            });
        }
    }

    private void becomeTrueOrFalse(MethodCompiler methodCompiler) {
        methodCompiler.performBooleanBranch(new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.loadTrue();
            }
        }, new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.loadFalse();
            }
        });
    }

    private void flipTrueOrFalse(MethodCompiler methodCompiler) {
        methodCompiler.performBooleanBranch(new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.loadFalse();
            }
        }, new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.loadTrue();
            }
        });
    }

    public void compileFloat(Node node, MethodCompiler methodCompiler) {
        FloatNode floatNode = (FloatNode)node;
        methodCompiler.createNewFloat(floatNode.getValue());
    }

    public void compileFor(Node node, MethodCompiler methodCompiler) {
        final ForNode forNode = (ForNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(forNode.getIterNode(), methodCompiler);
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compileForIter(forNode, methodCompiler);
            }
        };
        methodCompiler.getInvocationCompiler().invokeDynamic("each", compilerCallback, null, CallType.NORMAL, compilerCallback2, true);
    }

    public void compileForIter(Node node, MethodCompiler methodCompiler) {
        final ForNode forNode = (ForNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (forNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(forNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (forNode.getVarNode() != null) {
                    ASTCompiler.this.compileAssignment(forNode.getVarNode(), methodCompiler);
                }
            }
        };
        boolean bl = false;
        if (forNode.getVarNode() instanceof MultipleAsgnNode) {
            bl = ((MultipleAsgnNode)forNode.getVarNode()).getHeadNode() != null;
        }
        NodeType nodeType = null;
        if (forNode.getVarNode() != null) {
            nodeType = forNode.getVarNode().nodeId;
        }
        if (nodeType == null) {
            methodCompiler.createNewForLoop(Arity.procArityOf(forNode.getVarNode()).getValue(), compilerCallback, null, bl, nodeType);
        } else {
            methodCompiler.createNewForLoop(Arity.procArityOf(forNode.getVarNode()).getValue(), compilerCallback, compilerCallback2, bl, nodeType);
        }
    }

    public void compileGlobalAsgn(Node node, MethodCompiler methodCompiler) {
        final GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(globalAsgnNode.getValueNode(), methodCompiler);
            }
        };
        if (globalAsgnNode.getName().length() == 2) {
            switch (globalAsgnNode.getName().charAt(1)) {
                case '_': {
                    methodCompiler.getVariableCompiler().assignLastLine(compilerCallback);
                    return;
                }
                case '~': {
                    methodCompiler.getVariableCompiler().assignBackRef(compilerCallback);
                    return;
                }
            }
        }
        methodCompiler.assignGlobalVariable(globalAsgnNode.getName(), compilerCallback);
    }

    public void compileGlobalAsgnAssignment(Node node, MethodCompiler methodCompiler) {
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        if (globalAsgnNode.getName().length() == 2) {
            switch (globalAsgnNode.getName().charAt(1)) {
                case '_': {
                    methodCompiler.getVariableCompiler().assignLastLine();
                    return;
                }
                case '~': {
                    methodCompiler.getVariableCompiler().assignBackRef();
                    return;
                }
            }
        }
        methodCompiler.assignGlobalVariable(globalAsgnNode.getName());
    }

    public void compileGlobalVar(Node node, MethodCompiler methodCompiler) {
        GlobalVarNode globalVarNode = (GlobalVarNode)node;
        if (globalVarNode.getName().length() == 2) {
            switch (globalVarNode.getName().charAt(1)) {
                case '_': {
                    methodCompiler.getVariableCompiler().retrieveLastLine();
                    return;
                }
                case '~': {
                    methodCompiler.getVariableCompiler().retrieveBackRef();
                    return;
                }
            }
        }
        methodCompiler.retrieveGlobalVariable(globalVarNode.getName());
    }

    public void compileHash(Node node, MethodCompiler methodCompiler) {
        HashNode hashNode = (HashNode)node;
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            methodCompiler.createEmptyHash();
            return;
        }
        ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                ListNode listNode = (ListNode)object;
                int n2 = n * 2;
                ASTCompiler.this.compile(listNode.get(n2), methodCompiler);
                ASTCompiler.this.compile(listNode.get(n2 + 1), methodCompiler);
            }
        };
        methodCompiler.createNewHash(hashNode.getListNode(), arrayCallback, hashNode.getListNode().size() / 2);
    }

    public void compileIf(Node node, MethodCompiler methodCompiler) {
        final IfNode ifNode = (IfNode)node;
        this.compile(ifNode.getCondition(), methodCompiler);
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (ifNode.getThenBody() != null) {
                    ASTCompiler.this.compile(ifNode.getThenBody(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (ifNode.getElseBody() != null) {
                    ASTCompiler.this.compile(ifNode.getElseBody(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.performBooleanBranch(branchCallback, branchCallback2);
    }

    public void compileInstAsgn(Node node, MethodCompiler methodCompiler) {
        final InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(instAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.assignInstanceVariable(instAsgnNode.getName(), compilerCallback);
    }

    public void compileInstAsgnAssignment(Node node, MethodCompiler methodCompiler) {
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        methodCompiler.assignInstanceVariable(instAsgnNode.getName());
    }

    public void compileInstVar(Node node, MethodCompiler methodCompiler) {
        InstVarNode instVarNode = (InstVarNode)node;
        methodCompiler.retrieveInstanceVariable(instVarNode.getName());
    }

    public void compileIter(Node node, MethodCompiler methodCompiler) {
        final IterNode iterNode = (IterNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (iterNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(iterNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (iterNode.getVarNode() != null) {
                    ASTCompiler.this.compileAssignment(iterNode.getVarNode(), methodCompiler);
                }
            }
        };
        boolean bl = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            bl = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        NodeType nodeType = BlockBody.getArgumentTypeWackyHack(iterNode);
        ASTInspector aSTInspector = new ASTInspector();
        aSTInspector.inspect(iterNode.getBodyNode());
        aSTInspector.inspect(iterNode.getVarNode());
        if (nodeType == null) {
            methodCompiler.createNewClosure(iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), compilerCallback, null, bl, nodeType, aSTInspector);
        } else {
            methodCompiler.createNewClosure(iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), compilerCallback, compilerCallback2, bl, nodeType, aSTInspector);
        }
    }

    public void compileLocalAsgn(Node node, MethodCompiler methodCompiler) {
        final LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        if (ASTInspector.PRAGMAS.contains(localAsgnNode.getName())) {
            methodCompiler.loadNull();
        } else {
            CompilerCallback compilerCallback = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    ASTCompiler.this.compile(localAsgnNode.getValueNode(), methodCompiler);
                }
            };
            methodCompiler.getVariableCompiler().assignLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getDepth(), compilerCallback);
        }
    }

    public void compileLocalAsgnAssignment(Node node, MethodCompiler methodCompiler) {
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        methodCompiler.getVariableCompiler().assignLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getDepth());
    }

    public void compileLocalVar(Node node, MethodCompiler methodCompiler) {
        LocalVarNode localVarNode = (LocalVarNode)node;
        methodCompiler.getVariableCompiler().retrieveLocalVariable(localVarNode.getIndex(), localVarNode.getDepth());
    }

    public void compileMatch(Node node, MethodCompiler methodCompiler) {
        MatchNode matchNode = (MatchNode)node;
        this.compile(matchNode.getRegexpNode(), methodCompiler);
        methodCompiler.match();
    }

    public void compileMatch2(Node node, MethodCompiler methodCompiler) {
        Match2Node match2Node = (Match2Node)node;
        this.compile(match2Node.getReceiverNode(), methodCompiler);
        this.compile(match2Node.getValueNode(), methodCompiler);
        methodCompiler.match2();
    }

    public void compileMatch3(Node node, MethodCompiler methodCompiler) {
        Match3Node match3Node = (Match3Node)node;
        this.compile(match3Node.getReceiverNode(), methodCompiler);
        this.compile(match3Node.getValueNode(), methodCompiler);
        methodCompiler.match3();
    }

    public void compileModule(Node node, MethodCompiler methodCompiler) {
        final ModuleNode moduleNode = (ModuleNode)node;
        final Colon3Node colon3Node = moduleNode.getCPath();
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (moduleNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(moduleNode.getBodyNode(), methodCompiler);
                }
                methodCompiler.loadNil();
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (colon3Node instanceof Colon2Node) {
                    Node node = ((Colon2Node)colon3Node).getLeftNode();
                    if (node != null) {
                        ASTCompiler.this.compile(node, methodCompiler);
                    } else {
                        methodCompiler.loadNil();
                    }
                } else if (colon3Node instanceof Colon3Node) {
                    methodCompiler.loadObject();
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.defineModule(moduleNode.getCPath().getName(), moduleNode.getScope(), compilerCallback2, compilerCallback);
    }

    public void compileMultipleAsgn(Node node, MethodCompiler methodCompiler) {
        MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        this.compile(multipleAsgnNode.getValueNode(), methodCompiler);
        this.compileMultipleAsgnAssignment(node, methodCompiler);
    }

    public void compileMultipleAsgnAssignment(Node node, MethodCompiler methodCompiler) {
        final MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                ListNode listNode = (ListNode)object;
                Node node = listNode.get(n);
                ASTCompiler.this.compileAssignment(node, methodCompiler);
            }
        };
        ArrayCallback arrayCallback2 = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                ListNode listNode = (ListNode)object;
                Node node = listNode.get(n);
                methodCompiler.loadNil();
                ASTCompiler.this.compileAssignment(node, methodCompiler);
            }
        };
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                Node node = multipleAsgnNode.getArgsNode();
                if (!(node instanceof StarNode)) {
                    ASTCompiler.this.compileAssignment(node, methodCompiler);
                }
            }
        };
        if (multipleAsgnNode.getHeadNode() == null) {
            if (multipleAsgnNode.getArgsNode() == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
            if (!(multipleAsgnNode.getArgsNode() instanceof StarNode)) {
                methodCompiler.ensureMultipleAssignableRubyArray(multipleAsgnNode.getHeadNode() != null);
                methodCompiler.forEachInValueArray(0, 0, null, null, null, compilerCallback);
            }
        } else {
            methodCompiler.ensureMultipleAssignableRubyArray(multipleAsgnNode.getHeadNode() != null);
            if (multipleAsgnNode.getArgsNode() == null) {
                methodCompiler.forEachInValueArray(0, multipleAsgnNode.getHeadNode().size(), multipleAsgnNode.getHeadNode(), arrayCallback, arrayCallback2, null);
            } else {
                methodCompiler.forEachInValueArray(0, multipleAsgnNode.getHeadNode().size(), multipleAsgnNode.getHeadNode(), arrayCallback, arrayCallback2, compilerCallback);
            }
        }
    }

    public void compileNewline(Node node, MethodCompiler methodCompiler) {
        methodCompiler.lineNumber(node.getPosition());
        methodCompiler.setLinePosition(node.getPosition());
        NewlineNode newlineNode = (NewlineNode)node;
        this.compile(newlineNode.getNextNode(), methodCompiler);
    }

    public void compileNext(Node node, MethodCompiler methodCompiler) {
        final NextNode nextNode = (NextNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (nextNode.getValueNode() != null) {
                    ASTCompiler.this.compile(nextNode.getValueNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.pollThreadEvents();
        methodCompiler.issueNextEvent(compilerCallback);
    }

    public void compileNthRef(Node node, MethodCompiler methodCompiler) {
        NthRefNode nthRefNode = (NthRefNode)node;
        methodCompiler.nthRef(nthRefNode.getMatchNumber());
    }

    public void compileNil(Node node, MethodCompiler methodCompiler) {
        methodCompiler.loadNil();
        methodCompiler.pollThreadEvents();
    }

    public void compileNot(Node node, MethodCompiler methodCompiler) {
        NotNode notNode = (NotNode)node;
        this.compile(notNode.getConditionNode(), methodCompiler);
        methodCompiler.negateCurrentValue();
    }

    public void compileOpAsgnAnd(Node node, MethodCompiler methodCompiler) {
        final BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)((Object)node);
        this.compile(binaryOperatorNode.getFirstNode(), methodCompiler);
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(binaryOperatorNode.getSecondNode(), methodCompiler);
            }
        };
        methodCompiler.performLogicalAnd(branchCallback);
        methodCompiler.pollThreadEvents();
    }

    public void compileOpAsgnOr(Node node, MethodCompiler methodCompiler) {
        final OpAsgnOrNode opAsgnOrNode = (OpAsgnOrNode)node;
        this.compileGetDefinitionBase(opAsgnOrNode.getFirstNode(), methodCompiler);
        methodCompiler.isNull(new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opAsgnOrNode.getSecondNode(), methodCompiler);
            }
        }, new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opAsgnOrNode.getFirstNode(), methodCompiler);
                methodCompiler.duplicateCurrentValue();
                methodCompiler.performBooleanBranch(new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler methodCompiler) {
                        methodCompiler.consumeCurrentValue();
                        ASTCompiler.this.compile(opAsgnOrNode.getSecondNode(), methodCompiler);
                    }
                });
            }
        });
        methodCompiler.pollThreadEvents();
    }

    public void compileOpAsgn(Node node, MethodCompiler methodCompiler) {
        OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        if (opAsgnNode.getOperatorName().equals("||")) {
            this.compileOpAsgnWithOr(opAsgnNode, methodCompiler);
        } else if (opAsgnNode.getOperatorName().equals("&&")) {
            this.compileOpAsgnWithAnd(opAsgnNode, methodCompiler);
        } else {
            this.compileOpAsgnWithMethod(opAsgnNode, methodCompiler);
        }
        methodCompiler.pollThreadEvents();
    }

    public void compileOpAsgnWithOr(Node node, MethodCompiler methodCompiler) {
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opAsgnNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = this.getArgsCallback(opAsgnNode.getValueNode());
        methodCompiler.getInvocationCompiler().invokeOpAsgnWithOr(opAsgnNode.getVariableName(), opAsgnNode.getVariableNameAsgn(), compilerCallback, argumentsCallback);
    }

    public void compileOpAsgnWithAnd(Node node, MethodCompiler methodCompiler) {
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opAsgnNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = this.getArgsCallback(opAsgnNode.getValueNode());
        methodCompiler.getInvocationCompiler().invokeOpAsgnWithAnd(opAsgnNode.getVariableName(), opAsgnNode.getVariableNameAsgn(), compilerCallback, argumentsCallback);
    }

    public void compileOpAsgnWithMethod(Node node, MethodCompiler methodCompiler) {
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opAsgnNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

            public int getArity() {
                return 1;
            }

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.getInvocationCompiler().invokeOpAsgnWithMethod(opAsgnNode.getOperatorName(), opAsgnNode.getVariableName(), opAsgnNode.getVariableNameAsgn(), compilerCallback, argumentsCallback);
    }

    public void compileOpElementAsgn(Node node, MethodCompiler methodCompiler) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        if (opElementAsgnNode.getOperatorName() == "||") {
            this.compileOpElementAsgnWithOr(node, methodCompiler);
        } else if (opElementAsgnNode.getOperatorName() == "&&") {
            this.compileOpElementAsgnWithAnd(node, methodCompiler);
        } else {
            this.compileOpElementAsgnWithMethod(node, methodCompiler);
        }
    }

    public void compileOpElementAsgnWithOr(Node node, MethodCompiler methodCompiler) {
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opElementAsgnNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

            public int getArity() {
                Node node = opElementAsgnNode.getArgsNode();
                switch (node.nodeId) {
                    case ARGSCATNODE: 
                    case ARGSPUSHNODE: 
                    case SPLATNODE: {
                        return -1;
                    }
                    case ARRAYNODE: {
                        ArrayNode arrayNode = (ArrayNode)node;
                        if (arrayNode.size() == 0) {
                            return 0;
                        }
                        if (arrayNode.size() > 3) {
                            return -1;
                        }
                        return ((ArrayNode)node).size();
                    }
                }
                return 1;
            }

            public void call(MethodCompiler methodCompiler) {
                if (this.getArity() == 1) {
                    ASTCompiler.this.compile(((ArrayNode)opElementAsgnNode.getArgsNode()).get(0), methodCompiler);
                } else {
                    ASTCompiler.this.compileArguments(opElementAsgnNode.getArgsNode(), methodCompiler);
                }
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opElementAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.getInvocationCompiler().opElementAsgnWithOr(compilerCallback, argumentsCallback, compilerCallback2);
    }

    public void compileOpElementAsgnWithAnd(Node node, MethodCompiler methodCompiler) {
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opElementAsgnNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

            public int getArity() {
                Node node = opElementAsgnNode.getArgsNode();
                switch (node.nodeId) {
                    case ARGSCATNODE: 
                    case ARGSPUSHNODE: 
                    case SPLATNODE: {
                        return -1;
                    }
                    case ARRAYNODE: {
                        ArrayNode arrayNode = (ArrayNode)node;
                        if (arrayNode.size() == 0) {
                            return 0;
                        }
                        if (arrayNode.size() > 3) {
                            return -1;
                        }
                        return ((ArrayNode)node).size();
                    }
                }
                return 1;
            }

            public void call(MethodCompiler methodCompiler) {
                if (this.getArity() == 1) {
                    ASTCompiler.this.compile(((ArrayNode)opElementAsgnNode.getArgsNode()).get(0), methodCompiler);
                } else {
                    ASTCompiler.this.compileArguments(opElementAsgnNode.getArgsNode(), methodCompiler);
                }
            }
        };
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opElementAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.getInvocationCompiler().opElementAsgnWithAnd(compilerCallback, argumentsCallback, compilerCallback2);
    }

    public void compileOpElementAsgnWithMethod(Node node, MethodCompiler methodCompiler) {
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opElementAsgnNode.getReceiverNode(), methodCompiler);
            }
        };
        ArgumentsCallback argumentsCallback = this.getArgsCallback(opElementAsgnNode.getArgsNode());
        CompilerCallback compilerCallback2 = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(opElementAsgnNode.getValueNode(), methodCompiler);
            }
        };
        methodCompiler.getInvocationCompiler().opElementAsgnWithMethod(compilerCallback, argumentsCallback, compilerCallback2, opElementAsgnNode.getOperatorName());
    }

    public void compileOr(Node node, MethodCompiler methodCompiler) {
        final OrNode orNode = (OrNode)node;
        this.compile(orNode.getFirstNode(), methodCompiler);
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(orNode.getSecondNode(), methodCompiler);
            }
        };
        methodCompiler.performLogicalOr(branchCallback);
    }

    public void compilePostExe(Node node, MethodCompiler methodCompiler) {
        final PostExeNode postExeNode = (PostExeNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (postExeNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(postExeNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.createNewEndBlock(compilerCallback);
    }

    public void compilePreExe(Node node, MethodCompiler methodCompiler) {
        final PreExeNode preExeNode = (PreExeNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                if (preExeNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(preExeNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
            }
        };
        methodCompiler.runBeginBlock(preExeNode.getScope(), compilerCallback);
    }

    public void compileRedo(Node node, MethodCompiler methodCompiler) {
        methodCompiler.issueRedoEvent();
    }

    public void compileRegexp(Node node, MethodCompiler methodCompiler) {
        RegexpNode regexpNode = (RegexpNode)node;
        methodCompiler.createNewRegexp(regexpNode.getValue(), regexpNode.getOptions());
    }

    public void compileRescue(Node node, MethodCompiler methodCompiler) {
        final RescueNode rescueNode = (RescueNode)node;
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (rescueNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(rescueNode.getBodyNode(), methodCompiler);
                } else {
                    methodCompiler.loadNil();
                }
                if (rescueNode.getElseNode() != null) {
                    methodCompiler.consumeCurrentValue();
                    ASTCompiler.this.compile(rescueNode.getElseNode(), methodCompiler);
                }
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                methodCompiler.loadException();
                methodCompiler.unwrapRaiseException();
                methodCompiler.assignGlobalVariable("$!");
                methodCompiler.consumeCurrentValue();
                ASTCompiler.this.compileRescueBody(rescueNode.getRescueNode(), methodCompiler);
            }
        };
        methodCompiler.rescue(branchCallback, RaiseException.class, branchCallback2, IRubyObject.class);
    }

    public void compileRescueBody(Node node, MethodCompiler methodCompiler) {
        final RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        methodCompiler.loadException();
        methodCompiler.unwrapRaiseException();
        Node node2 = rescueBodyNode.getExceptionNodes();
        if (node2 == null) {
            methodCompiler.loadClass("StandardError");
            methodCompiler.createObjectArray(1);
        } else {
            this.compileArguments(node2, methodCompiler);
        }
        methodCompiler.checkIsExceptionHandled();
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (rescueBodyNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(rescueBodyNode.getBodyNode(), methodCompiler);
                    methodCompiler.loadNil();
                    methodCompiler.assignGlobalVariable("$!");
                    methodCompiler.consumeCurrentValue();
                } else {
                    methodCompiler.loadNil();
                    methodCompiler.assignGlobalVariable("$!");
                }
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (rescueBodyNode.getOptRescueNode() != null) {
                    ASTCompiler.this.compileRescueBody(rescueBodyNode.getOptRescueNode(), methodCompiler);
                } else {
                    methodCompiler.rethrowException();
                }
            }
        };
        methodCompiler.performBooleanBranch(branchCallback, branchCallback2);
    }

    public void compileRetry(Node node, MethodCompiler methodCompiler) {
        methodCompiler.pollThreadEvents();
        methodCompiler.issueRetryEvent();
    }

    public void compileReturn(Node node, MethodCompiler methodCompiler) {
        ReturnNode returnNode = (ReturnNode)node;
        if (returnNode.getValueNode() != null) {
            this.compile(returnNode.getValueNode(), methodCompiler);
        } else {
            methodCompiler.loadNil();
        }
        methodCompiler.performReturn();
    }

    public void compileRoot(Node node, ScriptCompiler scriptCompiler, ASTInspector aSTInspector) {
        this.compileRoot(node, scriptCompiler, aSTInspector, true, true);
    }

    public void compileRoot(Node node, ScriptCompiler scriptCompiler, ASTInspector aSTInspector, boolean bl, boolean bl2) {
        RootNode rootNode = (RootNode)node;
        scriptCompiler.startScript(rootNode.getStaticScope());
        MethodCompiler methodCompiler = scriptCompiler.startMethod("__file__", null, rootNode.getStaticScope(), aSTInspector);
        Node node2 = rootNode.getBodyNode();
        if (node2 != null) {
            if (node2.nodeId == NodeType.BLOCKNODE) {
                BlockNode blockNode = (BlockNode)node2;
                for (int i = 0; i < blockNode.size(); ++i) {
                    if ((i + 1) % RubyInstanceConfig.CHAINED_COMPILE_LINE_COUNT == 0) {
                        methodCompiler = methodCompiler.chainToMethod("__file__from_line_" + (i + 1), aSTInspector);
                    }
                    this.compile(blockNode.get(i), methodCompiler);
                    if (i + 1 >= blockNode.size()) continue;
                    methodCompiler.consumeCurrentValue();
                }
            } else {
                this.compile(node2, methodCompiler);
            }
        } else {
            methodCompiler.loadNil();
        }
        methodCompiler.endMethod();
        scriptCompiler.endScript(bl, bl2);
    }

    public void compileSelf(Node node, MethodCompiler methodCompiler) {
        methodCompiler.retrieveSelf();
    }

    public void compileSplat(Node node, MethodCompiler methodCompiler) {
        SplatNode splatNode = (SplatNode)node;
        this.compile(splatNode.getValue(), methodCompiler);
        methodCompiler.splatCurrentValue();
    }

    public void compileStr(Node node, MethodCompiler methodCompiler) {
        StrNode strNode = (StrNode)node;
        methodCompiler.createNewString(strNode.getValue());
    }

    public void compileSuper(Node node, MethodCompiler methodCompiler) {
        final SuperNode superNode = (SuperNode)node;
        CompilerCallback compilerCallback = new CompilerCallback(){

            public void call(MethodCompiler methodCompiler) {
                ASTCompiler.this.compileArguments(superNode.getArgsNode(), methodCompiler);
            }
        };
        if (superNode.getIterNode() == null) {
            if (superNode.getArgsNode() != null) {
                methodCompiler.getInvocationCompiler().invokeSuper(compilerCallback, null);
            } else {
                methodCompiler.getInvocationCompiler().invokeSuper(null, null);
            }
        } else {
            CompilerCallback compilerCallback2 = this.getBlock(superNode.getIterNode());
            if (superNode.getArgsNode() != null) {
                methodCompiler.getInvocationCompiler().invokeSuper(compilerCallback, compilerCallback2);
            } else {
                methodCompiler.getInvocationCompiler().invokeSuper(null, compilerCallback2);
            }
        }
    }

    public void compileSValue(Node node, MethodCompiler methodCompiler) {
        SValueNode sValueNode = (SValueNode)node;
        this.compile(sValueNode.getValue(), methodCompiler);
        methodCompiler.singlifySplattedValue();
    }

    public void compileSymbol(Node node, MethodCompiler methodCompiler) {
        methodCompiler.createNewSymbol(((SymbolNode)node).getName());
    }

    public void compileToAry(Node node, MethodCompiler methodCompiler) {
        ToAryNode toAryNode = (ToAryNode)node;
        this.compile(toAryNode.getValue(), methodCompiler);
        methodCompiler.aryToAry();
    }

    public void compileTrue(Node node, MethodCompiler methodCompiler) {
        methodCompiler.loadTrue();
        methodCompiler.pollThreadEvents();
    }

    public void compileUndef(Node node, MethodCompiler methodCompiler) {
        methodCompiler.undefMethod(((UndefNode)node).getName());
    }

    public void compileUntil(Node node, MethodCompiler methodCompiler) {
        final UntilNode untilNode = (UntilNode)node;
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(untilNode.getConditionNode(), methodCompiler);
                methodCompiler.negateCurrentValue();
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (untilNode.getBodyNode() == null) {
                    methodCompiler.loadNil();
                    return;
                }
                ASTCompiler.this.compile(untilNode.getBodyNode(), methodCompiler);
            }
        };
        if (untilNode.containsNonlocalFlow) {
            methodCompiler.performBooleanLoopSafe(branchCallback, branchCallback2, untilNode.evaluateAtStart());
        } else {
            methodCompiler.performBooleanLoopLight(branchCallback, branchCallback2, untilNode.evaluateAtStart());
        }
        methodCompiler.pollThreadEvents();
    }

    public void compileVAlias(Node node, MethodCompiler methodCompiler) {
        VAliasNode vAliasNode = (VAliasNode)node;
        methodCompiler.aliasGlobal(vAliasNode.getNewName(), vAliasNode.getOldName());
    }

    public void compileVCall(Node node, MethodCompiler methodCompiler) {
        VCallNode vCallNode = (VCallNode)node;
        methodCompiler.getInvocationCompiler().invokeDynamic(vCallNode.getName(), null, null, CallType.VARIABLE, null, false);
    }

    public void compileWhile(Node node, MethodCompiler methodCompiler) {
        final WhileNode whileNode = (WhileNode)node;
        BranchCallback branchCallback = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                ASTCompiler.this.compile(whileNode.getConditionNode(), methodCompiler);
            }
        };
        BranchCallback branchCallback2 = new BranchCallback(){

            public void branch(MethodCompiler methodCompiler) {
                if (whileNode.getBodyNode() == null) {
                    methodCompiler.loadNil();
                } else {
                    ASTCompiler.this.compile(whileNode.getBodyNode(), methodCompiler);
                }
            }
        };
        if (whileNode.containsNonlocalFlow) {
            methodCompiler.performBooleanLoopSafe(branchCallback, branchCallback2, whileNode.evaluateAtStart());
        } else {
            methodCompiler.performBooleanLoopLight(branchCallback, branchCallback2, whileNode.evaluateAtStart());
        }
        methodCompiler.pollThreadEvents();
    }

    public void compileXStr(Node node, MethodCompiler methodCompiler) {
        final XStrNode xStrNode = (XStrNode)node;
        ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

            public int getArity() {
                return 1;
            }

            public void call(MethodCompiler methodCompiler) {
                methodCompiler.createNewString(xStrNode.getValue());
            }
        };
        methodCompiler.getInvocationCompiler().invokeDynamic("`", null, argumentsCallback, CallType.FUNCTIONAL, null, false);
    }

    public void compileYield(Node node, MethodCompiler methodCompiler) {
        YieldNode yieldNode = (YieldNode)node;
        if (yieldNode.getArgsNode() != null) {
            this.compile(yieldNode.getArgsNode(), methodCompiler);
        }
        methodCompiler.getInvocationCompiler().yield(yieldNode.getArgsNode() != null, yieldNode.getCheckState());
    }

    public void compileZArray(Node node, MethodCompiler methodCompiler) {
        methodCompiler.createEmptyArray();
    }

    public void compileZSuper(Node node, MethodCompiler methodCompiler) {
        ZSuperNode zSuperNode = (ZSuperNode)node;
        CompilerCallback compilerCallback = this.getBlock(zSuperNode.getIterNode());
        methodCompiler.callZSuper(compilerCallback);
    }

    public void compileArgsCatArguments(Node node, MethodCompiler methodCompiler) {
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        this.compileArguments(argsCatNode.getFirstNode(), methodCompiler);
        methodCompiler.createNewArray(true);
        this.compile(argsCatNode.getSecondNode(), methodCompiler);
        methodCompiler.splatCurrentValue();
        methodCompiler.concatArrays();
        methodCompiler.convertToJavaArray();
    }

    public void compileArgsPushArguments(Node node, MethodCompiler methodCompiler) {
        ArgsPushNode argsPushNode = (ArgsPushNode)node;
        this.compile(argsPushNode.getFirstNode(), methodCompiler);
        this.compile(argsPushNode.getSecondNode(), methodCompiler);
        methodCompiler.appendToArray();
        methodCompiler.convertToJavaArray();
    }

    public void compileArrayArguments(Node node, MethodCompiler methodCompiler) {
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayCallback arrayCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler methodCompiler, Object object, int n) {
                Node node = (Node)((Object[])object)[n];
                ASTCompiler.this.compile(node, methodCompiler);
            }
        };
        methodCompiler.setLinePosition(arrayNode.getPosition());
        methodCompiler.createObjectArray(arrayNode.childNodes().toArray(), arrayCallback);
    }

    public void compileSplatArguments(Node node, MethodCompiler methodCompiler) {
        SplatNode splatNode = (SplatNode)node;
        this.compile(splatNode.getValue(), methodCompiler);
        methodCompiler.splatCurrentValue();
        methodCompiler.convertToJavaArray();
    }

    public static void confirmNodeIsSafe(Node node) {
        switch (node.nodeId) {
            case ARGSNODE: {
                ArgsNode argsNode = (ArgsNode)node;
                if (argsNode.getOptArgs() == null || argsNode.getOptArgs().size() <= 0) break;
                int n = argsNode.getRequiredArgsCount() - 1;
                for (int i = 0; i < argsNode.getOptArgs().size(); ++i) {
                    int n2 = ((LocalAsgnNode)argsNode.getOptArgs().get(i)).getIndex();
                    if (n2 - n != 1) {
                        throw new NotCompilableException("Can't compile def with optional args that assign other variables at: " + node.getPosition());
                    }
                    n = n2;
                }
                break;
            }
        }
    }

    public class SpecificArityArguments
    implements ArgumentsCallback {
        private int arity;
        private Node node;

        public SpecificArityArguments(Node node) {
            this.arity = node.nodeId == NodeType.ARRAYNODE && ((ArrayNode)node).isLightweight() ? ((ArrayNode)node).size() : 1;
            this.node = node;
        }

        public int getArity() {
            return this.arity;
        }

        public void call(MethodCompiler methodCompiler) {
            if (this.node.nodeId == NodeType.ARRAYNODE) {
                ArrayNode arrayNode = (ArrayNode)this.node;
                if (arrayNode.isLightweight()) {
                    for (Node node : arrayNode.childNodes()) {
                        ASTCompiler.this.compile(node, methodCompiler);
                    }
                } else {
                    ASTCompiler.this.compile(arrayNode, methodCompiler);
                }
            } else {
                ASTCompiler.this.compile(this.node, methodCompiler);
            }
        }
    }

    public class VariableArityArguments
    implements ArgumentsCallback {
        private Node node;

        public VariableArityArguments(Node node) {
            this.node = node;
        }

        public int getArity() {
            return -1;
        }

        public void call(MethodCompiler methodCompiler) {
            ASTCompiler.this.compileArguments(this.node, methodCompiler);
        }
    }
}

