/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewlineNode
extends Node {
    private final Node nextNode;

    public NewlineNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.NEWLINENODE);
        assert (node != null) : "nextNode is not null";
        this.nextNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitNewlineNode(this);
    }

    public Node getNextNode() {
        return this.nextNode;
    }

    @Override
    public List<Node> childNodes() {
        return NewlineNode.createList(this.nextNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        ISourcePosition iSourcePosition = this.getPosition();
        threadContext.setFile(iSourcePosition.getFile());
        threadContext.setLine(iSourcePosition.getStartLine());
        if (ruby.hasEventHooks()) {
            ASTInterpreter.callTraceFunction(ruby, threadContext, 0);
        }
        return this.nextNode.interpret(ruby, threadContext, iRubyObject, block);
    }
}

