/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IArityNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstVarNode
extends Node
implements IArityNode,
INameNode {
    private String name;

    public InstVarNode(ISourcePosition iSourcePosition, String string) {
        super(iSourcePosition, NodeType.INSTVARNODE);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitInstVarNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.noArguments();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable(this.name);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        ruby.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, this.getPosition(), "instance variable " + this.name + " not initialized", this.name);
        return ruby.getNil();
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return iRubyObject.getInstanceVariables().fastHasInstanceVariable(this.name) ? "instance-variable" : null;
    }
}

