/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;

    public GlobalAsgnNode(ISourcePosition iSourcePosition, String string, Node node) {
        super(iSourcePosition, NodeType.GLOBALASGNNODE, node);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitGlobalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return GlobalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.getValueNode().interpret(ruby, threadContext, iRubyObject, block);
        ruby.getGlobalVariables().set(this.name, iRubyObject2);
        return iRubyObject2;
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        ruby.getGlobalVariables().set(this.name, iRubyObject2);
        return ruby.getNil();
    }
}

