/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.DStrNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.StrNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DSymbolNode
extends ListNode {
    public DSymbolNode(ISourcePosition iSourcePosition, DStrNode dStrNode) {
        super(iSourcePosition, NodeType.DSYMBOLNODE);
        assert (dStrNode != null) : "node is not null";
        this.addAll(dStrNode);
    }

    public DSymbolNode(ISourcePosition iSourcePosition) {
        super(iSourcePosition, NodeType.DSYMBOLNODE);
    }

    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDSymbolNode(this);
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < this.size(); ++i) {
            Node node = this.get(i);
            if (node instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node).getValue());
                continue;
            }
            rubyString.append(node.interpret(ruby, threadContext, iRubyObject, block));
        }
        return ruby.newSymbol(rubyString.toString());
    }
}

