/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarDeclNode
extends AssignableNode
implements INameNode {
    private String name;

    public ClassVarDeclNode(ISourcePosition iSourcePosition, String string, Node node) {
        super(iSourcePosition, NodeType.CLASSVARDECLNODE, node);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitClassVarDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return ClassVarDeclNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            throw ruby.newTypeError("no class/module to define class variable");
        }
        return rubyModule.fastSetClassVar(this.name, this.getValueNode().interpret(ruby, threadContext, iRubyObject, block));
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        if (ruby.getVerbose().isTrue() && threadContext.getRubyClass().isSingleton()) {
            ruby.getWarnings().warn(IRubyWarnings.ID.DECLARING_SCLASS_VARIABLE, this.getPosition(), "Declaring singleton class variable.", new Object[0]);
        }
        ASTInterpreter.getClassVariableBase(threadContext, ruby).fastSetClassVar(this.name, iRubyObject2);
        return ruby.getNil();
    }
}

