/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends RubyMethod {
    protected RubyUnboundMethod(Ruby ruby) {
        super(ruby, ruby.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule rubyModule, String string, RubyModule rubyModule2, String string2, DynamicMethod dynamicMethod) {
        RubyUnboundMethod rubyUnboundMethod = new RubyUnboundMethod(rubyModule.getRuntime());
        rubyUnboundMethod.implementationModule = rubyModule;
        rubyUnboundMethod.methodName = string;
        rubyUnboundMethod.originModule = rubyModule2;
        rubyUnboundMethod.originName = string2;
        rubyUnboundMethod.method = dynamicMethod;
        return rubyUnboundMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("UnboundMethod", ruby.getMethod(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setUnboundMethod(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyUnboundMethod.class);
        return rubyClass;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        throw threadContext.getRuntime().newTypeError("you cannot call unbound method; bind first");
    }

    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block block) {
        return this;
    }

    @JRubyMethod(name={"bind"}, required=1, frame=true)
    public RubyMethod bind(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyClass rubyClass = iRubyObject.getMetaClass();
        if (!this.originModule.isInstance(iRubyObject)) {
            if (this.originModule instanceof MetaClass) {
                throw threadContext.getRuntime().newTypeError("singleton method called for a different object");
            }
            if (rubyClass instanceof MetaClass && rubyClass.getMethods().containsKey(this.originName)) {
                throw threadContext.getRuntime().newTypeError("method `" + this.originName + "' overridden");
            }
            if (!(!this.originModule.isModule() ? iRubyObject.getType() == this.originModule : this.originModule.isInstance(iRubyObject))) {
                throw threadContext.getRuntime().newTypeError("bind argument must be an instance of " + this.originModule.getName());
            }
        }
        return RubyMethod.newMethod(this.implementationModule, this.methodName, rubyClass, this.originName, this.method, iRubyObject);
    }

    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
    }

    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(ThreadContext threadContext, Block block) {
        return super.to_proc(threadContext, block);
    }
}

