/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject {
    public static final ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return ruby.getNil();
        }
    };

    public RubyNil(Ruby ruby) {
        super(ruby, ruby.getNilClass(), false);
        this.flags |= 3;
    }

    public static RubyClass createNilClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("NilClass", ruby.getObject(), NIL_ALLOCATOR);
        ruby.setNilClass(rubyClass);
        rubyClass.index = 5;
        rubyClass.defineAnnotatedMethods(RubyNil.class);
        rubyClass.getMetaClass().undefineMethod("new");
        return rubyClass;
    }

    public int getNativeTypeIndex() {
        return 5;
    }

    public boolean isImmediate() {
        return true;
    }

    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @JRubyMethod(name={"to_i"})
    public static RubyFixnum to_i(IRubyObject iRubyObject) {
        return RubyFixnum.zero(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"to_f"})
    public static RubyFloat to_f(IRubyObject iRubyObject) {
        return RubyFloat.newFloat(iRubyObject.getRuntime(), 0.0);
    }

    @JRubyMethod(name={"to_s"})
    public static RubyString to_s(IRubyObject iRubyObject) {
        return RubyString.newEmptyString(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"to_a"})
    public static RubyArray to_a(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newEmptyArray();
    }

    @JRubyMethod(name={"inspect"})
    public static RubyString inspect(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newString("nil");
    }

    @JRubyMethod(name={"type"})
    public static RubyClass type(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getNilClass();
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newBoolean(iRubyObject2.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newBoolean(iRubyObject2.isTrue());
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4);
    }

    public IRubyObject taint(ThreadContext threadContext) {
        return this;
    }

    public IRubyObject freeze(ThreadContext threadContext) {
        return this;
    }
}

