/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.jar.JarFile;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

@JRubyModule(name={"FileTest"})
public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("FileTest");
        ruby.setFileTest(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyFileTest.class);
        return rubyModule;
    }

    @JRubyMethod(name={"blockdev?"}, required=1, module=true)
    public static IRubyObject blockdev_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isBlockDev());
    }

    @JRubyMethod(name={"chardev?"}, required=1, module=true)
    public static IRubyObject chardev_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isCharDev());
    }

    @JRubyMethod(name={"directory?"}, required=1, module=true)
    public static IRubyObject directory_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isDirectory());
    }

    @JRubyMethod(name={"executable?"}, required=1, module=true)
    public static IRubyObject executable_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isExecutable());
    }

    @JRubyMethod(name={"executable_real?"}, required=1, module=true)
    public static IRubyObject executable_real_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isExecutableReal());
    }

    @JRubyMethod(name={"exist?", "exists?"}, required=1, module=true)
    public static IRubyObject exist_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (Ruby.isSecurityRestricted()) {
            return iRubyObject.getRuntime().getFalse();
        }
        if (iRubyObject2.convertToString().toString().startsWith("file:")) {
            String string = iRubyObject2.convertToString().toString().substring(5);
            int n = string.indexOf(33);
            if (n == -1 || n == string.length() - 1) {
                return iRubyObject.getRuntime().getFalse();
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            try {
                JarFile jarFile = new JarFile(string2);
                if (jarFile.getJarEntry(string3) != null) {
                    return iRubyObject.getRuntime().getTrue();
                }
                return iRubyObject.getRuntime().getFalse();
            }
            catch (Exception exception) {
                return iRubyObject.getRuntime().getFalse();
            }
        }
        return iRubyObject.getRuntime().newBoolean(RubyFileTest.file(iRubyObject2).exists());
    }

    @JRubyMethod(name={"file?"}, required=1, module=true)
    public static RubyBoolean file_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return iRubyObject2.getRuntime().newBoolean(jRubyFile.exists() && jRubyFile.isFile());
    }

    @JRubyMethod(name={"grpowned?"}, required=1, module=true)
    public static IRubyObject grpowned_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isGroupOwned());
    }

    @JRubyMethod(name={"identical?"}, required=2, module=true)
    public static IRubyObject identical_p(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        JRubyFile jRubyFile2 = RubyFileTest.file(iRubyObject3);
        return ruby.newBoolean(jRubyFile.exists() && jRubyFile2.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isIdentical(ruby.getPosix().stat(jRubyFile2.getAbsolutePath())));
    }

    @JRubyMethod(name={"owned?"}, required=1, module=true)
    public static IRubyObject owned_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isOwned());
    }

    @JRubyMethod(name={"pipe?"}, required=1, module=true)
    public static IRubyObject pipe_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isNamedPipe());
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, required=1, module=true)
    public static IRubyObject readable_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return iRubyObject.getRuntime().newBoolean(jRubyFile.exists() && jRubyFile.canRead());
    }

    public static IRubyObject rowned_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isROwned());
    }

    @JRubyMethod(name={"setgid?"}, required=1, module=true)
    public static IRubyObject setgid_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isSetgid());
    }

    @JRubyMethod(name={"setuid?"}, required=1, module=true)
    public static IRubyObject setuid_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isSetuid());
    }

    @JRubyMethod(name={"size"}, required=1, module=true)
    public static IRubyObject size(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        if (!jRubyFile.exists()) {
            RubyFileTest.noFileError(iRubyObject2);
        }
        return iRubyObject.getRuntime().newFixnum(jRubyFile.length());
    }

    @JRubyMethod(name={"size?"}, required=1, module=true)
    public static IRubyObject size_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        if (!jRubyFile.exists()) {
            return iRubyObject.getRuntime().getNil();
        }
        long l = jRubyFile.length();
        if (l > 0L) {
            return iRubyObject.getRuntime().newFixnum(l);
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"socket?"}, required=1, module=true)
    public static IRubyObject socket_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isSocket());
    }

    @JRubyMethod(name={"sticky?"}, required=1, module=true)
    public static IRubyObject sticky_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return ruby.newBoolean(jRubyFile.exists() && ruby.getPosix().stat(jRubyFile.getAbsolutePath()).isSticky());
    }

    @JRubyMethod(name={"symlink?"}, required=1, module=true)
    public static RubyBoolean symlink_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        try {
            return ruby.newBoolean(ruby.getPosix().lstat(jRubyFile.getAbsolutePath()).isSymlink());
        }
        catch (RaiseException raiseException) {
            return ruby.getFalse();
        }
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, required=1, module=true)
    public static RubyBoolean writable_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject2.getRuntime().newBoolean(RubyFileTest.file(iRubyObject2).canWrite());
    }

    @JRubyMethod(name={"zero?"}, required=1, module=true)
    public static RubyBoolean zero_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JRubyFile jRubyFile = RubyFileTest.file(iRubyObject2);
        return iRubyObject2.getRuntime().newBoolean(jRubyFile.exists() && jRubyFile.length() == 0L);
    }

    private static JRubyFile file(IRubyObject iRubyObject) {
        String string = iRubyObject.convertToString().toString();
        return JRubyFile.create(iRubyObject.getRuntime().getCurrentDirectory(), string);
    }

    private static void noFileError(IRubyObject iRubyObject) {
        throw iRubyObject.getRuntime().newErrnoENOENTError("No such file or directory - " + iRubyObject.convertToString());
    }
}

