/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class RailsJdbcAsAdapterConnection
implements RailsDatabaseConfiguration {
    private static final Pattern PATTERN = Pattern.compile("jdbc:(\\w+)://(.+):(\\d+)/(\\w+)");
    private final DatabaseConnection development;
    private final DatabaseConnection test;
    private final DatabaseConnection production;

    public RailsJdbcAsAdapterConnection(DatabaseConnection databaseConnection, DatabaseConnection databaseConnection2, DatabaseConnection databaseConnection3) {
        this.development = databaseConnection;
        this.test = databaseConnection2;
        this.production = databaseConnection3;
    }

    public String railsGenerationParam() {
        return null;
    }

    public void editConfig(RailsProject railsProject) {
        this.editDatabaseYml(railsProject.getProjectDirectory());
    }

    public JdbcInfo getJdbcInfo() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatabaseYml(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("config/database.yml");
        if (fileObject2 != null) {
            BaseDocument baseDocument = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    if (styledDocument instanceof BaseDocument) {
                        baseDocument = (BaseDocument)styledDocument;
                        baseDocument.atomicLock();
                    }
                    styledDocument.remove(0, styledDocument.getLength());
                    String string = null;
                    String string2 = fileObject.getName();
                    string = "development:\n" + this.buildConnectionConf(this.development) + "\n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + this.buildConnectionConf(this.test) + "\n" + "production:\n" + this.buildConnectionConf(this.production);
                    styledDocument.insertString(0, string, null);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (baseDocument != null) {
                    baseDocument.atomicUnlock();
                }
            }
        }
    }

    private String buildConnectionConf(DatabaseConnection databaseConnection) {
        AdapterParameters adapterParameters = databaseConnection != null ? RailsJdbcAsAdapterConnection.resolveAdapterParams(databaseConnection.getDatabaseURL()) : AdapterParameters.DEFAULT;
        String string = "      host: " + adapterParameters.getHostName() + "\n" + "      adapter: " + adapterParameters.getAdapterName() + "\n";
        if (databaseConnection == null) {
            return string;
        }
        String string2 = databaseConnection.getPassword() == null ? "" : databaseConnection.getPassword();
        return string + "      database: " + adapterParameters.getDatabase() + "\n" + "      port: " + adapterParameters.getPort() + "\n" + "      username: " + databaseConnection.getUser() + "\n" + "      password: " + string2 + "\n";
    }

    static AdapterParameters resolveAdapterParams(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.find() || matcher.groupCount() < 4) {
            return AdapterParameters.DEFAULT;
        }
        return new AdapterParameters(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
    }

    static class AdapterParameters {
        private final String adapterName;
        private final String hostName;
        private final String port;
        private final String database;
        static final AdapterParameters DEFAULT = new AdapterParameters("mysql", "localhost", "3306", "");

        AdapterParameters(String string, String string2, String string3, String string4) {
            this.adapterName = string;
            this.hostName = string2;
            this.port = string3;
            this.database = string4;
        }

        public String getAdapterName() {
            return this.adapterName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getPort() {
            return this.port;
        }

        public String getDatabase() {
            return this.database;
        }
    }
}

