/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.gems.GemAction;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorPanel
extends JPanel
implements Runnable {
    private ChangeListener changeListener;
    private List<Generator> generators = new ArrayList<Generator>();
    private Project project;
    private ButtonGroup actionTypeButtonGroup;
    private JRadioButton destroyButton;
    private ButtonGroup forceGroup;
    private JLabel forceLabel;
    private JRadioButton generateButton;
    private JLabel generateLabel;
    private JButton installGeneratorsButton;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel nameLabel;
    private JTextField nameText;
    private JPanel optionsPanel;
    private JRadioButton overwriteRadio;
    private JLabel parameter1Label;
    private JTextField parameter1Text;
    private JLabel parameter2Label;
    private JTextField parameter2Text;
    private JCheckBox pretendCB;
    private JRadioButton skipRadio;
    private JComboBox typeCombo;
    private JTextArea usageText;

    public GeneratorPanel(Project project, Generator generator) {
        this.project = project;
        this.initComponents();
        this.actionTypeButtonGroup.add(this.generateButton);
        this.actionTypeButtonGroup.add(this.destroyButton);
        this.generateButton.setSelected(true);
        if (generator != Generator.NONE) {
            this.typeCombo.setSelectedItem(generator.getName());
        }
        this.showGenerator(generator);
        this.typeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = itemEvent.getItem().toString();
                    for (Generator generator : GeneratorPanel.this.generators) {
                        if (!generator.getName().equals(string)) continue;
                        GeneratorPanel.this.showGenerator(generator);
                    }
                    GeneratorPanel.this.changeListener.stateChanged(new ChangeEvent(itemEvent));
                }
            }
        });
        this.nameText.requestFocus();
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (GeneratorPanel.this.changeListener != null) {
                    GeneratorPanel.this.changeListener.stateChanged(new ChangeEvent(documentEvent));
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (GeneratorPanel.this.changeListener != null) {
                    GeneratorPanel.this.changeListener.stateChanged(new ChangeEvent(documentEvent));
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    void setInitialState(String string, String string2) {
        assert (string != null);
        this.nameText.setText(string);
        if (string2 != null) {
            this.parameter1Text.setText(string2);
        }
    }

    private Generator getSelectedGenerator() {
        String string = this.typeCombo.getSelectedItem().toString();
        for (Generator generator : this.generators) {
            if (!generator.getName().equals(string)) continue;
            return generator;
        }
        return Generator.NONE;
    }

    void setForcing(boolean bl) {
        this.overwriteRadio.setSelected(bl);
        this.skipRadio.setSelected(!bl);
    }

    void setPretend(boolean bl) {
        this.pretendCB.setSelected(bl);
    }

    private ComboBoxModel getTypeModel() {
        this.generators = this.findGenerators();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Generator generator : this.generators) {
            if (generator == Generator.NONE) continue;
            arrayList.add(generator.getName());
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        return defaultComboBoxModel;
    }

    private FileObject getRailsHome() {
        Object object;
        String string = System.getenv("HOME");
        if (string == null) {
            string = System.getenv("USERPROFILE");
        }
        if (string == null) {
            object = System.getenv("HOMEDRIVE");
            String string2 = System.getenv("HOMEPATH");
            if (object != null && string2 != null) {
                string = (String)object + ":" + string2;
            }
        }
        if (string == null) {
            try {
                object = new File("~");
                object = ((File)object).getCanonicalFile().getAbsoluteFile();
                if (((File)object).exists()) {
                    string = ((File)object).getAbsolutePath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = System.getProperty("user.home");
        }
        if (string != null && ((File)(object = new File(string))).exists()) {
            try {
                object = ((File)object).getCanonicalFile();
                return FileUtil.toFileObject((File)object);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private void findGeneratorDirs(List<FileObject> list, FileObject fileObject, String string) {
        if (!fileObject.isFolder()) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null) {
            return;
        }
        if (string == null || fileObject.getName().equals(string)) {
            for (FileObject fileObject2 : fileObjectArray) {
                if (!fileObject2.isFolder()) continue;
                list.add(fileObject2);
            }
        } else {
            for (FileObject fileObject3 : fileObjectArray) {
                if (!fileObject3.isFolder()) continue;
                this.findGeneratorDirs(list, fileObject3, string);
            }
        }
    }

    private void scan(List<Generator> list, FileObject fileObject, String string, String string2, Set<String> set) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            return;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.findGeneratorDirs(arrayList, fileObject2, string2);
        for (FileObject fileObject3 : arrayList) {
            String string3 = fileObject3.getName();
            if (set.contains(string3)) continue;
            int n = 0;
            Generator generator = new Generator(string3, fileObject3, n);
            list.add(generator);
            set.add(string3);
        }
    }

    private List<Generator> findGenerators() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        GemManager gemManager;
        HashSet<String> hashSet = new HashSet<String>();
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<Generator> arrayList = new ArrayList<Generator>();
        this.scan(arrayList, fileObject, "lib/generators", null, hashSet);
        this.scan(arrayList, fileObject, "vendor/generators", null, hashSet);
        this.scan(arrayList, fileObject, "vendor/plugins", "generators", hashSet);
        FileObject fileObject2 = this.getRailsHome();
        if (fileObject2 != null) {
            this.scan(arrayList, fileObject2, ".rails/generators", null, hashSet);
        }
        if ((gemManager = RubyPlatform.gemManagerFor((Project)this.project)) != null) {
            for (Object object52 : gemManager.getRepositories()) {
                object4 = new File((File)object52, "gems");
                if (!((File)object4).exists()) continue;
                object3 = gemManager.getInstalledGemsFiles();
                Object object6 = object3.iterator();
                while (object6.hasNext()) {
                    File file;
                    object2 = (String)object6.next();
                    if (hashSet.contains(object2) || !((String)object2).endsWith("_generator") || (object = gemManager.getLatestVersion((String)object2)) == null || !(file = new File((File)object4, (String)object2 + "-" + (String)object)).exists()) continue;
                    FileObject fileObject3 = FileUtil.toFileObject((File)file);
                    int n = 0;
                    String string = ((String)object2).substring(0, ((String)object2).length() - "_generator".length());
                    Generator generator = new Generator(string, fileObject3, n);
                    arrayList.add(generator);
                    hashSet.add(generator.getName());
                }
            }
        }
        Object object7 = RailsProjectUtil.getRailsVersion(this.project);
        object52 = Generator.getBuiltinGenerators((String)object7);
        object4 = object52.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            if (hashSet.contains(((Generator)object3).getName())) continue;
            arrayList.add((Generator)object3);
            hashSet.add(((Generator)object3).getName());
        }
        object4 = this.project.getProjectDirectory().getFileObject("vendor/rails/railties");
        if (object4 != null) {
            this.scan(arrayList, (FileObject)object4, "lib/rails_generator/generators/components", null, hashSet);
        } else if (gemManager != null && (object7 = gemManager.getLatestVersion("rails")) != null) {
            for (Object object6 : gemManager.getRepositories()) {
                object2 = new File((File)object6, "gems");
                if (!((File)object2).exists() || !((File)(object = new File((File)object2, "rails-" + (String)object7))).exists() || (object4 = FileUtil.toFileObject((File)object)) == null) continue;
                this.scan(arrayList, (FileObject)object4, "lib/rails_generator/generators/components", null, hashSet);
            }
        }
        return arrayList;
    }

    public String getGeneratedName() {
        return this.nameText.getText().trim();
    }

    public String getType() {
        Object object = this.typeCombo.getSelectedItem();
        return object != null ? object.toString() : "";
    }

    public String getScript() {
        return this.destroyButton.isSelected() ? "destroy" : "generate";
    }

    public boolean isForce() {
        return this.overwriteRadio.isSelected();
    }

    public boolean isPretend() {
        return this.pretendCB.isSelected();
    }

    private void showGenerator(Generator generator) {
        this.setOptions(generator.getNameLabel(), generator.getArg1Label(), generator.getArg2Label());
        this.showUsage(generator);
    }

    private void showUsage(Generator generator) {
        String string = generator.getUsage(this.project);
        if (string != null) {
            this.usageText.setText(string);
            this.usageText.getCaret().setDot(0);
        } else {
            this.usageText.setText("");
        }
    }

    private void setOptions(String string, String string2, String string3) {
        this.nameLabel.setText(string);
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)string);
        boolean bl = string2 != null;
        this.parameter1Label.setVisible(bl);
        this.parameter1Text.setVisible(bl);
        if (bl) {
            Mnemonics.setLocalizedText((JLabel)this.parameter1Label, (String)string2);
            this.parameter1Label.setLabelFor(this.parameter1Text);
        }
        bl = string3 != null;
        this.parameter2Label.setVisible(bl);
        this.parameter2Text.setVisible(bl);
        if (bl) {
            Mnemonics.setLocalizedText((JLabel)this.parameter2Label, (String)string3);
            this.parameter2Label.setLabelFor(this.parameter2Text);
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public String[] getFirstParameterList() {
        if (this.parameter1Text.isVisible()) {
            return this.parameter1Text.getText().replace(',', ' ').replace("  ", " ").trim().split(" ");
        }
        return null;
    }

    public String[] getSecondParameterList() {
        if (this.parameter2Text.isVisible()) {
            return this.parameter2Text.getText().replace(',', ' ').replace("  ", " ").trim().split(" ");
        }
        return null;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public boolean isValid() {
        Generator generator = this.getSelectedGenerator();
        if (generator == Generator.NONE) {
            return false;
        }
        String string = this.getGeneratedName();
        if (string.length() > 0 || generator.getArgsRequired() < 1) {
            return true;
        }
        String string2 = RubyUtils.getIdentifierWarning((String)string, (int)0);
        if (string2 != null) {
            // empty if block
        }
        return false;
    }

    @Override
    public void run() {
        RubyPlatform.platformFor((Project)this.project).recomputeRoots();
        this.typeCombo.setModel(this.getTypeModel());
        this.typeCombo.invalidate();
        this.typeCombo.repaint();
        Generator generator = this.getSelectedGenerator();
        if (generator != Generator.NONE) {
            this.showGenerator(generator);
        }
    }

    private void initComponents() {
        this.forceGroup = new ButtonGroup();
        this.actionTypeButtonGroup = new ButtonGroup();
        this.generateLabel = new JLabel();
        this.pretendCB = new JCheckBox();
        this.typeCombo = new JComboBox();
        this.skipRadio = new JRadioButton();
        this.overwriteRadio = new JRadioButton();
        this.optionsPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.parameter1Label = new JLabel();
        this.parameter1Text = new JTextField();
        this.parameter2Label = new JLabel();
        this.parameter2Text = new JTextField();
        this.forceLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.usageText = new JTextArea();
        this.jSeparator2 = new JSeparator();
        this.installGeneratorsButton = new JButton();
        this.generateButton = new JRadioButton();
        this.destroyButton = new JRadioButton();
        FormListener formListener = new FormListener();
        this.generateLabel.setLabelFor(this.typeCombo);
        Mnemonics.setLocalizedText((JLabel)this.generateLabel, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.generateLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.pretendCB, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.pretendCB.text"));
        this.typeCombo.setMaximumRowCount(14);
        this.typeCombo.setModel(this.getTypeModel());
        this.forceGroup.add(this.skipRadio);
        this.skipRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.skipRadio, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.skipRadio.text"));
        this.forceGroup.add(this.overwriteRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.overwriteRadio, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.overwriteRadio.text"));
        this.optionsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.optionsPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_NameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.optionsPanel.add((Component)this.nameText, gridBagConstraints);
        this.nameText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_NameText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.optionsPanel.add((Component)this.parameter1Label, gridBagConstraints);
        this.parameter1Label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter1Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionsPanel.add((Component)this.parameter1Text, gridBagConstraints);
        this.parameter1Text.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter1Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.optionsPanel.add((Component)this.parameter2Label, gridBagConstraints);
        this.parameter2Label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter2Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionsPanel.add((Component)this.parameter2Text, gridBagConstraints);
        this.parameter2Text.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter2Text"));
        Mnemonics.setLocalizedText((JLabel)this.forceLabel, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.forceLabel.text"));
        this.usageText.setColumns(20);
        this.usageText.setEditable(false);
        this.usageText.setRows(5);
        this.jScrollPane1.setViewportView(this.usageText);
        this.usageText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_UsageText"));
        Mnemonics.setLocalizedText((AbstractButton)this.installGeneratorsButton, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.installGeneratorsButton.text"));
        this.installGeneratorsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.generateButton, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.generateButton.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.destroyButton, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.destroyButton.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 644, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 644, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.forceLabel).addPreferredGap(0).add((Component)this.skipRadio).addPreferredGap(0).add((Component)this.overwriteRadio)).add((Component)this.optionsPanel, -1, 644, Short.MAX_VALUE).add(1, (Component)this.pretendCB).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.generateLabel).addPreferredGap(0).add((Component)this.typeCombo, -2, -1, -2).add(18, 18, 18).add((Component)this.generateButton).addPreferredGap(0).add((Component)this.destroyButton).addPreferredGap(0, 219, Short.MAX_VALUE).add((Component)this.installGeneratorsButton)).add(1, (Component)this.jSeparator2, -1, 644, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.generateLabel).add((Component)this.typeCombo, -2, -1, -2).add((Component)this.installGeneratorsButton).add((Component)this.generateButton).add((Component)this.destroyButton)).addPreferredGap(0).add((Component)this.optionsPanel, -2, 92, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.forceLabel, -2, 16, -2).add((Component)this.skipRadio).add((Component)this.overwriteRadio)).addPreferredGap(0).add((Component)this.pretendCB).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 207, Short.MAX_VALUE).addContainerGap()));
        this.generateLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_GenerateLabel"));
        this.pretendCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_PretendCB"));
        this.typeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_TypeCombo"));
        this.skipRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_SkipRadio"));
        this.overwriteRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_OverwriteRadio"));
        this.forceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_ForceLabel"));
        this.installGeneratorsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_InstallGeneratorsButton"));
        this.generateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.generateButton.AccessibleContext.accessibleDescription"));
        this.destroyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.destroyButton.AccessibleContext.accessibleDescription"));
    }

    private void installGeneratorsButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = GemAction.showGemManager((String)"generator$", (RubyPlatform)RubyPlatform.platformFor((Project)this.project));
        if (bl) {
            this.run();
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GeneratorPanel.this.installGeneratorsButton) {
                GeneratorPanel.this.installGeneratorsButtonActionPerformed(actionEvent);
            }
        }
    }
}

