/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.RegexpOutputRecognizer;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.GeneratorPanel;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public final class GenerateAction
extends NodeAction {
    public static final String EDITOR_ACTION_NAME = "rails-generator";
    private boolean forcing;
    private boolean preview;

    protected void performAction(Node[] nodeArray) {
        Object object;
        Lookup lookup = nodeArray[0].getLookup();
        RailsProject railsProject = (RailsProject)((Object)lookup.lookup(RailsProject.class));
        if (railsProject == null) {
            object = (DataObject)lookup.lookup(DataObject.class);
            if (object == null) {
                return;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)object.getPrimaryFile());
            if (project instanceof RailsProject) {
                railsProject = (RailsProject)project;
            }
        }
        if (railsProject == null) {
            return;
        }
        if (!RubyPlatform.gemManagerFor((Project)railsProject).isValidRails(true)) {
            return;
        }
        object = (Generator)nodeArray[0].getLookup().lookup(Generator.class);
        if (object == null) {
            object = Generator.CONTROLLER;
        }
        this.generate(railsProject, (Generator)object, null, null, false, false);
    }

    public void generate(Project project, String string, String string2, String string3) {
        assert (string.equals("controller")) : "Only the controller generator is supported";
        Generator generator = Generator.CONTROLLER;
        if (project != null) {
            this.generate((RailsProject)project, generator, string2, string3, true, true);
        } else assert (false);
    }

    public void generate(final RailsProject railsProject, Generator generator, String string, String string2, boolean bl, boolean bl2) {
        String string3;
        final JButton jButton = new JButton(NbBundle.getMessage(GenerateAction.class, (String)"Ok"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateAction.class, (String)"AD_Ok"));
        final GeneratorPanel generatorPanel = new GeneratorPanel((Project)railsProject, generator);
        if (bl2) {
            generatorPanel.setForcing(false);
        } else {
            generatorPanel.setForcing(this.forcing);
        }
        generatorPanel.setPretend(this.preview);
        if (string != null) {
            generatorPanel.setInitialState(string, string2);
        }
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        generatorPanel.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jButton.setEnabled(generatorPanel.isValid());
            }
        });
        jButton.setEnabled(bl);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)generatorPanel, NbBundle.getMessage(GenerateAction.class, (String)"GeneratorTitle"), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(-1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateAction.class, (String)"AD_GeneratorDialog"));
        dialog.setVisible(true);
        boolean bl3 = dialogDescriptor.getValue() != objectArray[0];
        dialog.dispose();
        if (!bl2) {
            this.forcing = generatorPanel.isForce();
        }
        this.preview = generatorPanel.isPretend();
        if (!bl3 && (string3 = generatorPanel.getType()).length() > 0) {
            String[] stringArray;
            String[] stringArray2;
            final FileObject fileObject = railsProject.getProjectDirectory();
            final File file = FileUtil.toFile((FileObject)railsProject.getProjectDirectory());
            final String string4 = "script" + File.separator + generatorPanel.getScript();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string3);
            if (generatorPanel.isForce()) {
                arrayList.add("--force");
            } else {
                arrayList.add("--skip");
            }
            if (generatorPanel.isPretend()) {
                arrayList.add("--pretend");
            }
            if ((stringArray2 = Utilities.parseParameters((String)generatorPanel.getGeneratedName())) != null) {
                stringArray = stringArray2;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string5 = stringArray[i];
                    arrayList.add(string5);
                }
            }
            if ((stringArray = generatorPanel.getFirstParameterList()) != null && stringArray.length > 0 && stringArray[0].length() > 0) {
                for (String string6 : stringArray) {
                    arrayList.add(string6);
                }
                String[] stringArray3 = generatorPanel.getSecondParameterList();
                if (stringArray3 != null && stringArray3.length > 0 && stringArray3[0].length() > 0) {
                    for (String string7 : stringArray3) {
                        arrayList.add(string7);
                    }
                }
            }
            final String[] stringArray4 = arrayList.toArray(new String[arrayList.size()]);
            try {
                final String string8 = railsProject.evaluator().getProperty("source.encoding");
                railsProject.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        StatefulRecognizer statefulRecognizer = new StatefulRecognizer(RailsProjectGenerator.RAILS_GENERATOR);
                        DirectoryFileLocator directoryFileLocator = new DirectoryFileLocator(fileObject);
                        String string = NbBundle.getMessage(GenerateAction.class, (String)"RailsGenerator");
                        Task task = new RubyExecution(new ExecutionDescriptor(RubyPlatform.platformFor((Project)railsProject), string, file, string4).additionalArgs(stringArray4).fileLocator((FileLocator)directoryFileLocator).addOutputRecognizer((OutputRecognizer)statefulRecognizer), string8).run();
                        task.waitFinished();
                        railsProject.getProjectDirectory().getFileSystem().refresh(true);
                        List<OutputRecognizer.FileLocation> list = statefulRecognizer.getLocations();
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
                        for (int i = list.size() - 1; i >= 0; --i) {
                            FileObject fileObject2;
                            OutputRecognizer.FileLocation fileLocation = list.get(i);
                            String string2 = fileLocation.file;
                            if (string2 == null || (fileObject2 = directoryFileLocator.find(string2)) == null) continue;
                            String string3 = fileObject2.getMIMEType();
                            if (string3.equals("text/x-ruby")) {
                                arrayList.add(fileObject2);
                                continue;
                            }
                            if (!string3.equals("application/x-httpd-eruby")) continue;
                            arrayList2.add(fileObject2);
                        }
                        if (arrayList2.size() <= 4) {
                            for (FileObject fileObject3 : arrayList2) {
                                OutputProcessor.open((FileObject)fileObject3, (int)1);
                            }
                        }
                        if (arrayList.size() <= 4) {
                            for (FileObject fileObject4 : arrayList) {
                                OutputProcessor.open((FileObject)fileObject4, (int)1);
                            }
                        }
                    }
                });
                railsProject.getProjectDirectory().getFileSystem().refresh(true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(GenerateAction.class, (String)EDITOR_ACTION_NAME);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Lookup lookup = nodeArray[0].getLookup();
        RailsProject railsProject = (RailsProject)((Object)lookup.lookup(RailsProject.class));
        if (railsProject != null) {
            return true;
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        return dataObject != null;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        Node[] nodeArray;
        Node node;
        DataObject dataObject = (DataObject)jTextComponent.getDocument().getProperty("stream");
        if (dataObject != null && (node = dataObject.getNodeDelegate()) != null && this.enable(nodeArray = new Node[]{node})) {
            this.performAction(nodeArray);
        }
    }

    public boolean appliesTo(String string) {
        return "application/x-httpd-eruby".equals(string) || "text/x-ruby".equals(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatefulRecognizer
    extends OutputRecognizer {
        private RegexpOutputRecognizer recognizer;
        private List<OutputRecognizer.FileLocation> locations = new ArrayList<OutputRecognizer.FileLocation>();

        private StatefulRecognizer(RegexpOutputRecognizer regexpOutputRecognizer) {
            this.recognizer = regexpOutputRecognizer;
        }

        public OutputRecognizer.FileLocation processLine(String string) {
            OutputRecognizer.FileLocation fileLocation = this.recognizer.processLine(string);
            if (fileLocation != null && !string.trim().startsWith("skip")) {
                this.locations.add(fileLocation);
            }
            return fileLocation;
        }

        public List<OutputRecognizer.FileLocation> getLocations() {
            return this.locations;
        }
    }

    public static class EditorAction
    extends BaseAction {
        public EditorAction() {
            super(GenerateAction.EDITOR_ACTION_NAME, 0);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            ((GenerateAction)SystemAction.get(GenerateAction.class)).actionPerformed(actionEvent, jTextComponent);
        }

        public Class getShortDescriptionBundleClass() {
            return GenerateAction.class;
        }
    }
}

