/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.webext;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.websphere6.dd.beans.ExtendedServletsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSWebExt;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.webext.PanelFactory;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.webext.WSWebExtDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WSWebExtToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(WSWebExtToolBarMVElement.class.getName());
    private ToolBarDesignEditor comp;
    private SectionView view;
    private WSWebExtDataObject dObj;
    private PanelFactory factory;
    private RequestProcessor.Task repaintingTask;
    private boolean needInit = true;
    private Action addServletAction;
    private Action removeServletAction;
    private static final long serialVersionUID = 76757425329721L;
    private static final String WEBEXT_MV_ID = "webext_multiview_design";

    public WSWebExtToolBarMVElement(WSWebExtDataObject wSWebExtDataObject) {
        super((XmlMultiViewDataObject)wSWebExtDataObject);
        this.dObj = wSWebExtDataObject;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PanelFactory(this.comp, wSWebExtDataObject);
        this.addServletAction = new AddServletAction(NbBundle.getMessage(WSWebExtToolBarMVElement.class, (String)"LBL_AddExtendedServlet"));
        this.removeServletAction = new RemoveServletAction(NbBundle.getMessage(WSWebExtToolBarMVElement.class, (String)"LBL_RemoveExtendedServlet"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WSWebExtToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    private void repaintView() {
        this.view = new WSWebExtView(this.dObj);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        }
        this.view.checkValidity();
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public WSWebExtView getWebExtView() {
        return (WSWebExtView)this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            this.repaintView();
            this.needInit = false;
        }
        this.comp.setContentView((PanelView)this.view);
        try {
            this.view.openPanel((Object)this.dObj.getWebExt());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        this.view.checkValidity();
    }

    public void componentOpened() {
        super.componentOpened();
        try {
            this.dObj.getWebExt().addPropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void componentClosed() {
        super.componentClosed();
        try {
            this.dObj.getWebExt().removePropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("WebApplicationExt") > 0) {
            if (WEBEXT_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    public Error validateView() {
        return null;
    }

    public static class ServletsCacheConfigNode
    extends AbstractNode {
        ServletsCacheConfigNode() {
            super(Children.LEAF);
            this.setDisplayName("Servlet Cache Configs");
        }
    }

    public static class ServletsNode
    extends AbstractNode {
        ServletsNode() {
            super(Children.LEAF);
            this.setDisplayName("Extended Servlet #");
        }
    }

    public static class WSWebExtNode
    extends AbstractNode {
        WSWebExtNode(WSWebExt wSWebExt) {
            super(Children.LEAF);
            this.setDisplayName("Extended Deployment Information");
        }
    }

    private class RemoveServletAction
    extends AbstractAction {
        RemoveServletAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            ExtendedServletsType extendedServletsType = (ExtendedServletsType)sectionPanel.getKey();
            try {
                WSWebExtToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebExtToolBarMVElement.this.dObj.getWebExt().removeExtendedServlets(extendedServletsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                sectionPanel.getSectionView().updateUI();
                sectionPanel.updateUI();
                WSWebExtToolBarMVElement.this.dObj.modelUpdatedFromUI();
            }
            catch (IOException iOException) {
            }
            finally {
                WSWebExtToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddServletAction
    extends AbstractAction {
        AddServletAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSWebExtToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebExt wSWebExt = WSWebExtToolBarMVElement.this.dObj.getWebExt();
                ExtendedServletsType extendedServletsType = new ExtendedServletsType();
                extendedServletsType.setDefaults();
                int n = wSWebExt.getExtendedServlets().length + 1;
                long l = System.currentTimeMillis();
                extendedServletsType.setExtendedServlet("");
                extendedServletsType.setXmiId("ServletExtension_" + l);
                extendedServletsType.setHref("");
                wSWebExt.addExtendedServlets(extendedServletsType);
                ServletsNode servletsNode = new ServletsNode();
                WSWebExtToolBarMVElement.this.view.getRoot().getChildren().add(new Node[]{servletsNode});
                servletsNode.setDisplayName(servletsNode.getDisplayName() + n);
                WSWebExtToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSWebExtToolBarMVElement.this.view, (Node)servletsNode, (Object)extendedServletsType);
                sectionPanel.setHeaderActions(new Action[]{WSWebExtToolBarMVElement.this.removeServletAction});
                ((WSWebExtView)WSWebExtToolBarMVElement.this.view).getServletsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSWebExtToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class WSWebExtView
    extends SectionView {
        private SectionContainer servletsCont;
        private WSWebExt webext;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WSWebExtView(WSWebExtDataObject wSWebExtDataObject) {
            super((InnerPanelFactory)WSWebExtToolBarMVElement.this.factory);
            Children.Array array = new Children.Array();
            AbstractNode abstractNode = new AbstractNode((Children)array);
            try {
                this.webext = wSWebExtDataObject.getWebExt();
                array.add(new Node[]{this.createWebExtAttrNode(), this.createServletsNode()});
            }
            catch (IOException iOException) {
                System.out.println("ex=" + iOException);
                abstractNode.setDisplayName("Invalid WebExt");
            }
            finally {
                this.setRoot((Node)abstractNode);
            }
        }

        private Node createWebExtAttrNode() {
            WSWebExtNode wSWebExtNode = new WSWebExtNode(this.webext);
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)wSWebExtNode, (Object)this.webext));
            return wSWebExtNode;
        }

        private Node createServletsNode() {
            ExtendedServletsType[] extendedServletsTypeArray = this.webext.getExtendedServlets();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (extendedServletsTypeArray != null && extendedServletsTypeArray.length > 0) {
                nodeArray = new Node[extendedServletsTypeArray.length];
                for (int i = 0; i < extendedServletsTypeArray.length; ++i) {
                    nodeArray[i] = new ServletsNode();
                    nodeArray[i].setDisplayName("Extended Servlet #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Extended Servlets");
            this.servletsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Extended Servlets");
            this.servletsCont.setHeaderActions(new Action[]{WSWebExtToolBarMVElement.this.addServletAction});
            if (extendedServletsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[extendedServletsTypeArray.length];
                for (int i = 0; i < extendedServletsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)extendedServletsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSWebExtToolBarMVElement.this.removeServletAction});
                    this.servletsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.servletsCont);
            return sectionContainerNode;
        }

        private Node createServletsCacheConfigNode() {
            ServletsCacheConfigNode servletsCacheConfigNode = new ServletsCacheConfigNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)servletsCacheConfigNode, (Object)this.webext));
            return servletsCacheConfigNode;
        }

        public SectionContainer getServletsContainer() {
            return this.servletsCont;
        }
    }
}

