/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.LazyTypeCompletionItem;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.java.JavaUtils;
import org.openide.util.NbBundle;

public class JavaClassCompletor
extends Completor {
    private static final Set<ClassIndex.SearchScope> ALL = EnumSet.allOf(ClassIndex.SearchScope.class);
    private static final Set<ClassIndex.SearchScope> LOCAL = EnumSet.of(ClassIndex.SearchScope.SOURCE);
    private static final String ADDITIONAL_ITEMS_TEXT = NbBundle.getMessage(JavaClassCompletor.class, (String)"MESG_AdditionalItems");

    public JavaClassCompletor(int n) {
        super(n);
    }

    protected int initAnchorOffset(CompletionContext completionContext) {
        int n = completionContext.getCurrentToken().getOffset() + 1;
        String string = completionContext.getTypedPrefix();
        if (string.contains(".") || string.equals("")) {
            int n2 = string.lastIndexOf(".");
            n += n2 + 1;
        }
        return n;
    }

    protected void compute(CompletionContext completionContext) throws IOException {
        String string = completionContext.getTypedPrefix();
        JavaSource javaSource = JavaUtils.getJavaSource(completionContext.getFileObject());
        if (javaSource == null) {
            return;
        }
        if (string.contains(".") || string.equals("")) {
            this.doNormalJavaCompletion(javaSource, string, completionContext.getCurrentToken().getOffset() + 1);
        } else {
            this.doSmartJavaCompletion(javaSource, string, completionContext.getCurrentToken().getOffset() + 1, completionContext.getQueryType());
        }
    }

    private void doNormalJavaCompletion(JavaSource javaSource, final String string, final int n) throws IOException {
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassIndex classIndex = compilationController.getJavaSource().getClasspathInfo().getClassIndex();
                int n3 = n;
                String string2 = string;
                int n2 = string.lastIndexOf(46);
                if (n2 != -1) {
                    n3 += n2 + 1;
                    string2 = string.substring(0, n2);
                }
                JavaClassCompletor.this.addPackages(classIndex, string, n3, 9);
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                PackageElement packageElement = compilationController.getElements().getPackageElement(string2);
                if (packageElement == null) {
                    return;
                }
                List list = (List)new TypeScanner().scan(packageElement);
                for (TypeElement typeElement : list) {
                    if (JavaClassCompletor.this.isCancelled()) {
                        return;
                    }
                    if (!ElementUtilities.getBinaryName((TypeElement)typeElement).startsWith(string)) continue;
                    SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createTypeItem(n, typeElement, (ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), compilationController.getElements().isDeprecated(typeElement), false);
                    JavaClassCompletor.this.addCacheItem(springXMLConfigCompletionItem);
                }
            }
        }, true);
    }

    private void doSmartJavaCompletion(final JavaSource javaSource, final String string, final int n, final int n2) throws IOException {
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                Set set;
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassIndex classIndex = compilationController.getJavaSource().getClasspathInfo().getClassIndex();
                JavaClassCompletor.this.addPackages(classIndex, string, n, n2);
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                if (n2 == 9) {
                    set = classIndex.getDeclaredTypes(string, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, ALL);
                } else {
                    set = classIndex.getDeclaredTypes(string, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, LOCAL);
                    JavaClassCompletor.this.setAdditionalItems(true);
                }
                for (ElementHandle elementHandle : set) {
                    if (JavaClassCompletor.this.isCancelled()) {
                        return;
                    }
                    if (elementHandle.getKind() != ElementKind.CLASS) continue;
                    LazyTypeCompletionItem lazyTypeCompletionItem = LazyTypeCompletionItem.create(n, (ElementHandle<TypeElement>)elementHandle, javaSource);
                    JavaClassCompletor.this.addCacheItem(lazyTypeCompletionItem);
                }
            }
        }, true);
    }

    protected String getAdditionalItemsText() {
        return ADDITIONAL_ITEMS_TEXT;
    }

    private static boolean isAccessibleClass(TypeElement typeElement) {
        NestingKind nestingKind = typeElement.getNestingKind();
        return nestingKind == NestingKind.TOP_LEVEL || nestingKind == NestingKind.MEMBER && typeElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void addPackages(ClassIndex classIndex, String string, int n, int n2) {
        Set<ClassIndex.SearchScope> set = n2 == 9 ? ALL : LOCAL;
        Set set2 = classIndex.getPackageNames(string, true, set);
        for (String string2 : set2) {
            if (string2.length() <= 0) continue;
            SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createPackageItem(n, string2, false);
            this.addCacheItem(springXMLConfigCompletionItem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeScanner
    extends ElementScanner6<List<TypeElement>, Void> {
        public TypeScanner() {
            super(new ArrayList());
        }

        @Override
        public List<TypeElement> visitType(TypeElement typeElement, Void void_) {
            if (typeElement.getKind() == ElementKind.CLASS && JavaClassCompletor.isAccessibleClass(typeElement)) {
                ((List)this.DEFAULT_VALUE).add(typeElement);
            }
            return (List)super.visitType(typeElement, void_);
        }
    }
}

