/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleFactory;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModules
implements WebModuleProvider,
AntProjectListener,
ClassPathProvider {
    private List<FFWebModule> modules;
    private Map<FFWebModule, WebModule> cache;
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final AuxiliaryConfiguration aux;

    public WebModules(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
        assert (project != null);
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.aux = auxiliaryConfiguration;
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
    }

    public WebModule findWebModule(final FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (this.project.equals(project)) {
            return (WebModule)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<WebModule>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public WebModule run() {
                    WebModules webModules = WebModules.this;
                    synchronized (webModules) {
                        List list = WebModules.this.getModules();
                        for (FFWebModule fFWebModule : list) {
                            if (!fFWebModule.contains(fileObject)) continue;
                            WebModule webModule = (WebModule)WebModules.this.cache.get(fFWebModule);
                            if (webModule == null) {
                                webModule = WebModuleFactory.createWebModule((WebModuleImplementation)fFWebModule);
                                WebModules.this.cache.put(fFWebModule, webModule);
                            }
                            return webModule;
                        }
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public ClassPath findClassPath(final FileObject fileObject, final String string) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && project.equals(this.project)) {
            return (ClassPath)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ClassPath run() {
                    WebModules webModules = WebModules.this;
                    synchronized (webModules) {
                        List list = WebModules.this.getModules();
                        for (FFWebModule fFWebModule : list) {
                            if (!fFWebModule.contains(fileObject)) continue;
                            return fFWebModule.findClassPath(fileObject, string);
                        }
                    }
                    return null;
                }
            });
        }
        return null;
    }

    private synchronized List<FFWebModule> getModules() {
        if (this.modules == null) {
            this.modules = this.readAuxData();
            this.cache = new HashMap<FFWebModule, WebModule>();
        }
        return this.modules;
    }

    private List<FFWebModule> readAuxData() {
        ArrayList<FFWebModule> arrayList = new ArrayList<FFWebModule>();
        Element element = this.aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
        if (element == null) {
            return arrayList;
        }
        List list = Util.findSubElements((Element)element);
        for (Element element2 : list) {
            assert (element2.getLocalName().equals("web-module")) : element2;
            FileObject fileObject = this.getFile(element2, "doc-root");
            Element element3 = Util.findElement((Element)element2, (String)"j2ee-spec-level", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            String string = element3 == null ? null : this.evaluator.evaluate(Util.findText((Element)element3));
            Element element4 = Util.findElement((Element)element2, (String)"context-path", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            String string2 = element4 == null ? null : Util.findText((Element)element4);
            String string3 = string2 == null ? null : this.evaluator.evaluate(string2);
            Element element5 = Util.findElement((Element)element2, (String)"classpath", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            FileObject[] fileObjectArray = this.getSources();
            ClassPath classPath = element5 == null ? null : this.createClasspath(element5, fileObjectArray);
            Element element6 = Util.findElement((Element)element2, (String)"web-inf", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            FileObject fileObject2 = null;
            if (element6 != null) {
                fileObject2 = this.getFile(element2, "web-inf");
            }
            arrayList.add(new FFWebModule(fileObject, string, string3, fileObjectArray, classPath, fileObject2));
        }
        return arrayList;
    }

    private FileObject getFile(Element element, String string) {
        Element element2 = Util.findElement((Element)element, (String)string, (String)"http://www.netbeans.org/ns/freeform-project-web/2");
        String string2 = Util.findText((Element)element2);
        if (string2 == null) {
            return null;
        }
        String string3 = this.evaluator.evaluate(string2);
        if (string3 != null) {
            File file = this.helper.resolveFile(string3);
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    private FileObject[] getSources() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            URL uRL;
            try {
                uRL = sourceGroupArray[i].getRootFolder().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new AssertionError((Object)fileStateInvalidException);
            }
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
            FileObject[] fileObjectArray = result.getRoots();
            for (int j = 0; j < fileObjectArray.length; ++j) {
                hashSet.add(fileObjectArray[j]);
            }
        }
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
        }
        return fileObjectArray;
    }

    private ClassPath createClasspath(Element element, FileObject[] fileObjectArray) {
        int n;
        String string;
        String string2 = Util.findText((Element)element);
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.evaluator.evaluate(string2)) == null) {
            return null;
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string);
        HashSet<File> hashSet = new HashSet<File>();
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.add(this.helper.resolveFile(stringArray[n]));
        }
        if (hashSet.size() == 0) {
            for (n = 0; n < fileObjectArray.length; ++n) {
                hashSet.add(FileUtil.toFile((FileObject)fileObjectArray[n]));
            }
        }
        URL[] uRLArray = new URL[hashSet.size()];
        int n2 = 0;
        for (File file : hashSet) {
            URL uRL;
            try {
                uRL = file.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                } else {
                    String string3 = uRL.toExternalForm();
                    if (!string3.endsWith("/")) {
                        uRL = new URL(string3 + '/');
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            uRLArray[n2++] = uRL;
        }
        return ClassPathSupport.createClassPath((URL[])uRLArray);
    }

    public synchronized void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.modules = null;
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FFWebModule
    implements WebModuleImplementation {
        public static final String FOLDER_WEB_INF = "WEB-INF";
        public static final String FILE_DD = "web.xml";
        private final FileObject docRootFO;
        private final FileObject[] sourcesFOs;
        private final ClassPath webClassPath;
        private final ClassPath javaSourcesClassPath;
        private final Map<String, ClassPath> composedClassPath = new HashMap<String, ClassPath>();
        private final String j2eeSpec;
        private final String contextPath;
        private FileObject webInf;

        FFWebModule(FileObject fileObject, String string, String string2, FileObject[] fileObjectArray, ClassPath classPath, FileObject fileObject2) {
            this.docRootFO = fileObject;
            this.j2eeSpec = string;
            this.contextPath = string2 == null ? "" : string2;
            this.sourcesFOs = fileObjectArray;
            this.webClassPath = classPath == null ? ClassPathSupport.createClassPath(Collections.emptyList()) : classPath;
            this.webInf = fileObject2;
            this.javaSourcesClassPath = fileObjectArray == null ? ClassPathSupport.createClassPath(Collections.emptyList()) : ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
        }

        boolean contains(FileObject fileObject) {
            if (this.docRootFO == fileObject || FileUtil.isParentOf((FileObject)this.docRootFO, (FileObject)fileObject)) {
                return true;
            }
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                if (this.sourcesFOs[i] != fileObject && !FileUtil.isParentOf((FileObject)this.sourcesFOs[i], (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }

        public FileObject getDocumentBase() {
            return this.docRootFO;
        }

        public ClassPath findClassPath(FileObject fileObject, String string) {
            assert (Thread.holdsLock(WebModules.this));
            int n = this.getType(fileObject);
            if (n == 0) {
                if (!string.equals("classpath/source")) {
                    return null;
                }
                return this.javaSourcesClassPath;
            }
            if (n == 1) {
                int n2;
                ClassPath classPath = this.composedClassPath.get(string);
                if (classPath != null) {
                    return classPath;
                }
                HashSet<FileObject> hashSet = new HashSet<FileObject>();
                FileObject[] fileObjectArray = null;
                for (n2 = 0; n2 < this.sourcesFOs.length; ++n2) {
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)this.sourcesFOs[n2], (String)string);
                    if (classPath2 == null) continue;
                    fileObjectArray = classPath2.getRoots();
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        if (hashSet.contains(fileObjectArray[i])) continue;
                        hashSet.add(fileObjectArray[i]);
                    }
                }
                if (hashSet.isEmpty() && "classpath/boot".equals(string)) {
                    ClassPath classPath3 = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
                    hashSet.addAll(Arrays.asList(classPath3.getRoots()));
                }
                for (n2 = 0; n2 < this.webClassPath.getRoots().length; ++n2) {
                    if (hashSet.contains(this.webClassPath.getRoots()[n2])) continue;
                    hashSet.add(this.webClassPath.getRoots()[n2]);
                }
                FileObject[] fileObjectArray2 = new FileObject[hashSet.size()];
                int n3 = 0;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    fileObjectArray2[n3++] = (FileObject)iterator.next();
                }
                classPath = ClassPathSupport.createClassPath((FileObject[])fileObjectArray2);
                this.composedClassPath.put(string, classPath);
                return classPath;
            }
            return this.webClassPath;
        }

        public String getJ2eePlatformVersion() {
            return this.j2eeSpec;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("web module in freeform project\n\tdoc root:" + this.docRootFO.getPath() + "\n\tcontext path:" + this.contextPath + "\n\tj2ee version:" + this.j2eeSpec);
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                stringBuffer.append("\n\tsource root:" + this.sourcesFOs[i].getPath());
            }
            return stringBuffer.toString();
        }

        public FileObject getDeploymentDescriptor() {
            FileObject fileObject = this.getWebInf();
            if (fileObject == null) {
                return null;
            }
            return fileObject.getFileObject(FILE_DD);
        }

        public FileObject getWebInf() {
            if (this.webInf == null) {
                this.webInf = this.getDocumentBase().getFileObject(FOLDER_WEB_INF);
            }
            return this.webInf;
        }

        @Deprecated
        public FileObject[] getJavaSources() {
            return this.sourcesFOs;
        }

        public MetadataModel<WebAppMetadata> getMetadataModel() {
            return null;
        }

        private int getType(FileObject fileObject) {
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                FileObject fileObject2 = this.sourcesFOs[i];
                if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                return 0;
            }
            FileObject fileObject3 = this.getDocumentBase();
            if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
                return 1;
            }
            return -1;
        }
    }
}

