/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.io.InputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.MIMEResolver;

public class RubyMimeResolver
extends MIMEResolver {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    static final int HEADER_LENGTH = 80;

    public String findMIMEType(FileObject fileObject) {
        String string = fileObject.getExt();
        String string2 = fileObject.getName();
        if ("Rakefile".equals(string2) || "rakefile".equals(string2)) {
            return RUBY_MIME_TYPE;
        }
        if (string.length() == 0 || string.equals("cgi")) {
            byte[] byArray = this.readHeader(fileObject);
            if (byArray != null && RubyMimeResolver.isRubyHeader(byArray)) {
                return RUBY_MIME_TYPE;
            }
            return null;
        }
        char c = Character.toLowerCase(string.charAt(0));
        if (c == 'r' && (string.equalsIgnoreCase("rb") || string.equalsIgnoreCase("rake") || string.equalsIgnoreCase("rxml") || string.equalsIgnoreCase("rjs") || string.equalsIgnoreCase("rbw") || string.equalsIgnoreCase("rbx"))) {
            return RUBY_MIME_TYPE;
        }
        if (c == 'm' && string.equalsIgnoreCase("mab")) {
            return RUBY_MIME_TYPE;
        }
        if (c == 'b' && string.equalsIgnoreCase("builder")) {
            return RUBY_MIME_TYPE;
        }
        if (c == 'g' && string.equalsIgnoreCase("gemspec")) {
            return RUBY_MIME_TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readHeader(FileObject fileObject) {
        byte[] byArray = new byte[80];
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            int n = 0;
            while (n < 80) {
                int n2;
                try {
                    n2 = inputStream.read(byArray, n, 80 - n);
                    if (n2 < 0) {
                        byte[] byArray2 = null;
                        return byArray2;
                    }
                }
                catch (IOException iOException) {
                    byte[] byArray3 = null;
                    try {
                        if (inputStream == null) return byArray3;
                        inputStream.close();
                        return byArray3;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return byArray3;
                }
                {
                    n += n2;
                }
            }
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray4 = null;
            try {
                if (inputStream == null) return byArray4;
                inputStream.close();
                return byArray4;
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            return byArray4;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isRubyHeader(byte[] byArray) {
        byte by;
        int n = byArray.length;
        if (n < 2 || byArray[0] != 35 || byArray[1] != 33) {
            return false;
        }
        block0: for (int i = 0; i < n - 3 && (by = byArray[i]) != 10; ++i) {
            byte by2;
            if (by != 114 || byArray[i + 1] != 117 || byArray[i + 2] != 98 || byArray[i + 3] != 121) continue;
            for (int j = i + 4; j < n && (by2 = byArray[j]) != 32 && by2 != 10; ++j) {
                if (by2 == 47 || by2 == 92) continue block0;
            }
            return true;
        }
        return false;
    }
}

