/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.wizard.RetrieveXMLResourceWizardPanel1;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.NbBundle;

public final class RetrieveXMLResourceVisualPanel1
extends JPanel
implements DocumentListener {
    static final long serialVersionUID = 91839812L;
    private static final String USER_PREF_SAVE_LOCATION_KEY = "USER_PREF_SAVE_LOCATION_KEY";
    private static final String USER_PREF_LOCAL_FILE_DIR_KEY = "USER_PREF_LOCAL_FILE_DIR_KEY";
    private RetrieveXMLResourceWizardPanel1 enclosingClass;
    private String schemaFileType = "retrieveSchemaResource";
    private String wsdlFileType = "retrieveWSDLResource";
    private String selectedSaveRootFolder = null;
    int previouslayoutIndex = 0;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JTextField URLFileLocationTextField;
    private JCheckBox closureCheckBox;
    private JRadioButton fromLocalFileButton;
    private JRadioButton fromURLButton;
    private JButton lfsBrowseButton;
    private JTextField lfsSourceFileLocationTextField;
    private JCheckBox overwriteFiles;
    private JLabel sourceLabel;
    private ButtonGroup sourceTypeRadioButtonGroup;
    private JLabel targetLabel;
    private JButton tpLocationBrowseButton;
    private JLabel tpLocationLabel;
    private JTextField tpLocationTextField;

    public RetrieveXMLResourceVisualPanel1(RetrieveXMLResourceWizardPanel1 retrieveXMLResourceWizardPanel1) {
        this.enclosingClass = retrieveXMLResourceWizardPanel1;
        this.initComponents();
        this.lfsSourceFileLocationTextField.getDocument().addDocumentListener(this);
        this.URLFileLocationTextField.getDocument().addDocumentListener(this);
        this.tpLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getName() {
        return NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"LBL_step_description");
    }

    public void validateFiles(String string) throws WizardValidationException {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Serializable serializable;
            String string2 = stringArray[i].trim();
            if (string2.length() == 0) continue;
            File file = new File(string2);
            if (!file.exists()) {
                file = null;
            }
            if (file == null) {
                serializable = null;
                try {
                    serializable = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    String string3 = NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"INVALID_SCHEMA_FILE", (Object)string2);
                    throw new WizardValidationException((JComponent)this.lfsSourceFileLocationTextField, string3, string3);
                }
                try {
                    file = new File(((URL)serializable).toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new WizardValidationException((JComponent)this.lfsSourceFileLocationTextField, uRISyntaxException.getMessage(), uRISyntaxException.getLocalizedMessage());
                }
            }
            if (!file.isFile()) {
                throw new WizardValidationException((JComponent)this.lfsSourceFileLocationTextField, "INVALID_SCHEMA_FILE", NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"INVALID_SCHEMA_FILE", (Object)string2));
            }
            try {
                serializable = FileUtil.normalizeFile((File)file);
                object = FileUtil.toFileObject((File)serializable);
                if (object != null) continue;
                String string4 = NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"INVALID_SCHEMA_FILE", (Object)string2);
                throw new WizardValidationException((JComponent)this.lfsSourceFileLocationTextField, string4, string4);
            }
            catch (WizardValidationException wizardValidationException) {
                throw wizardValidationException;
            }
            catch (Throwable throwable) {
                object = NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"INVALID_SCHEMA_FILE", (Object)string2);
                throw new WizardValidationException((JComponent)this.lfsSourceFileLocationTextField, (String)object, (String)object);
            }
        }
    }

    private void initComponents() {
        this.sourceTypeRadioButtonGroup = new ButtonGroup();
        this.sourceLabel = new JLabel();
        this.fromURLButton = new JRadioButton();
        this.URLFileLocationTextField = new JTextField();
        this.closureCheckBox = new JCheckBox();
        this.fromLocalFileButton = new JRadioButton();
        this.lfsSourceFileLocationTextField = new JTextField();
        this.lfsBrowseButton = new JButton();
        this.targetLabel = new JLabel();
        this.tpLocationLabel = new JLabel();
        this.tpLocationTextField = new JTextField();
        this.tpLocationBrowseButton = new JButton();
        this.overwriteFiles = new JCheckBox();
        this.setName(NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"LBL_step_description"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/xml/schema/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)resourceBundle.getString("LBL_select_source"));
        this.sourceTypeRadioButtonGroup.add(this.fromURLButton);
        this.fromURLButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.fromURLButton, (String)resourceBundle.getString("TXT_FromURLResource"));
        this.fromURLButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fromURLButton.setMargin(new Insets(0, 0, 0, 0));
        this.fromURLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieveXMLResourceVisualPanel1.this.fromURLButtonPressed(actionEvent);
            }
        });
        this.URLFileLocationTextField.setText("http://");
        this.URLFileLocationTextField.setToolTipText(this.lfsSourceFileLocationTextField.getText());
        this.URLFileLocationTextField.setNextFocusableComponent(this.lfsBrowseButton);
        this.URLFileLocationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RetrieveXMLResourceVisualPanel1.this.refreshToolTips(focusEvent);
            }
        });
        this.closureCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.closureCheckBox, (String)resourceBundle.getString("LBL_closure_checkbox_label"));
        this.closureCheckBox.setToolTipText(resourceBundle.getString("TIP_retrieve_closure_tool_tip"));
        this.closureCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.closureCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.closureCheckBox.setVisible(false);
        this.closureCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieveXMLResourceVisualPanel1.this.retrieveCheckBoxEventHandler(actionEvent);
            }
        });
        this.sourceTypeRadioButtonGroup.add(this.fromLocalFileButton);
        Mnemonics.setLocalizedText((AbstractButton)this.fromLocalFileButton, (String)resourceBundle.getString("TXT_FromLocalFileResource"));
        this.fromLocalFileButton.setToolTipText(NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"HINT_Files"));
        this.fromLocalFileButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fromLocalFileButton.setMargin(new Insets(0, 0, 0, 0));
        this.fromLocalFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieveXMLResourceVisualPanel1.this.fromLocalFileButtonActionPerformed(actionEvent);
            }
        });
        this.lfsSourceFileLocationTextField.setToolTipText(NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"HINT_Files"));
        this.lfsSourceFileLocationTextField.setEnabled(false);
        this.lfsSourceFileLocationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieveXMLResourceVisualPanel1.this.lfsSourceFileLocationTextFieldActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.lfsBrowseButton, (String)resourceBundle.getString("LBL_source_browse"));
        this.lfsBrowseButton.setEnabled(false);
        this.lfsBrowseButton.setNextFocusableComponent(this.tpLocationTextField);
        this.lfsBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieveXMLResourceVisualPanel1.this.invokeFileChooserForSource(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)resourceBundle.getString("LBL_select_target"));
        this.tpLocationLabel.setLabelFor(this.tpLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.tpLocationLabel, (String)resourceBundle.getString("LBL_save_file_location"));
        this.tpLocationTextField.setEditable(false);
        this.tpLocationTextField.setToolTipText(this.tpLocationTextField.getText());
        this.tpLocationTextField.setNextFocusableComponent(this.tpLocationBrowseButton);
        this.tpLocationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RetrieveXMLResourceVisualPanel1.this.refreshToolTips(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.tpLocationBrowseButton, (String)resourceBundle.getString("LBL_target_browse"));
        this.tpLocationBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieveXMLResourceVisualPanel1.this.invokeFileChooserForTarget(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.overwriteFiles, (String)resourceBundle.getString("LBL_OVERWIRITE_FILES"));
        this.overwriteFiles.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.overwriteFiles.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.URLFileLocationTextField, -1, 488, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.overwriteFiles)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.closureCheckBox)).add(1, (Component)this.sourceLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.fromURLButton).add(1, (Component)this.targetLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tpLocationLabel).addPreferredGap(0).add((Component)this.tpLocationTextField, -1, 309, Short.MAX_VALUE)).add((Component)this.lfsSourceFileLocationTextField, -1, 402, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lfsBrowseButton, -2, 79, Short.MAX_VALUE).add((Component)this.tpLocationBrowseButton, -2, 79, Short.MAX_VALUE))).add(1, (Component)this.fromLocalFileButton)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sourceLabel).addPreferredGap(0).add((Component)this.fromURLButton).addPreferredGap(0).add((Component)this.URLFileLocationTextField, -2, 21, -2).addPreferredGap(0).add((Component)this.closureCheckBox).add(11, 11, 11).add((Component)this.fromLocalFileButton).add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lfsBrowseButton).add((Component)this.lfsSourceFileLocationTextField, -2, 21, -2)).add(11, 11, 11).add((Component)this.targetLabel).add(2, 2, 2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tpLocationBrowseButton).add((Component)this.tpLocationTextField, -2, -1, -2).add((Component)this.tpLocationLabel)).addPreferredGap(0).add((Component)this.overwriteFiles).addContainerGap(-1, Short.MAX_VALUE)));
        this.sourceLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_select_source"));
        this.sourceLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_select_source"));
        this.fromURLButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("TXT_FromURLResource"));
        this.fromURLButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TXT_FromURLResource"));
        this.URLFileLocationTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TXT_FromURLResource"));
        this.URLFileLocationTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TXT_FromURLResource"));
        this.closureCheckBox.getAccessibleContext().setAccessibleDescription("Retrieve dependent files");
        this.fromLocalFileButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("TXT_FromLocalFileResource"));
        this.fromLocalFileButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TXT_FromLocalFileResource"));
        this.lfsSourceFileLocationTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TXT_FromLocalFileResource"));
        this.lfsSourceFileLocationTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TXT_FromLocalFileResource"));
        this.lfsBrowseButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("A11Y_target_browse"));
        this.lfsBrowseButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("A11Y_target_browse"));
        this.tpLocationTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_save_file_location"));
        this.tpLocationTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_save_file_location"));
        this.tpLocationBrowseButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("A11Y_target_browse"));
        this.tpLocationBrowseButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("A11Y_target_browse"));
        this.overwriteFiles.getAccessibleContext().setAccessibleName("Overwrite files with same name.");
        this.overwriteFiles.getAccessibleContext().setAccessibleDescription("Overwrite files with same name.");
    }

    private void fromURLButtonPressed(ActionEvent actionEvent) {
        this.lfsSourceFileLocationTextField.setEnabled(false);
        this.URLFileLocationTextField.setEnabled(true);
        this.lfsBrowseButton.setEnabled(false);
        this.fireChange();
    }

    private void fromLocalFileButtonActionPerformed(ActionEvent actionEvent) {
        this.lfsSourceFileLocationTextField.setEnabled(true);
        this.URLFileLocationTextField.setEnabled(false);
        this.lfsBrowseButton.setEnabled(true);
        this.fireChange();
    }

    private void refreshToolTips(FocusEvent focusEvent) {
        this.tpLocationTextField.setToolTipText(this.tpLocationTextField.getText());
        this.lfsSourceFileLocationTextField.setToolTipText(this.lfsSourceFileLocationTextField.getText());
    }

    private void retrieveCheckBoxEventHandler(ActionEvent actionEvent) {
        String string = this.URLFileLocationTextField.getText();
        if (this.closureCheckBox.isSelected()) {
            try {
                String string2 = new File(new URI(new URI(new File(this.selectedSaveRootFolder).toURI().toString() + "/" + new URL(string).toURI().getSchemeSpecificPart().replace(':', '_')).normalize().toString())).toString();
                this.tpLocationTextField.setText(string2);
            }
            catch (Exception exception) {}
        } else {
            try {
                String string3 = new URL(string).getFile();
                if (string3.lastIndexOf("/") != -1) {
                    string3 = string3.substring(string3.lastIndexOf("/") + 1);
                }
                if (string3 != null) {
                    this.tpLocationTextField.setText(this.selectedSaveRootFolder + File.separator + string3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void invokeFileChooserForTarget(ActionEvent actionEvent) {
        String string;
        String string2;
        SourceGroup sourceGroup2;
        Sources sources = ProjectUtils.getSources((Project)this.getProject());
        String string3 = ProjectUtils.getInformation((Project)this.getProject()).getName();
        LogicalViewProvider logicalViewProvider = (LogicalViewProvider)this.getProject().getLookup().lookup(LogicalViewProvider.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("retrieved");
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            sourceGroupArray = sources.getSourceGroups("java");
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (sourceGroupArray == null || sourceGroupArray.length <= 0) {
            arrayList.add(this.getProject().getProjectDirectory());
        } else {
            for (SourceGroup sourceGroup2 : sourceGroupArray) {
                arrayList.add(sourceGroup2.getRootFolder());
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (FileObject fileObject : arrayList) {
            sourceGroup2 = null;
            try {
                sourceGroup2 = DataObject.find((FileObject)fileObject).getNodeDelegate();
            }
            catch (Exception exception) {
                continue;
            }
            if (sourceGroup2 == null) continue;
            sourceGroup2 = new FilterNode((Node)sourceGroup2);
            arrayList2.add(sourceGroup2);
        }
        FilterNode filterNode = null;
        FilterNode filterNode2 = null;
        sourceGroup2 = logicalViewProvider.createLogicalView();
        filterNode2 = new FilterNode((Node)sourceGroup2, (Children)new Children.Array());
        Node[] nodeArray = arrayList2.toArray(new Node[arrayList2.size()]);
        filterNode2.getChildren().add(nodeArray);
        filterNode = filterNode2;
        FilterNode filterNode3 = filterNode2;
        Node[] nodeArray2 = null;
        try {
            nodeArray2 = NodeOperation.getDefault().select(NbBundle.getMessage(RetrieveXMLResourceVisualPanel1.class, (String)"TITLE_choose_target_folder"), "", (Node)filterNode, new NodeAcceptor((Node)filterNode3){
                final /* synthetic */ Node val$finalDummyNode;
                {
                    this.val$finalDummyNode = node;
                }

                public boolean acceptNodes(Node[] nodeArray) {
                    if (nodeArray == null || nodeArray.length < 1) {
                        return false;
                    }
                    if (this.val$finalDummyNode != null && nodeArray[0] == this.val$finalDummyNode) {
                        return false;
                    }
                    DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                    return dataObject.getPrimaryFile().isFolder();
                }
            });
        }
        catch (Exception exception) {
            return;
        }
        if (nodeArray2 == null || nodeArray2[0] == null) {
            return;
        }
        DataObject dataObject = (DataObject)nodeArray2[0].getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        this.selectedSaveRootFolder = string2 = FileUtil.toFile((FileObject)fileObject).toString();
        if (this.getSelectedSourceType() == SourceType.LOCAL_FILE) {
            string = this.lfsSourceFileLocationTextField.getText();
            string = string.substring(string.lastIndexOf(File.separator) + 1);
            this.tpLocationTextField.setText(string2);
        }
        if (this.getSelectedSourceType() == SourceType.URL_ADDR) {
            string = this.lfsSourceFileLocationTextField.getText();
            URI uRI = null;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            String string4 = uRI.getSchemeSpecificPart();
            string4 = string4.replace(':', '_');
            String string5 = new File(string2).toURI().toString();
            String string6 = string5 + "/" + string4;
            URI uRI2 = null;
            try {
                uRI2 = new URI(string6);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.tpLocationTextField.setText("");
                return;
            }
            string6 = new File(uRI2.normalize()).toString();
            this.tpLocationTextField.setText(string6);
        }
    }

    private void invokeFileChooserForSource(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.lfsSourceFileLocationTextField.getText();
        if (string != null && string.length() != 0) {
            jFileChooser.setSelectedFiles(this.getSchemaFiles(string));
        }
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new XSDFilter());
        if (jFileChooser.showOpenDialog((Component)actionEvent.getSource()) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            StringBuffer stringBuffer = new StringBuffer();
            for (File file : fileArray) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(file.toURI().normalize().toString());
            }
            this.lfsSourceFileLocationTextField.setText(stringBuffer.toString());
        }
    }

    private void lfsSourceFileLocationTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    public String getSourceLocation() {
        String string = null;
        string = this.getSelectedSourceType() == SourceType.LOCAL_FILE ? this.lfsSourceFileLocationTextField.getText() : this.URLFileLocationTextField.getText();
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (this.getSelectedSourceType() == SourceType.LOCAL_FILE) {
            return string;
        }
        if (this.getSelectedSourceType() == SourceType.URL_ADDR) {
            return string;
        }
        return null;
    }

    public SourceType getSelectedSourceType() {
        SourceType sourceType = SourceType.URL_ADDR;
        if (this.fromLocalFileButton.isSelected()) {
            sourceType = SourceType.LOCAL_FILE;
        }
        return sourceType;
    }

    public String getURLLocation() {
        String string = this.lfsSourceFileLocationTextField.getText();
        if (string != null && string.length() > 0) {
            string = new File(string).toURI().toString();
            return string;
        }
        return null;
    }

    public Utilities.DocumentTypesEnum getDocType() {
        if (((TemplateWizard)this.enclosingClass.getWizardDescriptor()).getTemplate().getName().equals(this.schemaFileType)) {
            return Utilities.DocumentTypesEnum.schema;
        }
        return Utilities.DocumentTypesEnum.wsdl;
    }

    public File getSaveLocation() {
        String string = this.tpLocationTextField.getText();
        if (string == null || string.trim().length() == 0) {
            string = null;
        }
        if (string != null) {
            File file = new File(string);
            return file;
        }
        return null;
    }

    public File getSelectedSaveRootFolder() {
        if (this.selectedSaveRootFolder == null) {
            return null;
        }
        return new File(this.selectedSaveRootFolder);
    }

    public boolean retrieveClosure() {
        return this.closureCheckBox.isSelected();
    }

    private Project getProject() {
        Project project = (Project)this.enclosingClass.getWizardDescriptor().getProperty("currentProjectKey");
        return project;
    }

    public void refreshSaveLocation() {
        try {
            String string;
            DataFolder dataFolder = ((TemplateWizard)this.enclosingClass.getWizardDescriptor()).getTargetFolder();
            this.selectedSaveRootFolder = string = FileUtil.toFile((FileObject)dataFolder.getPrimaryFile()).toString();
            this.tpLocationTextField.setText(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
        if (this.getSelectedSourceType() == SourceType.URL_ADDR) {
            String string = null;
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (string.trim().equalsIgnoreCase(this.lfsSourceFileLocationTextField.getText().trim())) {
                this.retrieveCheckBoxEventHandler(null);
            }
        }
    }

    public Boolean shouldOverwrite() {
        return new Boolean(this.overwriteFiles.isSelected());
    }

    public File[] getSchemaFiles(String string) {
        String[] stringArray = string.split(",");
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.length() == 0) continue;
            Object var6_6 = null;
            File file = new File(string2);
            if (!file.exists()) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    class XSDFilter
    extends FileFilter {
        XSDFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            Utilities.DocumentTypesEnum documentTypesEnum = RetrieveXMLResourceVisualPanel1.this.getDocType();
            String string = this.getExtension(file);
            if (string != null) {
                if (string.equals("xsd") && documentTypesEnum.equals((Object)Utilities.DocumentTypesEnum.schema)) {
                    return true;
                }
                return documentTypesEnum.equals((Object)Utilities.DocumentTypesEnum.wsdl) && string.equals("wsdl");
            }
            return false;
        }

        public String getDescription() {
            Utilities.DocumentTypesEnum documentTypesEnum = RetrieveXMLResourceVisualPanel1.this.getDocType();
            if (documentTypesEnum.equals((Object)Utilities.DocumentTypesEnum.wsdl)) {
                return "Only WSDL files";
            }
            return "only XSD files";
        }

        public String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        LOCAL_FILE,
        URL_ADDR,
        UDDI_ADDR;

    }
}

