/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.retriever.DocumentParserFactory;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.catalog.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoCollector {
    Map<File, List<InfoEntry>> allFiles2Info = new HashMap<File, List<InfoEntry>>();
    Map<File, List<InfoEntry>> errorFiles2Info = new HashMap<File, List<InfoEntry>>();
    Map<File, List<InfoEntry>> warningFiles2Info = new HashMap<File, List<InfoEntry>>();
    public Map<File, List<InfoEntry>> absURL2Info = new HashMap<File, List<InfoEntry>>();
    List<File> goodFileList = new ArrayList<File>();
    String root = null;
    Utilities.DocumentTypesEnum docType;

    public InfoCollector(String string, Utilities.DocumentTypesEnum documentTypesEnum) {
        this.root = string;
        this.docType = documentTypesEnum;
        this.goCollect();
    }

    public void goCollect() {
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = this.root.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            List list;
            File file;
            String string = null;
            try {
                string = stringArray[i].trim();
                if (string.length() == 0) continue;
                Object var5_6 = null;
                file = new File(new URI(string));
                list = Utilities.getFilesWithExtension((File)file, (String)this.docType.toString(), null);
                arrayList.addAll(list);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                if (string == null) continue;
                file = new File(string);
                list = Utilities.getFilesWithExtension((File)file, (String)this.docType.toString(), null);
                arrayList.addAll(list);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (string == null) continue;
                file = new File(string);
                list = Utilities.getFilesWithExtension((File)file, (String)this.docType.toString(), null);
                arrayList.addAll(list);
            }
        }
        Map<File, List<String>> map = this.getAllExternalRefs(arrayList, this.docType);
        this.analyzeResult(map);
        this.makeGoodFileList();
    }

    public Map<File, List<String>> getAllExternalRefs(List<File> list, Utilities.DocumentTypesEnum documentTypesEnum) {
        HashMap<File, List<String>> hashMap = new HashMap<File, List<String>>();
        for (File file : list) {
            DocumentTypeParser documentTypeParser = DocumentParserFactory.getParser((Utilities.DocumentTypesEnum)documentTypesEnum);
            List list2 = null;
            try {
                list2 = documentTypeParser.getAllLocationOfReferencedEntities(file);
            }
            catch (Exception exception) {
                list2 = Collections.emptyList();
            }
            hashMap.put(file, list2);
        }
        return hashMap;
    }

    public void analyzeResult(Map<File, List<String>> map) {
        for (File file : map.keySet()) {
            List<String> list = map.get(file);
            if (list.size() <= 0) {
                this.placeInProperBucket(file, new InfoEntry(null, InfoType.relative_ok));
                continue;
            }
            for (String string : list) {
                InfoEntry infoEntry = this.analyze(file, string);
                this.placeInProperBucket(file, infoEntry);
            }
        }
    }

    public void placeInProperBucket(File file, InfoEntry infoEntry) {
        InfoType infoType = infoEntry.getInfoType();
        this.placeIn(this.allFiles2Info, file, infoEntry);
        switch (infoType) {
            case url: {
                this.placeIn(this.absURL2Info, file, infoEntry);
                break;
            }
            case absolute_ok: 
            case absolute_bad: 
            case bad_uri: 
            case relative_notfound: {
                this.placeIn(this.warningFiles2Info, file, infoEntry);
                break;
            }
            case relative_bad_found: 
            case relative_bad_not_found: {
                this.placeIn(this.errorFiles2Info, file, infoEntry);
                break;
            }
        }
    }

    public void placeIn(Map<File, List<InfoEntry>> map, File file, InfoEntry infoEntry) {
        List<InfoEntry> list = map.get(file);
        if (list == null) {
            ArrayList<InfoEntry> arrayList = new ArrayList<InfoEntry>();
            arrayList.add(infoEntry);
            map.put(file, arrayList);
        } else {
            list.add(infoEntry);
        }
    }

    public void makeGoodFileList() {
        for (File file : this.allFiles2Info.keySet()) {
            if (this.errorFiles2Info.containsKey(file)) continue;
            this.goodFileList.add(file);
        }
    }

    public InfoEntry analyze(File file, String string) {
        String string2 = file.getParentFile().toURI().toString();
        URI uRI = file.toURI();
        URI uRI2 = null;
        try {
            uRI2 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new InfoEntry(string, InfoType.bad_uri);
        }
        catch (NullPointerException nullPointerException) {
            return new InfoEntry(string, InfoType.bad_uri);
        }
        if (uRI2.isAbsolute()) {
            if (uRI2.getScheme().equalsIgnoreCase("http")) {
                return new InfoEntry(string, InfoType.url);
            }
            return new InfoEntry(string, InfoType.absolute_ok);
        }
        URI uRI3 = uRI.resolve(uRI2);
        if (uRI3.toString().startsWith(string2)) {
            File file2 = new File(uRI3);
            if (file2.isFile()) {
                return new InfoEntry(string, InfoType.relative_ok);
            }
            return new InfoEntry(string, InfoType.relative_notfound);
        }
        File file3 = new File(uRI3);
        if (file3.isFile()) {
            return new InfoEntry(string, InfoType.relative_bad_found);
        }
        return new InfoEntry(string, InfoType.relative_bad_not_found);
    }

    public List<File> getCopyableFileList() {
        return this.goodFileList;
    }

    public Map<File, List<InfoEntry>> getWarnings() {
        return this.warningFiles2Info;
    }

    public Map<File, List<InfoEntry>> getErrors() {
        return this.errorFiles2Info;
    }

    Map<File, List<InfoEntry>> getAllEntries() {
        return this.allFiles2Info;
    }

    public boolean hasErrors() {
        return this.errorFiles2Info.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warningFiles2Info.size() > 0;
    }

    public boolean hasReports() {
        return this.hasErrors() || this.hasWarnings();
    }

    public Map<File, List<InfoEntry>> getAbsURL2Info() {
        return this.absURL2Info;
    }

    public static class InfoEntry {
        String childStr;
        InfoType infoType;

        public InfoEntry(String string, InfoType infoType) {
            this.childStr = string;
            this.infoType = infoType;
        }

        public String getChildStr() {
            return this.childStr;
        }

        public InfoType getInfoType() {
            return this.infoType;
        }

        public String toString() {
            return "[Ref:" + this.childStr + ", InfoType:" + this.infoType.toString() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InfoType {
        url,
        relative_ok,
        relative_bad_found,
        relative_bad_not_found,
        relative_notfound,
        absolute_ok,
        absolute_bad,
        bad_uri;

    }
}

