/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.ComponentSerializationSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DefaultDataFlavor;
import org.netbeans.modules.vmd.api.palette.PaletteProvider;
import org.netbeans.modules.vmd.palette.PaletteItemDataNode;
import org.netbeans.modules.vmd.palette.PaletteItemDataObject;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteKit
implements Runnable,
LookupListener {
    static final String CUSTOM_CATEGORY_NAME = "custom";
    private static final String PALETTE_FOLDER_NAME = "palette";
    private WeakReference<DesignDocument> activeDocument;
    private PaletteController paletteController;
    private DNDHandler dndHandler;
    private Map<String, PaletteItemDataNode> nodesMap;
    private boolean isValidationRunning;
    private LinkedList<Lookup> validationQueue;
    private DataFolder rootFolder;
    private FileSystem fs;
    private Lookup.Result<PaletteProvider> lookupResult;
    private final AtomicBoolean requiresPaletteInit = new AtomicBoolean(false);

    PaletteKit(String string) {
        this.fs = Repository.getDefault().getDefaultFileSystem();
        this.validationQueue = new LinkedList();
        this.lookupResult = Lookup.getDefault().lookupResult(PaletteProvider.class);
        this.lookupResult.addLookupListener((LookupListener)this);
        String string2 = string + '/' + PALETTE_FOLDER_NAME;
        this.nodesMap = new HashMap<String, PaletteItemDataNode>();
        try {
            FileObject fileObject = this.fs.findResource(string2);
            if (fileObject == null) {
                FileObject fileObject2 = this.fs.findResource(string);
                if (fileObject2 == null) {
                    fileObject2 = this.fs.getRoot().createFolder(string);
                }
                fileObject = FileUtil.createFolder((FileObject)fileObject2, (String)PALETTE_FOLDER_NAME);
            }
            this.rootFolder = DataFolder.findFolder((FileObject)fileObject);
            this.rootFolder.getPrimaryFile().setAttribute("itemWidth", (Object)"120");
            this.dndHandler = new DNDHandler();
            this.paletteController = PaletteFactory.createPalette((String)string2, (PaletteActions)new Actions(), (PaletteFilter)new Filter(), (DragAndDropHandler)this.dndHandler);
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
    }

    synchronized void clean() {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        String string = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectID();
        String string2 = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)string2, (String)string);
        descriptorRegistry.readAccess(new Runnable(){

            public void run() {
                List list = descriptorRegistry.getComponentProducers();
                HashMap<String, ComponentProducer> hashMap = new HashMap<String, ComponentProducer>(list.size());
                for (ComponentProducer componentProducer : list) {
                    hashMap.put(componentProducer.getProducerID(), componentProducer);
                }
                PaletteKit.this.cleanCore(hashMap);
            }
        });
    }

    private void cleanCore(Map<String, ComponentProducer> map) {
        try {
            for (FileObject fileObject : this.rootFolder.getPrimaryFile().getChildren()) {
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    fileObject2.delete();
                }
            }
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
    }

    synchronized void refresh() {
        this.refreshFO(this.rootFolder.getPrimaryFile());
    }

    private void refreshFO(FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                this.refreshFO(fileObject2);
            }
        } else {
            fileObject.refresh();
        }
    }

    synchronized void refreshDescriptorRegistry() {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        String string = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        ComponentSerializationSupport.refreshDescriptorRegistry((String)string);
    }

    public PaletteController getPaletteController() {
        return this.paletteController;
    }

    public DragAndDropHandler getDndHandler() {
        return this.dndHandler;
    }

    void refreshPaletteController() {
        if (this.paletteController == null) {
            return;
        }
        this.paletteController.refresh();
    }

    synchronized void init() {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        if (this.requiresPaletteInit.getAndSet(true)) {
            return;
        }
        String string = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectID();
        final String string2 = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)string2, (String)string);
        descriptorRegistry.readAccess(new Runnable(){

            public void run() {
                while (PaletteKit.this.requiresPaletteInit.getAndSet(false)) {
                    Collection collection = PaletteKit.this.lookupResult.allInstances();
                    for (PaletteProvider paletteProvider : collection) {
                        if (paletteProvider == null) continue;
                        paletteProvider.initPaletteCategories(string2);
                    }
                    PaletteKit.this.initCore(descriptorRegistry.getComponentProducers());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCore(List<ComponentProducer> list) {
        FileObject[] fileObjectArray = this.rootFolder.getPrimaryFile().getChildren();
        HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>(fileObjectArray.length);
        for (Object object : fileObjectArray) {
            hashMap.put(object.getName(), (FileObject)object);
        }
        for (ComponentProducer componentProducer : list) {
            Serializable serializable;
            FileObject fileObject;
            Object object;
            if (componentProducer.getPaletteDescriptor() == null) continue;
            String string = componentProducer.getProducerID();
            object = componentProducer.getPaletteDescriptor().getCategoryID();
            if (object != null) {
                fileObject = (FileObject)hashMap.get(object);
            } else {
                fileObject = (FileObject)hashMap.get(CUSTOM_CATEGORY_NAME);
                if (fileObject == null) continue;
            }
            if (fileObject == null) {
                Debug.warning((Object[])new Object[]{(String)object + " should be initialized! See MidpPaletteProvider."});
                try {
                    fileObject = DataFolder.create((DataFolder)this.rootFolder, (String)object).getPrimaryFile();
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{"Can't create folder for palette category: " + iOException});
                }
            }
            try {
                fileObject.setAttribute("isReadonly", (Object)"true");
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{"Can't set attributes for palette category folder", iOException});
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(fileObject.getPath());
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append('.');
            stringBuffer.append("vmd_palette");
            if (this.fs.findResource(stringBuffer.toString()) != null) continue;
            try {
                FileObject fileObject2 = fileObject.createData(string, "vmd_palette");
                serializable = new Properties();
                ((Properties)serializable).setProperty("producerID", string);
                String string2 = componentProducer.getPaletteDescriptor().getDisplayName();
                ((Properties)serializable).setProperty("displayName", string2 != null ? string2 : "");
                String string3 = componentProducer.getPaletteDescriptor().getToolTip();
                ((Properties)serializable).setProperty("toolTip", string3 != null ? string3 : "");
                String string4 = componentProducer.getPaletteDescriptor().getSmallIcon();
                ((Properties)serializable).setProperty("icon", string4 != null ? string4 : "");
                String string5 = componentProducer.getPaletteDescriptor().getLargeIcon();
                ((Properties)serializable).setProperty("bigIcon", string5 != null ? string5 : "");
                FileLock fileLock = fileObject2.lock();
                OutputStream outputStream = null;
                try {
                    outputStream = fileObject2.getOutputStream(fileLock);
                    ((Properties)serializable).store(outputStream, "VMD Palette Item");
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    fileLock.releaseLock();
                }
            }
            catch (IOException iOException) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("Can't create file for palette item: ");
                ((StringBuffer)serializable).append(stringBuffer);
                ((StringBuffer)serializable).append(", ");
                ((StringBuffer)serializable).append(string);
                ((StringBuffer)serializable).append(".");
                ((StringBuffer)serializable).append("vmd_palette");
                ((StringBuffer)serializable).append(": ");
                ((StringBuffer)serializable).append(iOException);
                Debug.warning((Object[])new Object[]{((StringBuffer)serializable).toString()});
            }
        }
    }

    void checkValidity(Lookup lookup) {
        PaletteItemDataNode paletteItemDataNode = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
        assert (paletteItemDataNode != null);
        String string = paletteItemDataNode.getProducerID();
        if (string == null) {
            paletteItemDataNode.setNeedCheck(false);
            paletteItemDataNode.setValid(false);
            return;
        }
        if (!this.nodesMap.containsKey(string)) {
            this.nodesMap.put(string, paletteItemDataNode);
        }
        paletteItemDataNode.setNeedCheck(false);
        this.scheduleCheckValidityCore(lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCheckValidityCore(Lookup lookup) {
        LinkedList<Lookup> linkedList = this.validationQueue;
        synchronized (linkedList) {
            this.validationQueue.add(lookup);
            if (this.isValidationRunning) {
                return;
            }
            this.isValidationRunning = true;
        }
        RequestProcessor.getDefault().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Lookup lookup;
            LinkedList<Lookup> linkedList = this.validationQueue;
            synchronized (linkedList) {
                if (this.validationQueue.isEmpty()) {
                    this.isValidationRunning = false;
                    break;
                }
                lookup = this.validationQueue.remove();
            }
            this.checkValidityCore(lookup);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PaletteKit.this.refreshPaletteController();
            }
        });
    }

    private void checkValidityCore(Lookup lookup) {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        PaletteItemDataNode paletteItemDataNode = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
        if (paletteItemDataNode == null) {
            return;
        }
        final String string = paletteItemDataNode.getProducerID();
        String string2 = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectID();
        String string3 = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        final ComponentProducer[] componentProducerArray = new ComponentProducer[1];
        final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)string3, (String)string2);
        descriptorRegistry.readAccess(new Runnable(){

            public void run() {
                List list = descriptorRegistry.getComponentProducers();
                ComponentProducer componentProducer = null;
                for (ComponentProducer componentProducer2 : list) {
                    if (!componentProducer2.getProducerID().equals(string)) continue;
                    componentProducer = componentProducer2;
                    break;
                }
                componentProducerArray[0] = componentProducer;
            }
        });
        Boolean bl = componentProducerArray[0] != null;
        if (bl.booleanValue()) {
            bl = componentProducerArray[0].checkValidity((DesignDocument)this.activeDocument.get(), false);
        }
        paletteItemDataNode.setValid(bl == null || bl != false);
    }

    void clearNodesStateCache() {
        for (PaletteItemDataNode paletteItemDataNode : this.nodesMap.values()) {
            paletteItemDataNode.setNeedCheck(true);
            paletteItemDataNode.setValid(true);
        }
    }

    void setActiveDocument(DesignDocument designDocument) {
        this.activeDocument = new WeakReference<DesignDocument>(designDocument);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.init();
    }

    private class DNDHandler
    extends DragAndDropHandler {
        private DNDHandler() {
        }

        public void customize(final ExTransferable exTransferable, Lookup lookup) {
            if (PaletteKit.this.activeDocument == null || PaletteKit.this.activeDocument.get() == null) {
                return;
            }
            PaletteItemDataObject paletteItemDataObject = (PaletteItemDataObject)((Object)lookup.lookup(PaletteItemDataObject.class));
            if (paletteItemDataObject == null) {
                return;
            }
            final String string = paletteItemDataObject.getProducerID();
            String string2 = ((DesignDocument)PaletteKit.this.activeDocument.get()).getDocumentInterface().getProjectID();
            String string3 = ((DesignDocument)PaletteKit.this.activeDocument.get()).getDocumentInterface().getProjectType();
            final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)string3, (String)string2);
            descriptorRegistry.readAccess(new Runnable(){

                public void run() {
                    List list = descriptorRegistry.getComponentProducers();
                    final ComponentProducer[] componentProducerArray = new ComponentProducer[1];
                    for (ComponentProducer componentProducer : list) {
                        if (!componentProducer.getProducerID().equals(string)) continue;
                        componentProducerArray[0] = componentProducer;
                        break;
                    }
                    if (componentProducerArray[0] != null) {
                        DefaultDataFlavor defaultDataFlavor = new DefaultDataFlavor(componentProducerArray[0]);
                        exTransferable.put(new ExTransferable.Single((DataFlavor)defaultDataFlavor){

                            protected Object getData() {
                                return componentProducerArray[0].getProducerID();
                            }
                        });
                    }
                }
            });
        }
    }

    private class Filter
    extends PaletteFilter {
        private Filter() {
        }

        public boolean isValidCategory(Lookup lookup) {
            return true;
        }

        public boolean isValidItem(Lookup lookup) {
            PaletteItemDataNode paletteItemDataNode = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
            return paletteItemDataNode == null || paletteItemDataNode.isValid();
        }
    }

    private class Actions
    extends PaletteActions {
        private Actions() {
        }

        public Action[] getImportActions() {
            if (PaletteKit.this.activeDocument == null || PaletteKit.this.activeDocument.get() == null) {
                return null;
            }
            String string = ((DesignDocument)PaletteKit.this.activeDocument.get()).getDocumentInterface().getProjectType();
            Collection collection = Lookup.getDefault().lookupAll(PaletteProvider.class);
            ArrayList<? extends Action> arrayList = new ArrayList<Action>();
            for (PaletteProvider paletteProvider : collection) {
                List<? extends Action> list = paletteProvider.getActions(string);
                if (list == null) continue;
                arrayList.addAll(list);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public Action[] getCustomPaletteActions() {
            return new Action[0];
        }

        public Action[] getCustomCategoryActions(Lookup lookup) {
            return new Action[0];
        }

        public Action[] getCustomItemActions(Lookup lookup) {
            return new Action[0];
        }

        public Action getPreferredAction(Lookup lookup) {
            return null;
        }

        public Action getRefreshAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PaletteKit.this.refreshDescriptorRegistry();
                    PaletteKit.this.refresh();
                }
            };
        }

        public Action getResetAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PaletteKit.this.refreshDescriptorRegistry();
                    try {
                        PaletteKit.this.fs.runAtomicAction(new FileSystem.AtomicAction(){

                            public void run() {
                                PaletteKit.this.clean();
                                PaletteKit.this.init();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        Debug.warning((Object[])new Object[]{iOException});
                    }
                }
            };
        }
    }
}

