/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JTextField;

public class DNDTextField
extends JTextField
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private Object mUserObject;
    private DropTarget mDropTarget = null;
    private DragSource mDragSource = null;
    protected DataFlavor[] mDataFlavorArray = new DataFlavor[1];

    public DNDTextField() {
        this.init();
    }

    protected void init() {
        this.mDropTarget = new DropTarget(this, this);
        this.mDragSource = new DragSource();
        this.mDragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.mDataFlavorArray[0] = DataFlavor.stringFlavor;
        this.setDragEnabled(true);
    }

    public void setUserObject(Object object) {
        this.mUserObject = object;
    }

    public void setTextField(Object object) {
        this.setText((String)object);
    }

    public Object getUserObject() {
        return this.mUserObject;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object object = this.mUserObject;
        if (object != null) {
            StringSelection stringSelection = new StringSelection(object.toString());
            this.mDragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, stringSelection, this);
        } else {
            System.out.println("nothing was selected");
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.mDataFlavorArray[0])) {
                dropTargetDropEvent.acceptDrop(1);
                Object object = transferable.getTransferData(this.mDataFlavorArray[0]);
                this.setUserObject(object);
                this.setTextField(object);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Exception" + iOException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            System.err.println("Exception" + unsupportedFlavorException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            System.out.println(" dragDropEnd -> DropSuccess");
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

