/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.basicmapper;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.exception.MapperException;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteManager;

public abstract class BasicMapperFactory {
    public static final String DEFAULT_MAPPER_CLASS_NAME = "org.netbeans.modules.soa.mapper.basicmapper.BasicMapper";
    public static final String DEFAULT_PALETTE_CLASS_NAME = "org.netbeans.modules.soa.mapper.common.palette.PaletteManager";

    public static IBasicMapper createBasicMapper() throws MapperException {
        return BasicMapperFactory.createBasicMapper(BasicMapperFactory.class.getClassLoader());
    }

    public static IBasicMapper createBasicMapper(ClassLoader classLoader) throws MapperException {
        String string = System.getProperty("org.netbeans.modules.soa.mapper.class");
        if (string == null) {
            string = DEFAULT_MAPPER_CLASS_NAME;
        }
        if (classLoader == null) {
            throw new MapperException("Unable to create basic mapper from class " + string + ". The class loader is null");
        }
        try {
            return (IBasicMapper)Class.forName(string, false, classLoader).newInstance();
        }
        catch (Throwable throwable) {
            throw new MapperException("Unable to create basic mapper from class " + string, throwable);
        }
    }

    public static IPaletteManager createPaletteManager(String string) throws MapperException {
        return BasicMapperFactory.createPaletteManager(string, BasicMapperFactory.class.getClassLoader());
    }

    public static IPaletteManager createPaletteManager(String string, ClassLoader classLoader) throws MapperException {
        if (string == null) {
            throw new MapperException("Unable to create palette manager. The folder name is null");
        }
        if (classLoader == null) {
            throw new MapperException("Unable to create palette manager. The class loader is null");
        }
        String string2 = System.getProperty("org.netbeans.modules.soa.mapper.palette.class");
        if (string2 == null) {
            string2 = DEFAULT_PALETTE_CLASS_NAME;
        }
        try {
            IPaletteManager iPaletteManager = (IPaletteManager)Class.forName(string2, false, classLoader).newInstance();
            iPaletteManager.setFolder(string);
            return iPaletteManager;
        }
        catch (Throwable throwable) {
            throw new MapperException("Unable to create palette manager from class: " + string2 + " and initialize with folder " + string, throwable);
        }
    }
}

