/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.literal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.modules.soa.mapper.basicmapper.literal.AbstractLiteralEditor;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;

public class BasicStringLiteralEditor
extends AbstractLiteralEditor {
    private static final int MAXIMUM_WIDTH = 300;
    private static final int MAXIMUM_HEIGHT = 200;
    private JTextArea mEditorComponent;
    private JScrollPane mScroller;
    private boolean mResized = false;

    public BasicStringLiteralEditor(Window window, IBasicMapper iBasicMapper, IFieldNode iFieldNode, ILiteralUpdater iLiteralUpdater) {
        super(window, iBasicMapper, iFieldNode, iLiteralUpdater);
        this.setLocation(this.getLocation().x, this.getLocation().y);
        this.mEditorComponent = new JTextArea();
        this.mEditorComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                        BasicStringLiteralEditor.this.enterPressed();
                    } else {
                        try {
                            int n = BasicStringLiteralEditor.this.mEditorComponent.getCaretPosition();
                            if (n < 0) {
                                n = BasicStringLiteralEditor.this.mEditorComponent.getDocument().getEndPosition().getOffset();
                            }
                            BasicStringLiteralEditor.this.mEditorComponent.getDocument().insertString(n, "\n", null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    keyEvent.consume();
                }
            }
        });
        this.mEditorComponent.setWrapStyleWord(true);
        this.mEditorComponent.selectAll();
        this.mScroller = new JScrollPane(this.mEditorComponent, 21, 31);
        this.mEditorComponent.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicStringLiteralEditor.this.ensureBounds();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BasicStringLiteralEditor.this.ensureBounds();
            }
        });
        this.initializeLiteralComponent(iBasicMapper.getMapperViewManager().getCanvasView(), this.mScroller, this.mEditorComponent);
        this.mScroller.setBackground(Color.white);
        if (this.mIsLiteralMethoid) {
            this.mScroller.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.mEditorComponent.setBorder(null);
        } else {
            this.mScroller.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.mEditorComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        }
        this.getContentPane().add(this.mScroller);
        this.mEditorComponent.setText(iFieldNode.getLiteralName());
        this.ensureBounds();
        this.mEditorComponent.selectAll();
        this.mEditorComponent.setCaretPosition(this.mEditorComponent.getDocument().getEndPosition().getOffset() - 1);
        this.mEditorComponent.moveCaretPosition(0);
        this.mEditorComponent.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
    }

    private void ensureBounds() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension dimension = BasicStringLiteralEditor.this.getSize();
                BasicStringLiteralEditor.this.mEditorComponent.setLineWrap(false);
                Dimension dimension2 = BasicStringLiteralEditor.this.mScroller.getPreferredSize();
                if (dimension2.width > 300) {
                    BasicStringLiteralEditor.this.mEditorComponent.setLineWrap(true);
                    dimension2 = BasicStringLiteralEditor.this.mScroller.getPreferredSize();
                    dimension2.width = 300;
                }
                if (dimension2.height > 200) {
                    BasicStringLiteralEditor.this.mScroller.setVerticalScrollBarPolicy(21);
                    dimension2.height = 200;
                } else {
                    BasicStringLiteralEditor.this.mScroller.setVerticalScrollBarPolicy(21);
                }
                dimension2.width = Math.max(dimension2.width, dimension.width);
                dimension2.height = Math.max(dimension2.height, dimension.height);
                if (((BasicStringLiteralEditor)BasicStringLiteralEditor.this).mScroller.getViewport().getVisibleRect().width < dimension2.width || ((BasicStringLiteralEditor)BasicStringLiteralEditor.this).mScroller.getViewport().getVisibleRect().height < dimension2.height) {
                    BasicStringLiteralEditor.this.setSize(dimension2);
                    BasicStringLiteralEditor.this.mScroller.setSize(dimension2);
                    BasicStringLiteralEditor.this.validate();
                }
            }
        });
    }

    protected Dimension getInitialSize() {
        Dimension dimension = this.mCanvasFieldNode.getBounding().getSize();
        return new Dimension(Math.min(dimension.width - 3, 300), Math.min(dimension.height - 1, 200));
    }

    protected String updateLiteral() {
        return this.mEditorComponent.getText();
    }

    private void switchKeyStrokeAction(JTextComponent jTextComponent, KeyStroke keyStroke, KeyStroke keyStroke2) {
        Keymap keymap = jTextComponent.getKeymap();
        Action action = keymap.getAction(keyStroke);
        keymap.removeKeyStrokeBinding(keyStroke);
        if (action != null) {
            keymap.addActionForKeyStroke(keyStroke2, action);
        }
    }

    public void commitEdit() {
    }

    void enterPressed() {
        super.commitEdit();
    }
}

