/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasFieldNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasNodeToNodeLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasNodeToTreeLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasTreeToNodeLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasTreeToTreeLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.NetworkHighlightConstants;
import org.netbeans.modules.soa.mapper.basicmapper.tree.BasicMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;

public class NetworkHighlightTraverser
implements NetworkHighlightConstants {
    private boolean mIsHighlighting;
    private boolean mIsDetecting;
    private List mVisitedLinks;
    private List mVisitedMethoids;

    public NetworkHighlightTraverser(boolean bl) {
        this.mIsHighlighting = bl;
        this.mVisitedLinks = new ArrayList();
        this.mVisitedMethoids = new ArrayList();
    }

    public void visit(ICanvasMethoidNode iCanvasMethoidNode) {
        this.mVisitedMethoids.add(iCanvasMethoidNode);
        this.changeMethoidNodeHighlight(iCanvasMethoidNode);
        Collection collection = iCanvasMethoidNode.getNodes();
        for (JGoObject jGoObject : collection) {
            if (!(jGoObject instanceof ICanvasFieldNode)) continue;
            ICanvasFieldNode iCanvasFieldNode = (ICanvasFieldNode)jGoObject;
            this.visit(iCanvasFieldNode);
        }
    }

    private void visit(ICanvasFieldNode iCanvasFieldNode) {
        ICanvasMapperLink iCanvasMapperLink;
        JGoLink jGoLink;
        ICanvasMethoidNode iCanvasMethoidNode = (ICanvasMethoidNode)iCanvasFieldNode.getContainer();
        if (!this.isMethoidVisited(iCanvasMethoidNode)) {
            this.visit(iCanvasMethoidNode);
            return;
        }
        this.changeFieldNodeHighlight(iCanvasFieldNode);
        JGoPort jGoPort = (JGoPort)iCanvasFieldNode.getConnectPointObject();
        JGoListPosition jGoListPosition = jGoPort.getFirstLinkPos();
        if (jGoListPosition != null && (jGoLink = jGoPort.getLinkAtPos(jGoListPosition)) instanceof ICanvasMapperLink && !this.isLinkVisited(iCanvasMapperLink = (ICanvasMapperLink)jGoLink)) {
            this.visit(iCanvasMapperLink);
        }
    }

    public void visit(ICanvasMapperLink iCanvasMapperLink) {
        this.mVisitedLinks.add(iCanvasMapperLink);
        this.changeLinkHighlight(iCanvasMapperLink);
        if (iCanvasMapperLink instanceof BasicCanvasNodeToNodeLink) {
            this.visit((BasicCanvasNodeToNodeLink)iCanvasMapperLink);
        } else if (iCanvasMapperLink instanceof BasicCanvasNodeToTreeLink) {
            this.visit((BasicCanvasNodeToTreeLink)iCanvasMapperLink);
        } else if (iCanvasMapperLink instanceof BasicCanvasTreeToNodeLink) {
            this.visit((BasicCanvasTreeToNodeLink)iCanvasMapperLink);
        } else if (iCanvasMapperLink instanceof BasicCanvasTreeToTreeLink) {
            this.visit((BasicCanvasTreeToTreeLink)iCanvasMapperLink);
        }
    }

    private void visit(BasicCanvasNodeToNodeLink basicCanvasNodeToNodeLink) {
        if (basicCanvasNodeToNodeLink.getSourceFieldNode() != null) {
            this.visit(basicCanvasNodeToNodeLink.getSourceFieldNode());
        }
        if (basicCanvasNodeToNodeLink.getDestFieldNode() != null) {
            this.visit(basicCanvasNodeToNodeLink.getDestFieldNode());
        }
    }

    private void visit(BasicCanvasNodeToTreeLink basicCanvasNodeToTreeLink) {
        if (basicCanvasNodeToTreeLink.getSourceFieldNode() != null) {
            this.visit(basicCanvasNodeToTreeLink.getSourceFieldNode());
        }
        if (basicCanvasNodeToTreeLink.getDestTreeAddress() != null) {
            this.visit(basicCanvasNodeToTreeLink.getDestTreeAddress());
        }
    }

    private void visit(BasicCanvasTreeToNodeLink basicCanvasTreeToNodeLink) {
        if (basicCanvasTreeToNodeLink.getSourceTreeAddress() != null) {
            this.visit(basicCanvasTreeToNodeLink.getSourceTreeAddress());
        }
        if (basicCanvasTreeToNodeLink.getDestFieldNode() != null) {
            this.visit(basicCanvasTreeToNodeLink.getDestFieldNode());
        }
    }

    private void visit(BasicCanvasTreeToTreeLink basicCanvasTreeToTreeLink) {
        if (basicCanvasTreeToTreeLink.getSourceTreeAddress() != null) {
            this.visit(basicCanvasTreeToTreeLink.getSourceTreeAddress());
        }
        if (basicCanvasTreeToTreeLink.getDestTreeAddress() != null) {
            this.visit(basicCanvasTreeToTreeLink.getDestTreeAddress());
        }
    }

    private void visit(IMapperTreeNode iMapperTreeNode) {
        this.changeTreeNodeHighlight(iMapperTreeNode);
    }

    private boolean isLinkVisited(ICanvasMapperLink iCanvasMapperLink) {
        return this.mVisitedLinks.contains(iCanvasMapperLink);
    }

    private boolean isMethoidVisited(ICanvasMethoidNode iCanvasMethoidNode) {
        return this.mVisitedMethoids.contains(iCanvasMethoidNode);
    }

    private void changeLinkHighlight(ICanvasMapperLink iCanvasMapperLink) {
        if (this.mIsHighlighting) {
            iCanvasMapperLink.startHighlighting();
        } else {
            iCanvasMapperLink.stopHighlighting();
        }
    }

    private void changeMethoidNodeHighlight(ICanvasMethoidNode iCanvasMethoidNode) {
        if (iCanvasMethoidNode instanceof BasicCanvasMethoidNode) {
            BasicCanvasMethoidNode basicCanvasMethoidNode = (BasicCanvasMethoidNode)iCanvasMethoidNode;
            if (this.mIsHighlighting) {
                basicCanvasMethoidNode.setTitleBarColor(COLOR_NODE_SELECTED);
            } else {
                basicCanvasMethoidNode.resetTitleBarColor();
            }
        }
    }

    private void changeFieldNodeHighlight(ICanvasFieldNode iCanvasFieldNode) {
        if (iCanvasFieldNode instanceof BasicCanvasFieldNode) {
            BasicCanvasFieldNode basicCanvasFieldNode = (BasicCanvasFieldNode)iCanvasFieldNode;
            basicCanvasFieldNode.setHighlight(this.mIsHighlighting);
        }
    }

    private void changeTreeNodeHighlight(IMapperTreeNode iMapperTreeNode) {
        if (iMapperTreeNode instanceof BasicMapperTreeNode) {
            BasicMapperTreeNode basicMapperTreeNode = (BasicMapperTreeNode)iMapperTreeNode;
            if (this.mIsHighlighting) {
                basicMapperTreeNode.addToSelection();
            } else {
                basicMapperTreeNode.removeFromSelection();
            }
        }
    }
}

